/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.log.SkinLogger;

public class CustomProgressBar
extends Canvas {
    public static final RGB PROGRESS_COLOR_0 = new RGB(0, 174, 239);
    public static final RGB PROGRESS_COLOR_1 = new RGB(179, 246, 0);
    private Logger logger = SkinLogger.getSkinLogger(CustomProgressBar.class).getLogger();
    private EmulatorSkin skin;
    private Composite parent;
    private boolean isDual;
    private int[] selection;
    private Color[] colorProgress;

    public CustomProgressBar(EmulatorSkin skin, int style, boolean isDual) {
        super((Composite)skin.getShell(), style);
        this.skin = skin;
        this.parent = skin.getShell();
        this.isDual = isDual;
        this.selection = new int[2];
        this.selection[1] = 0;
        this.selection[0] = 0;
        this.colorProgress = new Color[2];
        this.colorProgress[0] = new Color((Device)this.parent.getDisplay(), PROGRESS_COLOR_0);
        if (isDual) {
            this.logger.info("dual progress bar is created");
            this.colorProgress[1] = new Color((Device)this.parent.getDisplay(), PROGRESS_COLOR_1);
        } else {
            this.logger.info("single progress bar is created");
        }
        this.addProgressBarListener();
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CustomProgressBar.this.isDisposed()) {
                    CustomProgressBar.this.setVisible(false);
                }
            }
        });
    }

    protected void addProgressBarListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int width;
                Rectangle bounds;
                if (CustomProgressBar.this.isDual) {
                    e.gc.setBackground(CustomProgressBar.this.colorProgress[1]);
                    bounds = CustomProgressBar.this.getBounds();
                    width = bounds.width * CustomProgressBar.this.selection[1] / 100;
                    e.gc.fillRectangle(0, 0, Math.min(bounds.width, width), bounds.height);
                }
                e.gc.setBackground(CustomProgressBar.this.colorProgress[0]);
                bounds = CustomProgressBar.this.getBounds();
                width = bounds.width * CustomProgressBar.this.selection[0] / 100;
                e.gc.fillRectangle(0, 0, Math.min(bounds.width, width), bounds.height);
                if (!(CustomProgressBar.this.selection[0] != 101 || CustomProgressBar.this.isDual && CustomProgressBar.this.selection[1] != 101)) {
                    CustomProgressBar.this.logger.info("progress : complete!");
                    CustomProgressBar.this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CustomProgressBar.this.dispose();
                        }
                    });
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CustomProgressBar.this.logger.info("progress bar is disposed");
                CustomProgressBar.this.colorProgress[0].dispose();
                if (CustomProgressBar.this.isDual) {
                    CustomProgressBar.this.colorProgress[1].dispose();
                }
                ((CustomProgressBar)CustomProgressBar.this).skin.bootingProgress = null;
            }
        });
    }

    public void setSelection(int idxLayer, int value) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isVisible()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!CustomProgressBar.this.isDisposed()) {
                        CustomProgressBar.this.setVisible(true);
                    }
                }
            });
        }
        if (idxLayer < 0 || !this.isDual) {
            idxLayer = 0;
        } else if (idxLayer > 1) {
            idxLayer = 1;
        }
        if (value < 0) {
            value = 0;
        } else if (value > 100) {
            value = 100;
        }
        this.selection[idxLayer] = value;
        this.logger.info("layer" + idxLayer + " progress : " + this.selection[idxLayer]);
        final int index = idxLayer;
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CustomProgressBar.this.redraw();
                if (CustomProgressBar.this.selection[index] == 100) {
                    ((CustomProgressBar)CustomProgressBar.this).selection[index] = 101;
                }
            }
        });
    }

    public int getSelection(int idxLayer) {
        return this.selection[idxLayer];
    }
}

