/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.tizen.emulator.skin.custom.CustomButton;
import org.tizen.emulator.skin.custom.CustomScrollBarShaftData;
import org.tizen.emulator.skin.custom.CustomScrollBarThumbData;
import org.tizen.emulator.skin.custom.CustomScrolledComposite;
import org.tizen.emulator.skin.log.SkinLogger;

public class CustomScrollBar {
    static final int SCROLL_INCREMENT_AMOUNT = 10;
    static final int SCROLL_PAGE_INCREMENT_AMOUNT = 144;
    private Logger logger = SkinLogger.getSkinLogger(CustomScrollBar.class).getLogger();
    private Composite parent;
    private Composite composite;
    CustomScrolledComposite compositeScroll;
    private int heightScrollBar;
    private int amountIncrement;
    private int amountPageIncrement;
    private Image[] imagesArrowUp;
    private Image[] imagesArrowDown;
    private Image imageThumb;
    private Image imageShaft;
    private CustomButton buttonArrowUp;
    private CustomButton buttonArrowDown;
    private Canvas canvasShaft;
    private CustomScrollBarThumbData dataThumb;
    private CustomScrollBarShaftData dataShaft;
    private int valueSelection;
    private Timer timerScroller;

    CustomScrollBar(Composite parent, int style, int heightScrollBar, Image[] imagesArrowUp, Image[] imagesArrowDown, Image imageThumb, Image imageShaft) {
        this.parent = parent;
        this.composite = new Composite(parent, 0);
        this.compositeScroll = (CustomScrolledComposite)parent.getParent();
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginHeight = 0;
        rowLayout.marginWidth = 0;
        rowLayout.spacing = 0;
        this.composite.setLayout((Layout)rowLayout);
        this.heightScrollBar = heightScrollBar;
        this.amountIncrement = 10;
        this.amountPageIncrement = 144;
        this.imagesArrowUp = imagesArrowUp;
        this.imagesArrowDown = imagesArrowDown;
        this.imageThumb = imageThumb;
        this.imageShaft = imageShaft;
        this.dataThumb = new CustomScrollBarThumbData();
        this.dataShaft = new CustomScrollBarShaftData();
        this.timerScroller = null;
        this.createContents();
        this.addScrollBarListener();
    }

    protected void createContents() {
        this.buttonArrowUp = new CustomButton(this.composite, 0, this.imagesArrowUp[0], this.imagesArrowUp[1], this.imagesArrowUp[2]);
        int width = this.buttonArrowUp.getImageSize().x;
        int height = this.buttonArrowUp.getImageSize().y;
        this.buttonArrowUp.setBackground(this.parent.getBackground());
        this.buttonArrowUp.setLayoutData(new RowData(width, height));
        this.canvasShaft = new Canvas(this.composite, 0);
        this.canvasShaft.setBackground(this.parent.getBackground());
        this.dataShaft.widthShaft = width;
        this.dataShaft.heightShaft = this.heightScrollBar - height * 2;
        this.canvasShaft.setLayoutData((Object)new RowData(this.dataShaft.widthShaft, this.dataShaft.heightShaft));
        this.canvasShaft.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (CustomScrollBar.this.imageShaft != null) {
                    e.gc.drawImage(CustomScrollBar.this.imageShaft, 0, 0, ((CustomScrollBar)CustomScrollBar.this).imageShaft.getImageData().width, ((CustomScrollBar)CustomScrollBar.this).imageShaft.getImageData().height, 0, 0, ((CustomScrollBar)CustomScrollBar.this).dataShaft.widthShaft, ((CustomScrollBar)CustomScrollBar.this).dataShaft.heightShaft);
                    int heightScrollGap = CustomScrollBar.this.compositeScroll.getMinHeight() - CustomScrollBar.this.heightScrollBar;
                    int tempHeightThumb = (CustomScrollBar.this.compositeScroll.getMinHeight() - heightScrollGap) * ((CustomScrollBar)CustomScrollBar.this).dataShaft.heightShaft / CustomScrollBar.this.compositeScroll.getMinHeight();
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.height = Math.max(1, tempHeightThumb);
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.x = 2;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.y = CustomScrollBar.this.getSelection() * (((CustomScrollBar)CustomScrollBar.this).dataShaft.heightShaft - ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.height) / heightScrollGap;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.width = ((CustomScrollBar)CustomScrollBar.this).dataShaft.widthShaft - ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.x * 2;
                    e.gc.drawImage(CustomScrollBar.this.imageThumb, 0, 0, ((CustomScrollBar)CustomScrollBar.this).imageThumb.getImageData().width, ((CustomScrollBar)CustomScrollBar.this).imageThumb.getImageData().height, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.x, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.y, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.width, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.height);
                }
            }
        });
        this.buttonArrowDown = new CustomButton(this.composite, 0, this.imagesArrowDown[0], this.imagesArrowDown[1], this.imagesArrowDown[2]);
        this.buttonArrowDown.setBackground(this.parent.getBackground());
        this.buttonArrowDown.setLayoutData(new RowData(width, height));
    }

    private void updateScrollbar() {
        this.compositeScroll.vScroll();
        this.canvasShaft.redraw();
    }

    private void scrollUp(int amount) {
        if (amount == 0) {
            return;
        }
        this.setSelection(this.getSelection() - amount);
        this.updateScrollbar();
    }

    private void scrollDown(int amount) {
        if (amount == 0) {
            return;
        }
        this.setSelection(this.getSelection() + amount);
        this.updateScrollbar();
    }

    protected void addScrollBarListener() {
        this.buttonArrowUp.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                CustomScrollBar.this.scrollUp(CustomScrollBar.this.amountIncrement);
            }

            public void mouseUp(MouseEvent e) {
                if (CustomScrollBar.this.timerScroller != null) {
                    CustomScrollBar.this.timerScroller.cancel();
                    CustomScrollBar.this.timerScroller = null;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.buttonArrowUp.addDragDetectListener(new DragDetectListener(){

            public void dragDetected(DragDetectEvent e) {
                CustomScrollBar.this.logger.info("ArrowUp dragDetected : " + e.button);
                if (CustomScrollBar.this.timerScroller != null) {
                    CustomScrollBar.this.timerScroller.cancel();
                }
                CustomScrollBar.this.timerScroller = new Timer();
                CustomScrollBar.this.timerScroller.schedule((TimerTask)new ScrollerTask(false), 1L, 60L);
            }
        });
        this.buttonArrowDown.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                CustomScrollBar.this.scrollDown(CustomScrollBar.this.amountIncrement);
            }

            public void mouseUp(MouseEvent e) {
                if (CustomScrollBar.this.timerScroller != null) {
                    CustomScrollBar.this.timerScroller.cancel();
                    CustomScrollBar.this.timerScroller = null;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.buttonArrowDown.addDragDetectListener(new DragDetectListener(){

            public void dragDetected(DragDetectEvent e) {
                CustomScrollBar.this.logger.info("ArrowDown dragDetected : " + e.button);
                if (CustomScrollBar.this.timerScroller != null) {
                    CustomScrollBar.this.timerScroller.cancel();
                }
                CustomScrollBar.this.timerScroller = new Timer();
                CustomScrollBar.this.timerScroller.schedule((TimerTask)new ScrollerTask(true), 1L, 60L);
            }
        });
        this.compositeScroll.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (e.count > 0) {
                    CustomScrollBar.this.scrollUp(CustomScrollBar.this.amountIncrement);
                } else {
                    CustomScrollBar.this.scrollDown(CustomScrollBar.this.amountIncrement);
                }
            }
        });
        this.canvasShaft.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (((CustomScrollBar)CustomScrollBar.this).dataThumb.isGrabbed) {
                    int yDragged = e.y - ((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabPosition;
                    int yDraggedScale = yDragged * (CustomScrollBar.this.compositeScroll.getMinHeight() - CustomScrollBar.this.heightScrollBar) / (((CustomScrollBar)CustomScrollBar.this).dataShaft.heightShaft - ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.height);
                    CustomScrollBar.this.setSelection(((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabSelection + yDraggedScale);
                    CustomScrollBar.this.updateScrollbar();
                }
            }
        });
        this.canvasShaft.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Rectangle rectThumb = new Rectangle(0, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.y, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.width + 2, ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.height);
                if (rectThumb.contains(e.x, e.y)) {
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.isGrabbed = true;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabPosition = e.y;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabSelection = CustomScrollBar.this.getSelection();
                } else if (e.y < ((CustomScrollBar)CustomScrollBar.this).dataThumb.boundsThumb.y) {
                    CustomScrollBar.this.scrollUp(CustomScrollBar.this.amountPageIncrement);
                } else {
                    CustomScrollBar.this.scrollDown(CustomScrollBar.this.amountPageIncrement);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (((CustomScrollBar)CustomScrollBar.this).dataThumb.isGrabbed) {
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.isGrabbed = false;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabPosition = 0;
                    ((CustomScrollBar)CustomScrollBar.this).dataThumb.yGrabSelection = 0;
                }
            }
        });
    }

    public int getSelection() {
        return this.valueSelection;
    }

    public void setSelection(int selection) {
        this.valueSelection = selection;
        if (this.valueSelection < 0) {
            this.valueSelection = 0;
        } else {
            int maxScroll = this.compositeScroll.getMinHeight() - this.heightScrollBar;
            this.valueSelection = Math.min(selection, maxScroll);
        }
    }

    class ScrollerTask
    extends TimerTask {
        static final int SCROLLER_PERIOD_TIME = 60;
        private boolean isScrollDown;

        ScrollerTask(boolean isDown) {
            this.isScrollDown = isDown;
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ScrollerTask.this.isScrollDown) {
                        CustomScrollBar.this.scrollDown(CustomScrollBar.this.amountIncrement * 2);
                    } else {
                        CustomScrollBar.this.scrollUp(CustomScrollBar.this.amountIncrement * 2);
                    }
                }
            });
        }
    }
}

