/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.emulator.skin.custom.CustomScrolledComposite;
import org.tizen.emulator.skin.log.SkinLogger;

class ScrolledCompositeLayout
extends Layout {
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    private Logger logger = SkinLogger.getSkinLogger(ScrolledCompositeLayout.class).getLogger();
    private boolean inLayout = false;

    ScrolledCompositeLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        CustomScrolledComposite sc = (CustomScrolledComposite)composite;
        Point size = new Point(64, 64);
        if (sc.content != null) {
            Point preferredSize = sc.content.computeSize(wHint, hHint, flushCache);
            size.x = preferredSize.x;
            size.y = preferredSize.y;
        }
        size.x = Math.max(size.x, sc.minWidth);
        size.y = Math.max(size.y, sc.minHeight);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (this.inLayout) {
            return;
        }
        this.logger.info("layouting");
        CustomScrolledComposite sc = (CustomScrolledComposite)composite;
        if (sc.content == null) {
            return;
        }
        this.inLayout = true;
        Rectangle contentRect = sc.content.getBounds();
        Rectangle hostRect = sc.getClientArea();
        if (sc.expandHorizontal) {
            contentRect.width = Math.max(sc.minWidth, hostRect.width);
        }
        if (sc.expandVertical) {
            contentRect.height = Math.max(sc.minHeight, hostRect.height);
        }
        sc.content.setBounds(contentRect);
        Point size = sc.compositeRight.computeSize(-1, -1);
        sc.compositeRight.setBounds(contentRect.width - size.x, 0, size.x, contentRect.height);
        this.inLayout = false;
    }
}

