/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dialog.SkinDialog;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class AboutDialog
extends SkinDialog {
    public static final String ABOUT_DIALOG_TITLE = "About Emulator";
    public static final String SDK_NAME = "Tizen Emulator for 2.3";
    public static final String ABOUT_PROP_FILENAME = "about.properties";
    public static final String PROP_KEY_VERSION = "version";
    public static final String PROP_KEY_BUILD_TIME = "build_time";
    public static final String PROP_KEY_GIT_VERSION = "build_git_commit";
    public static final String URL_TIZEN_ORG = "https://developer.tizen.org";
    private Logger logger = SkinLogger.getSkinLogger(AboutDialog.class).getLogger();
    private Image aboutImage;
    private EmulatorConfig config;
    private ImageRegistry imageRegistry;

    public AboutDialog(Shell parent, EmulatorConfig config, ImageRegistry imageRegistry) {
        super(parent, 67680, ABOUT_DIALOG_TITLE);
        this.config = config;
        this.imageRegistry = imageRegistry;
    }

    private GridLayout getNopaddedGridLayout(int numColumns, boolean makeColumnEqualWidth) {
        GridLayout layout = new GridLayout(numColumns, makeColumnEqualWidth);
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    @Override
    protected void createComposite() {
        Composite parent = new Composite((Composite)this.shell, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = this.getNopaddedGridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        Composite area = this.createArea(parent);
        if (null == area) {
            return;
        }
        this.buttonComposite = new Composite(parent, 0);
        this.buttonComposite.setLayoutData((Object)new GridData(131072, 1024, true, true));
        this.buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.createButtons(this.buttonComposite);
    }

    @Override
    protected Composite createArea(Composite parent) {
        Composite composite = this.displayInfo(parent);
        return composite;
    }

    private Composite displayInfo(Composite parent) {
        Composite compositeBase = new Composite(parent, 2048);
        compositeBase.setLayoutData((Object)new GridData(4, 4, true, false));
        compositeBase.setLayout((Layout)this.getNopaddedGridLayout(2, false));
        Color white = Display.getCurrent().getSystemColor(1);
        compositeBase.setBackground(white);
        Composite compositeLeft = new Composite(compositeBase, 0);
        compositeLeft.setLayout((Layout)this.getNopaddedGridLayout(1, false));
        Label imageLabel = new Label(compositeLeft, 0);
        this.aboutImage = this.imageRegistry.getResourceImage(ImageRegistry.ResourceImageName.RESOURCE_ABOUT);
        imageLabel.setImage(this.aboutImage);
        Composite compositeRight = new Composite(compositeBase, 0);
        compositeRight.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = this.getNopaddedGridLayout(1, true);
        layout.marginRight = 6;
        layout.marginLeft = 6;
        compositeRight.setLayout((Layout)layout);
        compositeRight.setBackground(white);
        Label titleLabel = new Label(compositeRight, 0);
        titleLabel.setText("\nTizen Emulator for 2.3\n");
        titleLabel.setBackground(white);
        if (SwtUtil.isWindowsPlatform()) {
            Label space = new Label(compositeRight, 0);
            space.setText("\n");
        }
        Properties properties = this.getProperties();
        Text versionText = new Text(compositeRight, 0);
        String version = this.config.getSkinProperty("sdk.version-name");
        versionText.setText("SDK Version : " + version);
        versionText.setEditable(false);
        versionText.setBackground(white);
        Text buildText = new Text(compositeRight, 0);
        String time = this.getValue(properties, PROP_KEY_BUILD_TIME);
        if (time.isEmpty()) {
            time = "Not identified";
        }
        buildText.setText("Build ID : " + time);
        buildText.setEditable(false);
        buildText.setBackground(white);
        Link visit = new Link(compositeRight, 0);
        visit.setText("\n\n Visit <a>https://developer.tizen.org</a>");
        visit.setBackground(white);
        visit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    Program.launch((String)AboutDialog.URL_TIZEN_ORG);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        return compositeBase;
    }

    private String getValue(Properties properties, String key) {
        if (null != properties) {
            String property = properties.getProperty(key);
            if (!StringUtil.isEmpty(property)) {
                if (!property.contains(key)) {
                    return property;
                }
                return "Not identified";
            }
            return "Not identified";
        }
        return "Not identified";
    }

    @Override
    protected void createButtons(Composite parent) {
        super.createButtons(parent);
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        this.createOKButton(composite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        Properties properties;
        InputStream is;
        block5: {
            is = null;
            properties = null;
            is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(ABOUT_PROP_FILENAME);
            if (null != is) break block5;
            this.logger.severe("about properties file is null.");
            Properties properties2 = null;
            IOUtil.close(is);
            return properties2;
        }
        try {
            properties = new Properties();
            properties.load(is);
        }
        catch (IOException e) {
            Properties properties3;
            try {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                properties3 = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close(is);
            return properties3;
        }
        IOUtil.close(is);
        return properties;
    }

    @Override
    protected void close() {
        this.logger.info("close the about dialog");
    }
}

