/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.dialog;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dialog.SkinDialog;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class DetailInfoDialog
extends SkinDialog {
    private static final String DETAIL_INFO_DIALOG_TITLE = "Detail Info";
    private static final String TABLE_COLUMN_NAME_0 = "Feature";
    private static final String TABLE_COLUMN_NAME_1 = "Value";
    private static final String DATA_DELIMITER = "#";
    private static final String QEMU_PARAMETER_APPEND = "-append";
    private static final String QEMU_PARAMETER_KVM = "-enable-kvm";
    private static final String QEMU_PARAMETER_HAX = "-enable-hax";
    private static final String QEMU_PARAMETER_VIRTFS = "-virtfs";
    private static final String QEMU_PARAMETER_YAGL = "-enable-yagl";
    private static final String QEMU_PARAMETER_RAM = "-m";
    private static final String QEMU_PARAMETER_DRIVE = "-drive";
    private static final String KEY_VM_NAME = "VM Name";
    private static final String KEY_SKIN_NAME = "Skin Name";
    private static final String KEY_CPU_ARCH = "CPU";
    private static final String KEY_RAM_SIZE = "RAM Size";
    private static final String KEY_DISPLAY_RESOLUTION = "Display Resolution";
    private static final String KEY_DISPLAY_DENSITY = "Display Density";
    private static final String KEY_FILESHARING = "File Sharing";
    private static final String KEY_FILESHARED_PATH = "File Shared Path";
    private static final String KEY_CPU_VIRTUALIZATION = "CPU Virtualization";
    private static final String KEY_GPU_VIRTUALIZATION = "GPU Virtualization";
    private static final String KEY_IMAGE_PATH = "Image Path";
    private static final String KEY_LOG_PATH = "Log Path";
    private static final String VALUE_NONE = "None";
    private static final String VALUE_SUPPORTED = "Supported";
    private static final String VALUE_NOTSUPPORTED = "Not Supported";
    private static final String VALUE_ENABLED = "Enabled";
    private static final String VALUE_DISABLED = "Disabled";
    private Logger logger = SkinLogger.getSkinLogger(DetailInfoDialog.class).getLogger();
    private SocketCommunicator communicator;
    private EmulatorConfig config;
    private SkinInformation skinInfo;
    private Table table;
    private LinkedHashMap<String, String> refinedData;

    public DetailInfoDialog(Shell parent, SocketCommunicator communicator, EmulatorConfig config, SkinInformation skinInfo) {
        super(parent, 68720, "Detail Info - " + SkinUtil.makeEmulatorName(config));
        this.communicator = communicator;
        this.config = config;
        this.skinInfo = skinInfo;
    }

    @Override
    protected Composite createArea(Composite parent) {
        String infoData = this.queryData();
        if (StringUtil.isEmpty(infoData)) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.table = new Table(composite, 67586);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 16384);
        column[0].setText(TABLE_COLUMN_NAME_0);
        column[1] = new TableColumn(this.table, 16384);
        column[1].setText(TABLE_COLUMN_NAME_1);
        int index = 0;
        this.refinedData = this.composeAndParseData(infoData);
        for (Map.Entry<String, String> entry : this.refinedData.entrySet()) {
            TableItem tableItem = new TableItem(this.table, 0, index);
            tableItem.setText(new String[]{entry.getKey(), entry.getValue()});
            ++index;
        }
        column[0].pack();
        column[1].pack();
        this.table.pack();
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (DetailInfoDialog.this.table.getSelectionCount() > 1) {
                    return;
                }
                TableItem tableItem = DetailInfoDialog.this.table.getItem(DetailInfoDialog.this.table.getSelectionIndex());
                String openPath = DetailInfoDialog.VALUE_NONE;
                if (tableItem.getText(0).compareTo(DetailInfoDialog.KEY_FILESHARED_PATH) != 0 && tableItem.getText(0).compareTo(DetailInfoDialog.KEY_LOG_PATH) != 0 && !tableItem.getText(0).startsWith(DetailInfoDialog.KEY_IMAGE_PATH)) {
                    return;
                }
                openPath = tableItem.getText(1);
                if (openPath == null || openPath.compareTo(DetailInfoDialog.VALUE_NONE) == 0 || openPath.compareTo("") == 0) {
                    return;
                }
                try {
                    DetailInfoDialog.this.logger.info("open " + openPath);
                    openPath = StringUtil.getCanonicalPath(openPath);
                }
                catch (IOException e) {
                    DetailInfoDialog.this.logger.warning("Invalid path");
                }
                Program.launch((String)openPath);
            }
        });
        return composite;
    }

    @Override
    protected void setShellSize() {
        this.shell.pack();
    }

    private String queryData() {
        String infoData = null;
        SocketCommunicator.DataTranfer dataTranfer = this.communicator.sendDataToQEMU(ICommunicator.SendCommand.SEND_DETAIL_INFO_REQ, null, true);
        byte[] receivedData = this.communicator.getReceivedData(dataTranfer);
        if (null != receivedData) {
            try {
                infoData = new String(receivedData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warning("unsupported encoding exception");
                infoData = null;
            }
        } else {
            this.logger.severe("Fail to get detail info");
            SkinUtil.openMessage(this.shell, null, "Fail to get detail info", 1, this.config);
        }
        return infoData;
    }

    private LinkedHashMap<String, String> composeAndParseData(String infoData) {
        this.logger.info("Received infoData : {" + infoData + "}");
        String cpu = "x86";
        String ramSize = "";
        String dpi = "";
        ArrayList<String> imagePathList = new ArrayList<String>();
        String sharedPath = "";
        boolean isCpuVirtual = false;
        boolean isGpuVirtual = false;
        String cpuVirtualCompare = "";
        String logPath = "";
        boolean isHaxError = false;
        cpuVirtualCompare = SwtUtil.isLinuxPlatform() ? QEMU_PARAMETER_KVM : QEMU_PARAMETER_HAX;
        String[] split = infoData.split(DATA_DELIMITER);
        for (int i = 0; i < split.length; ++i) {
            String[] sp;
            if (0 == i) {
                String exec = split[i].trim().toLowerCase();
                this.logger.info("binary name:" + exec);
                continue;
            }
            if (i + 1 > split.length) continue;
            String arg = split[i].trim();
            if (QEMU_PARAMETER_RAM.equals(arg)) {
                ramSize = split[i + 1].trim();
                continue;
            }
            if (QEMU_PARAMETER_DRIVE.equals(arg)) {
                arg = split[i + 1].trim();
                if (!arg.startsWith("file=")) continue;
                sp = arg.split(",");
                String[] sp2 = sp[0].split("=");
                String drivePath = sp2[sp2.length - 1];
                imagePathList.add(drivePath);
                continue;
            }
            if (QEMU_PARAMETER_VIRTFS.equals(arg)) {
                arg = split[i + 1].trim();
                sp = arg.split(",");
                if (1 >= sp.length) continue;
                int spIndex = sp[1].indexOf("=");
                sharedPath = sp[1].substring(spIndex + 1, sp[1].length());
                continue;
            }
            if (QEMU_PARAMETER_APPEND.equals(arg)) {
                arg = split[i + 1].trim();
                String[] splitSub = arg.split(" ");
                for (int j = 0; j < splitSub.length; ++j) {
                    String[] sp2;
                    String parameterKernel = splitSub[j].trim();
                    if (!parameterKernel.startsWith("dpi=") || 1 >= (sp2 = parameterKernel.split("=")).length) continue;
                    dpi = Integer.toString(Integer.parseInt(sp2[1]) / 10);
                }
                continue;
            }
            if (cpuVirtualCompare.equals(arg)) {
                isCpuVirtual = true;
                continue;
            }
            if (QEMU_PARAMETER_YAGL.equals(arg)) {
                isGpuVirtual = true;
                continue;
            }
            if (arg.startsWith("hax_error=")) {
                sp = arg.split("=");
                if (1 >= sp.length) continue;
                isHaxError = Boolean.parseBoolean(sp[1]);
                continue;
            }
            if (!arg.startsWith("log_path=") || 1 >= (sp = arg.split("=")).length) continue;
            logPath = sp[1];
            try {
                logPath = StringUtil.getCanonicalPath(logPath);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.logger.info("log path = " + logPath);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(KEY_VM_NAME, SkinUtil.getVmName(this.config));
        result.put(KEY_SKIN_NAME, this.skinInfo.getSkinName());
        result.put(KEY_CPU_ARCH, cpu);
        result.put(KEY_RAM_SIZE, ramSize);
        int width = this.config.getArgInt("width");
        int height = this.config.getArgInt("height");
        result.put(KEY_DISPLAY_RESOLUTION, width + " x " + height);
        result.put(KEY_DISPLAY_DENSITY, dpi);
        if (StringUtil.isEmpty(sharedPath)) {
            result.put(KEY_FILESHARING, VALUE_NOTSUPPORTED);
            result.put(KEY_FILESHARED_PATH, VALUE_NONE);
        } else {
            result.put(KEY_FILESHARING, VALUE_SUPPORTED);
            result.put(KEY_FILESHARED_PATH, sharedPath);
        }
        if (isCpuVirtual) {
            if (isHaxError) {
                result.put(KEY_CPU_VIRTUALIZATION, "Disable(insufficient memory for driver)");
            } else {
                result.put(KEY_CPU_VIRTUALIZATION, VALUE_ENABLED);
            }
        } else {
            result.put(KEY_CPU_VIRTUALIZATION, VALUE_DISABLED);
        }
        if (isGpuVirtual) {
            result.put(KEY_GPU_VIRTUALIZATION, VALUE_ENABLED);
        } else {
            result.put(KEY_GPU_VIRTUALIZATION, VALUE_DISABLED);
        }
        int nPath = imagePathList.size();
        if (nPath == 0) {
            result.put(KEY_IMAGE_PATH, VALUE_NONE);
        } else if (nPath == 1) {
            result.put(KEY_IMAGE_PATH, (String)imagePathList.get(0));
        } else {
            for (int i = 0; i < nPath; ++i) {
                result.put("Image Path " + (i + 1), (String)imagePathList.get(i));
            }
        }
        if (StringUtil.isEmpty(logPath)) {
            result.put(KEY_LOG_PATH, VALUE_NONE);
        } else {
            result.put(KEY_LOG_PATH, logPath);
        }
        return result;
    }

    @Override
    protected void createButtons(Composite parent) {
        super.createButtons(parent);
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        this.createOKButton(composite, true);
    }

    @Override
    protected void close() {
        this.logger.info("close the detail info dialog");
    }
}

