/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.image;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;

public class ImageRegistry {
    public static final String ICONS_FOLDER = "icons";
    public static final String IMAGES_FOLDER = "images";
    private static Logger logger = SkinLogger.getSkinLogger(ImageRegistry.class).getLogger();
    private Display display;
    private Map<String, Image> resourceImageMap;
    private Map<String, Image> iconImageMap;
    private static ImageRegistry instance;
    private static boolean isInitialized;

    private ImageRegistry() {
    }

    public static ImageRegistry getInstance() {
        if (null == instance) {
            instance = new ImageRegistry();
        }
        return instance;
    }

    public void initialize(EmulatorConfig config, String skinPath) {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        this.display = Display.getDefault();
        this.resourceImageMap = new HashMap<String, Image>();
        this.iconImageMap = new HashMap<String, Image>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getResourceImage(ResourceImageName name) {
        String imageName = name.getName();
        Image image = this.resourceImageMap.get(imageName);
        if (image == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = null;
            String resourcePath = "images/" + imageName;
            try {
                is = classLoader.getResourceAsStream(resourcePath);
                if (null != is) {
                    logger.info("resource image is loaded");
                    this.resourceImageMap.put(imageName, new Image((Device)this.display, is));
                } else {
                    logger.severe("missing image : " + resourcePath);
                }
            }
            finally {
                IOUtil.close(is);
            }
            image = this.resourceImageMap.get(imageName);
            if (image != null) {
                logger.info("resource " + imageName + " size : " + image.getImageData().width + "x" + image.getImageData().height);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getIcon(IconName name) {
        if (this.iconImageMap.size() == 0) {
            IconName[] values;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = null;
            for (IconName iconName : values = IconName.values()) {
                String imageName = iconName.getName();
                String imagePath = "icons/" + imageName;
                try {
                    is = classLoader.getResourceAsStream(imagePath);
                    if (null != is) {
                        logger.fine("icon is loaded : " + imagePath);
                        this.iconImageMap.put(imageName, new Image((Device)this.display, is));
                        continue;
                    }
                    logger.severe("missing icon : " + imagePath);
                }
                finally {
                    IOUtil.close(is);
                }
            }
        }
        return this.iconImageMap.get(name.getName());
    }

    public void dispose() {
        Collection<Image> images = null;
        Iterator<Image> imageIterator = null;
        Image image2 = null;
        if (null != this.resourceImageMap) {
            images = this.resourceImageMap.values();
            for (Image image2 : images) {
                image2.dispose();
            }
        }
        if (null != this.iconImageMap) {
            images = this.iconImageMap.values();
            for (Image image2 : images) {
                if (image2 == null) continue;
                image2.dispose();
            }
        }
    }

    public static enum IconName {
        DETAIL_INFO("detail_info.png"),
        ROTATE("rotate.png"),
        SCALE("scale.png"),
        SHELL("shell.png"),
        ECP("ecp.png"),
        ADVANCED("advanced.png"),
        CLOSE("close.png"),
        SCREENSHOT("screenshot.png"),
        HOST_KBD("host_keyboard.png"),
        DIAGNOSIS("diagnosis.png"),
        FORCE_CLOSE("force_close.png"),
        ABOUT("about.png"),
        COPY_SCREEN_SHOT("copy_screenshot_dialog.png"),
        REFRESH_SCREEN_SHOT("refresh_screenshot_dialog.png"),
        INCREASE_SCALE("increase_scale.png"),
        DECREASE_SCALE("decrease_scale.png"),
        SAVE_SCREEN_SHOT("save_screenshot_dialog.png"),
        EMULATOR_ICON("emulator_icon.ico");

        private String name;

        private IconName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ResourceImageName {
        RESOURCE_ABOUT("about_Tizen_SDK.png"),
        RESOURCE_BLANK_GUIDE("blank-guide.png");

        private String name;

        private ResourceImageName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

