/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.image;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.dbi.EmulatorUI;
import org.tizen.emulator.skin.dbi.ImageListType;
import org.tizen.emulator.skin.dbi.RotationType;
import org.tizen.emulator.skin.dbi.RotationsType;
import org.tizen.emulator.skin.layout.rotation.Rotation;
import org.tizen.emulator.skin.layout.rotation.SkinRotations;
import org.tizen.emulator.skin.log.SkinLogger;

public class ProfileSkinImageRegistry {
    private static Logger logger = SkinLogger.getSkinLogger(ProfileSkinImageRegistry.class).getLogger();
    private Display display;
    private String skinPath;
    private EmulatorUI dbiContents;
    private Map<String, Image> skinImageMap;

    public ProfileSkinImageRegistry(Display display, EmulatorUI dbiContents, String skinPath) {
        this.display = display;
        this.skinPath = skinPath;
        this.dbiContents = dbiContents;
        this.skinImageMap = new HashMap<String, Image>();
    }

    private String makeKey(Short id, SkinImageType imageType) {
        return id + ":" + imageType.ordinal();
    }

    public Image getSkinImage(Short id, SkinImageType imageType) {
        Image image = this.skinImageMap.get(this.makeKey(id, imageType));
        if (image == null) {
            RotationsType rotations = this.dbiContents.getRotations();
            if (null == rotations) {
                logger.severe("Fail to loading rotations element from XML");
                return null;
            }
            logger.info("get skin image from " + this.skinPath);
            Rotation targetRotation = SkinRotations.getRotation(id);
            if (targetRotation == null) {
                return null;
            }
            List<RotationType> rotationList = rotations.getRotation();
            for (RotationType rotation : rotationList) {
                ImageListType imageList = rotation.getImageList();
                if (imageList == null) continue;
                String mainImage = imageList.getMainImage();
                String keyPressedImage = imageList.getKeyPressedImage();
                if (!targetRotation.getName().value().equals(rotation.getName().value())) continue;
                String mainKey = this.makeKey(id, SkinImageType.PROFILE_IMAGE_TYPE_NORMAL);
                this.skinImageMap.put(mainKey, new Image((Device)this.display, this.skinPath + File.separator + mainImage));
                String pressedKey = this.makeKey(id, SkinImageType.PROFILE_IMAGE_TYPE_PRESSED);
                this.skinImageMap.put(pressedKey, new Image((Device)this.display, this.skinPath + File.separator + keyPressedImage));
                break;
            }
            image = this.skinImageMap.get(this.makeKey(id, imageType));
        }
        return image;
    }

    public void dispose() {
        logger.info("dispose");
        if (null != this.skinImageMap) {
            Image image2 = null;
            Collection<Image> images = this.skinImageMap.values();
            for (Image image2 : images) {
                if (image2 == null) continue;
                image2.dispose();
            }
        }
    }

    public static enum SkinImageType {
        PROFILE_IMAGE_TYPE_NORMAL,
        PROFILE_IMAGE_TYPE_PRESSED;

    }
}

