/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.log;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.log.SkinFormatter;
import org.tizen.emulator.skin.util.StringUtil;

public class SkinLogger {
    public static final String LOG_FOLDER = "logs";
    private static final String FILE_NAME = "emulator-skin.log";
    private static FileHandler fileHandler;
    private static boolean isInit;
    private static Map<Class<?>, SkinLogger> loggerMap;
    private Logger logger;

    private SkinLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static void setLevel(Level level) {
        if (null != fileHandler) {
            fileHandler.setLevel(level);
        }
    }

    public static void init(SkinLogLevel logLevel, String filePath) {
        if (!isInit) {
            File file;
            File[] listFiles;
            File dir;
            isInit = true;
            String path = "";
            if (!StringUtil.isEmpty(filePath)) {
                path = filePath + File.separator;
            }
            if (!(dir = new File(path + LOG_FOLDER)).mkdir()) {
                // empty if block
            }
            if ((listFiles = dir.listFiles()) != null) {
                for (File f : listFiles) {
                    String name = f.getName();
                    if (!FILE_NAME.equals(name) && name.startsWith(FILE_NAME) && f.delete()) continue;
                }
            }
            if (!(file = new File(dir + File.separator + FILE_NAME)).exists()) {
                try {
                    if (!file.createNewFile()) {
                        System.err.println("[SkinLog:error] Cannot create skin log file. path : " + file.getAbsolutePath());
                        EmulatorSkinMain.terminateImmediately(-1);
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    EmulatorSkinMain.terminateImmediately(-1);
                    return;
                }
            }
            try {
                fileHandler = new FileHandler(file.getAbsolutePath(), false);
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                fileHandler.setEncoding("UTF-8");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            fileHandler.setFormatter(new SkinFormatter());
            fileHandler.setLevel(logLevel.level());
        }
    }

    public static void end() {
        loggerMap.clear();
    }

    public static <T> SkinLogger getSkinLogger(Class<T> clazz) {
        String name = null;
        name = null == clazz ? SkinLogger.class.getName() : clazz.getName();
        SkinLogger skinLogger = loggerMap.get(clazz);
        if (null != skinLogger) {
            return skinLogger;
        }
        Logger logger = Logger.getLogger(name);
        if (logger == null) {
            logger = Logger.getAnonymousLogger();
        }
        logger.addHandler(fileHandler);
        logger.setLevel(fileHandler.getLevel());
        logger.setUseParentHandlers(false);
        SkinLogger sLogger = new SkinLogger(logger);
        loggerMap.put(clazz, sLogger);
        return sLogger;
    }

    static {
        loggerMap = new HashMap();
    }

    public static enum SkinLogLevel {
        ERROR(Level.SEVERE, "error"),
        WARN(Level.WARNING, "warn"),
        DEBUG(Level.INFO, "debug"),
        TRACE(Level.FINE, "trace");

        private Level level;
        private String value;

        private SkinLogLevel(Level level, String value) {
            this.level = level;
            this.value = value;
        }

        public Level level() {
            return this.level;
        }

        public String value() {
            return this.value;
        }
    }
}

