/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.menu;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.MenuItemType;
import org.tizen.emulator.skin.dbi.PopupMenuType;
import org.tizen.emulator.skin.dbi.ScaleItemType;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class PopupMenu {
    public static final String TOPMOST_MENUITEM_NAME = "&Always On Top";
    public static final String ROTATE_MENUITEM_NAME = "&Rotate";
    public static final String SCALE_MENUITEM_NAME = "&Scale";
    public static final String INTERPOLATION_MENUITEM_NAME = "&Quality";
    public static final String KEYWINDOW_MENUITEM_NAME = "&Key Window";
    public static final String ADVANCED_MENUITEM_NAME = "Ad&vanced";
    public static final String SCREENSHOT_MENUITEM_NAME = "&Screen Shot";
    public static final String HOSTKBD_MENUITEM_NAME = "&Host Keyboard";
    public static final String DIAGNOSIS_MENUITEM_NAME = "&Diagnosis";
    public static final String RAMDUMP_MENUITEM_NAME = "&Ram Dump";
    public static final String ABOUT_MENUITEM_NAME = "&About";
    public static final String FORCECLOSE_MENUITEM_NAME = "&Force Close";
    public static final String SDBSHELL_MENUITEM_NAME = "S&hell";
    public static final String ECP_MENUITEM_NAME = "Control &Panel";
    public static final String CLOSE_MENUITEM_NAME = "&Close";
    private static Logger logger = SkinLogger.getSkinLogger(PopupMenu.class).getLogger();
    private EmulatorConfig config;
    private EmulatorSkin skin;
    private Shell shell;
    private ImageRegistry imageRegistry;
    private Menu contextMenu;
    public MenuItem detailInfoItem;
    public MenuItem onTopItem;
    public MenuItem rotateItem;
    public MenuItem scaleItem;
    public MenuItem interpolationItem;
    public MenuItem interpolationHighItem;
    public MenuItem interpolationLowItem;
    public MenuItem keyWindowItem;
    public MenuItem advancedItem;
    public MenuItem screenshotItem;
    public MenuItem hostKbdItem;
    public MenuItem hostKbdOnItem;
    public MenuItem hostKbdOffItem;
    public MenuItem diagnosisItem;
    public MenuItem ramdumpItem;
    public MenuItem aboutItem;
    public MenuItem forceCloseItem;
    public MenuItem shellItem;
    public MenuItem ecpItem;
    public MenuItem closeItem;

    public PopupMenu(EmulatorConfig config, EmulatorSkin skin) {
        this.config = config;
        this.skin = skin;
        this.shell = skin.getShell();
        this.imageRegistry = skin.getImageRegistry();
        this.createMenu();
    }

    private void createMenu() {
        logger.info("create a popup menu");
        this.contextMenu = new Menu((Control)this.shell);
        this.addMenuItems(this.contextMenu);
    }

    private void addMenuItems(Menu menu) {
        MenuItem endItem;
        PopupMenuType itemProperties = this.config.getDbiContents().getPopupMenu();
        this.detailInfoItem = this.createDetailInfoItem(menu);
        if (this.detailInfoItem != null) {
            new MenuItem(menu, 2);
        }
        if (SwtUtil.isWindowsPlatform()) {
            if (itemProperties == null || itemProperties.getTopmostItem() == null) {
                this.onTopItem = this.createOnTopItem(menu, TOPMOST_MENUITEM_NAME);
            } else {
                MenuItemType topmostMenuType = itemProperties.getTopmostItem();
                if (topmostMenuType.isVisible()) {
                    this.onTopItem = this.createOnTopItem(menu, topmostMenuType.getItemName().isEmpty() ? TOPMOST_MENUITEM_NAME : topmostMenuType.getItemName());
                }
            }
        }
        if (itemProperties == null || itemProperties.getRotateItem() == null) {
            this.rotateItem = this.createRotateItem(menu, ROTATE_MENUITEM_NAME);
        } else {
            MenuItemType rotationMenuType = itemProperties.getRotateItem();
            if (rotationMenuType.isVisible()) {
                this.rotateItem = this.createRotateItem(menu, rotationMenuType.getItemName().isEmpty() ? ROTATE_MENUITEM_NAME : rotationMenuType.getItemName());
            } else {
                this.skin.getEmulatorSkinState().setCurrentRotationId();
            }
        }
        if (itemProperties == null || itemProperties.getScaleItem() == null) {
            this.scaleItem = this.createScaleItem(menu, SCALE_MENUITEM_NAME, null);
        } else {
            ScaleItemType scaleMenuType = itemProperties.getScaleItem();
            if (scaleMenuType.isVisible()) {
                String menuName = scaleMenuType.getItemName().isEmpty() ? SCALE_MENUITEM_NAME : scaleMenuType.getItemName();
                List<ScaleItemType.FactorItem> factors = scaleMenuType.getFactorItem();
                if (factors == null || factors.size() == 0) {
                    logger.info("create a predefined Scale menu");
                    this.scaleItem = this.createScaleItem(menu, menuName, null);
                } else {
                    logger.info("create a custom Scale menu");
                    this.scaleItem = this.createScaleItem(menu, menuName, factors);
                }
            } else {
                this.skin.getEmulatorSkinState().setCurrentScale(100);
            }
        }
        if (this.onTopItem != null || this.rotateItem != null || this.scaleItem != null) {
            new MenuItem(menu, 2);
        }
        if (itemProperties == null || itemProperties.getKeywindowItem() == null) {
            this.keyWindowItem = this.createKeyWindowItem(menu, KEYWINDOW_MENUITEM_NAME);
        } else {
            MenuItemType keywindowMenuType = itemProperties.getKeywindowItem();
            if (keywindowMenuType.isVisible()) {
                this.keyWindowItem = this.createKeyWindowItem(menu, keywindowMenuType.getItemName().isEmpty() ? KEYWINDOW_MENUITEM_NAME : keywindowMenuType.getItemName());
            }
        }
        Menu advancedSubMenu = new Menu((Decorations)menu.getShell(), 4);
        this.screenshotItem = this.createScreenShotItem(advancedSubMenu, SCREENSHOT_MENUITEM_NAME);
        if (itemProperties == null || itemProperties.getHostKeyboardItem() == null) {
            this.hostKbdItem = this.createHostKbdItem(advancedSubMenu, HOSTKBD_MENUITEM_NAME);
        } else {
            MenuItemType hostKbdMenuType = itemProperties.getHostKeyboardItem();
            if (hostKbdMenuType.isVisible()) {
                this.hostKbdItem = this.createHostKbdItem(advancedSubMenu, hostKbdMenuType.getItemName().isEmpty() ? HOSTKBD_MENUITEM_NAME : hostKbdMenuType.getItemName());
            }
        }
        if (SwtUtil.isLinuxPlatform()) {
            Menu diagnosisSubMenu = new Menu((Decorations)advancedSubMenu.getShell(), 4);
            if (itemProperties == null || itemProperties.getRamdumpItem() == null) {
                this.ramdumpItem = this.createRamDumpItem(diagnosisSubMenu, RAMDUMP_MENUITEM_NAME);
            } else {
                MenuItemType ramdumpMenuType = itemProperties.getRamdumpItem();
                if (ramdumpMenuType.isVisible()) {
                    this.ramdumpItem = this.createRamDumpItem(diagnosisSubMenu, ramdumpMenuType.getItemName().isEmpty() ? RAMDUMP_MENUITEM_NAME : ramdumpMenuType.getItemName());
                }
            }
            if (this.ramdumpItem != null) {
                this.diagnosisItem = new MenuItem(advancedSubMenu, 64);
                this.diagnosisItem.setText(DIAGNOSIS_MENUITEM_NAME);
                this.diagnosisItem.setImage(this.imageRegistry.getIcon(ImageRegistry.IconName.DIAGNOSIS));
                this.diagnosisItem.setMenu(diagnosisSubMenu);
            }
        }
        if (this.screenshotItem != null || this.hostKbdItem != null || this.diagnosisItem != null) {
            new MenuItem(advancedSubMenu, 2);
        }
        this.aboutItem = this.createAboutItem(advancedSubMenu, ABOUT_MENUITEM_NAME);
        if (this.aboutItem != null) {
            new MenuItem(advancedSubMenu, 2);
        }
        if (itemProperties == null || itemProperties.getForceCloseItem() == null) {
            this.forceCloseItem = this.createForceCloseItem(advancedSubMenu, FORCECLOSE_MENUITEM_NAME);
        } else {
            MenuItemType closeMenuType = itemProperties.getForceCloseItem();
            if (closeMenuType.isVisible()) {
                this.forceCloseItem = this.createForceCloseItem(advancedSubMenu, closeMenuType.getItemName().isEmpty() ? FORCECLOSE_MENUITEM_NAME : closeMenuType.getItemName());
            }
        }
        int cnt = advancedSubMenu.getItemCount();
        if (cnt > 0 && (endItem = advancedSubMenu.getItem(cnt - 1)) != null && (endItem.getStyle() & 2) != 0) {
            logger.info("delete unnecessary separator");
            endItem.dispose();
        }
        if (this.screenshotItem != null || this.hostKbdItem != null || this.diagnosisItem != null || this.aboutItem != null || this.forceCloseItem != null) {
            this.advancedItem = new MenuItem(menu, 64);
            this.advancedItem.setText(ADVANCED_MENUITEM_NAME);
            this.advancedItem.setImage(this.imageRegistry.getIcon(ImageRegistry.IconName.ADVANCED));
            this.advancedItem.setMenu(advancedSubMenu);
        }
        if (itemProperties == null || itemProperties.getShellItem() == null) {
            this.shellItem = this.createShellItem(menu, SDBSHELL_MENUITEM_NAME);
        } else {
            MenuItemType shellMenuType = itemProperties.getShellItem();
            if (shellMenuType.isVisible()) {
                this.shellItem = this.createShellItem(menu, shellMenuType.getItemName().isEmpty() ? SDBSHELL_MENUITEM_NAME : shellMenuType.getItemName());
            }
        }
        if (this.keyWindowItem != null || this.advancedItem != null || this.shellItem != null) {
            new MenuItem(menu, 2);
        }
        if (itemProperties == null || itemProperties.getControlPanelItem() == null) {
            this.ecpItem = this.createEcpItem(menu, ECP_MENUITEM_NAME);
        } else {
            MenuItemType ecpMenuType = itemProperties.getControlPanelItem();
            if (ecpMenuType.isVisible()) {
                this.ecpItem = this.createEcpItem(menu, ecpMenuType.getItemName().isEmpty() ? ECP_MENUITEM_NAME : ecpMenuType.getItemName());
            }
        }
        if (this.ecpItem != null) {
            new MenuItem(menu, 2);
        }
        if (itemProperties == null || itemProperties.getCloseItem() == null) {
            this.closeItem = this.createCloseItem(menu, CLOSE_MENUITEM_NAME);
        } else {
            MenuItemType closeMenuType = itemProperties.getCloseItem();
            if (closeMenuType.isVisible()) {
                this.closeItem = this.createCloseItem(menu, closeMenuType.getItemName().isEmpty() ? CLOSE_MENUITEM_NAME : closeMenuType.getItemName());
            }
        }
        cnt = menu.getItemCount();
        if (cnt > 0 && (endItem = menu.getItem(cnt - 1)) != null && (endItem.getStyle() & 2) != 0) {
            logger.info("delete unnecessary separator");
            endItem.dispose();
        }
    }

    private MenuItem createMenuItem(Menu menu, int style, String name, Image image, SelectionAdapter listener, boolean selected) {
        MenuItem item = new MenuItem(menu, style);
        if (name != null) {
            item.setText(name);
        }
        if (image != null) {
            item.setImage(image);
        }
        if (listener != null) {
            item.addSelectionListener((SelectionListener)listener);
        }
        item.setSelection(selected);
        return item;
    }

    private MenuItem createDetailInfoItem(Menu menu) {
        return this.createMenuItem(menu, 8, SkinUtil.makeEmulatorName(this.config), this.imageRegistry.getIcon(ImageRegistry.IconName.DETAIL_INFO), this.skin.createDetailInfoMenuListener(), false);
    }

    private MenuItem createOnTopItem(Menu menu, String name) {
        return this.createMenuItem(menu, 32, name, null, this.skin.createTopMostMenuListener(), this.skin.isOnTop);
    }

    private MenuItem createRotateItem(Menu menu, String name) {
        MenuItem item = this.createMenuItem(menu, 64, name, this.imageRegistry.getIcon(ImageRegistry.IconName.ROTATE), null, false);
        item.setMenu(this.skin.createRotateMenu());
        return item;
    }

    private MenuItem createScaleItem(Menu menu, String name, List<ScaleItemType.FactorItem> factors) {
        MenuItem item = this.createMenuItem(menu, 64, name, this.imageRegistry.getIcon(ImageRegistry.IconName.SCALE), null, false);
        item.setMenu(this.createScaleSubItem(menu, factors));
        return item;
    }

    private Menu createScaleSubItem(Menu menu, List<ScaleItemType.FactorItem> factors) {
        SelectionAdapter scaleListener = this.skin.createScaleMenuListener();
        Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
        if (factors == null) {
            ScaleItemType.FactorItem actual = new ScaleItemType.FactorItem();
            actual.setItemName("1x");
            actual.setValue(100);
            ScaleItemType.FactorItem threeQuater = new ScaleItemType.FactorItem();
            threeQuater.setItemName("3/4x");
            threeQuater.setValue(75);
            ScaleItemType.FactorItem half = new ScaleItemType.FactorItem();
            half.setItemName("1/2x");
            half.setValue(50);
            ScaleItemType.FactorItem quater = new ScaleItemType.FactorItem();
            quater.setItemName("1/4x");
            quater.setValue(25);
            factors = Arrays.asList(actual, threeQuater, half, quater);
        }
        MenuItem matchedItem = null;
        for (ScaleItemType.FactorItem factor : factors) {
            String factorName = factor.getItemName();
            if (factorName == null || factorName.isEmpty()) {
                factorName = factor.getValue() + "%";
            }
            MenuItem factorItem = this.createMenuItem(subMenu, 16, factorName, null, scaleListener, false);
            factorItem.setData((Object)factor.getValue());
            if (this.skin.getEmulatorSkinState().getCurrentScale() != ((Integer)factorItem.getData()).intValue()) continue;
            matchedItem = factorItem;
        }
        if (matchedItem == null) {
            matchedItem = subMenu.getItem(0);
            if (matchedItem == null) {
                return null;
            }
            this.skin.getEmulatorSkinState().setCurrentScale((Integer)matchedItem.getData());
        }
        matchedItem.setSelection(true);
        this.interpolationItem = this.createInterpolationItem(subMenu, INTERPOLATION_MENUITEM_NAME);
        return subMenu;
    }

    private MenuItem createInterpolationItem(Menu menu, String name) {
        MenuItem item = this.createMenuItem(menu, 64, name, null, null, false);
        item.setMenu(this.createInterpolationSubItem(menu));
        return item;
    }

    private Menu createInterpolationSubItem(Menu menu) {
        SelectionAdapter interpolationListener = this.skin.createInterpolationMenuListener();
        Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
        this.interpolationHighItem = this.createMenuItem(subMenu, 16, "High", null, interpolationListener, this.skin.isOnInterpolation);
        this.interpolationLowItem = this.createMenuItem(subMenu, 16, "Low", null, interpolationListener, !this.skin.isOnInterpolation);
        return subMenu;
    }

    private MenuItem createKeyWindowItem(Menu menu, String name) {
        String pathLayoutRoot = this.skin.skinInfo.getSkinPath() + File.separator + "keywindow-layout";
        ArrayList<File> layouts = this.getKeyWindowLayoutList(pathLayoutRoot);
        MenuItem item = null;
        if (layouts != null && layouts.size() != 0) {
            item = this.createMenuItem(menu, 64, name, null, null, false);
            item.setMenu(this.createKeyWindowSubItem(menu, layouts));
        } else {
            item = this.createMenuItem(menu, 32, name, null, this.skin.createKeyWindowMenuListener(), this.skin.isKeyWindow);
        }
        return item;
    }

    private Menu createKeyWindowSubItem(Menu menu, ArrayList<File> layouts) {
        SelectionAdapter keyWindowListener = this.skin.createKeyWindowMenuListener();
        Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
        for (int i = 0; i < layouts.size(); ++i) {
            File dir = layouts.get(i);
            this.createMenuItem(subMenu, 32, dir.getName(), null, keyWindowListener, i == 0);
        }
        return subMenu;
    }

    private MenuItem createScreenShotItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.SCREENSHOT), this.skin.createScreenshotMenuListener(), false);
    }

    private MenuItem createHostKbdItem(Menu menu, String name) {
        MenuItem item = this.createMenuItem(menu, 64, name, this.imageRegistry.getIcon(ImageRegistry.IconName.HOST_KBD), null, false);
        item.setMenu(this.createKbdSubItem(menu));
        return item;
    }

    private Menu createKbdSubItem(Menu menu) {
        SelectionAdapter hostKbdListener = this.skin.createHostKbdMenuListener();
        Menu subMenu = new Menu((Decorations)menu.getShell(), 4);
        this.hostKbdOnItem = this.createMenuItem(subMenu, 16, "On", null, hostKbdListener, this.skin.isOnKbd);
        this.hostKbdOffItem = this.createMenuItem(subMenu, 16, "Off", null, hostKbdListener, !this.skin.isOnKbd);
        return subMenu;
    }

    private MenuItem createRamDumpItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, null, this.skin.createRamdumpMenuListener(), false);
    }

    private MenuItem createAboutItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.ABOUT), this.skin.createAboutMenuListener(), false);
    }

    private MenuItem createForceCloseItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.FORCE_CLOSE), this.skin.createForceCloseMenuListener(), false);
    }

    private MenuItem createShellItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.SHELL), this.skin.createShellMenuListener(), false);
    }

    private MenuItem createEcpItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.ECP), this.skin.createEcpMenuListener(), false);
    }

    private MenuItem createCloseItem(Menu menu, String name) {
        return this.createMenuItem(menu, 8, name, this.imageRegistry.getIcon(ImageRegistry.IconName.CLOSE), this.skin.createCloseMenuListener(), false);
    }

    public Menu getMenuRoot() {
        return this.contextMenu;
    }

    private ArrayList<File> getKeyWindowLayoutList(String path) {
        File pathRoot = new File(path);
        if (pathRoot.exists()) {
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            };
            File[] layoutPaths = pathRoot.listFiles(filter);
            if (layoutPaths == null || layoutPaths.length <= 0) {
                logger.info("the layout of key window not found");
                return null;
            }
            ArrayList<File> layoutList = new ArrayList<File>();
            for (File layout : layoutPaths) {
                logger.info("the layout of key window detected : " + layout.getName());
                layoutList.add(layout);
            }
            return layoutList;
        }
        return null;
    }
}

