/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.screenshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class ScreenShotDialog {
    public static final String JNI_LIBRARY_FILE = "clipboard";
    private static final String DETAIL_SCREENSHOT_WINDOW_TITLE = "Screen Shot";
    private static final String DEFAULT_FILE_EXTENSION = "png";
    private static final int CANVAS_MARGIN = 30;
    private static final int TOOLITEM_COOLTIME = 200;
    private static final double MAX_SCALE_MULTIPLE = 8.0;
    private static Logger logger = SkinLogger.getSkinLogger(ScreenShotDialog.class).getLogger();
    protected EmulatorSkin skin;
    protected EmulatorConfig config;
    private Shell shell;
    private ScrolledComposite scrollComposite;
    protected Canvas canvasShot;
    protected Image imageShot;
    protected boolean isCanvasDragging;
    protected Point canvasGrabPosition;
    private Composite statusComposite;
    private Label labelResolution;
    private Label labelScale;
    private Label labelPoint;
    private ToolItem refreshItem;
    private ToolItem copyItem;
    private ToolItem scaleItem;
    private Scale scale;
    private double scaleLevel;
    private double scaleSize;
    private boolean isCtrlPressed;

    public ScreenShotDialog(final EmulatorSkin skin, EmulatorConfig config, Image icon) {
        this.skin = skin;
        this.config = config;
        this.canvasGrabPosition = new Point(-1, -1);
        this.scaleLevel = 100.0;
        this.isCtrlPressed = false;
        this.shell = !SwtUtil.isMacPlatform() ? new Shell(skin.getShell(), 1264) : new Shell(skin.getShell().getDisplay(), 1264);
        this.shell.setText("Screen Shot - " + SkinUtil.makeEmulatorName(config));
        if (!SwtUtil.isMacPlatform() && icon != null) {
            this.shell.setImage(icon);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                logger.info("ScreenShot Window is closed");
                if (null != ScreenShotDialog.this.imageShot) {
                    ScreenShotDialog.this.imageShot.dispose();
                }
                skin.screenShotDialog = null;
            }
        });
        this.createToolBar(this.shell);
        this.shell.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (ScreenShotDialog.this.isCtrlPressed) {
                    if (e.count < 0 && ScreenShotDialog.this.scale.getSelection() > 0) {
                        ScreenShotDialog.this.downScaleLevel();
                        ScreenShotDialog.this.scale.setSelection(ScreenShotDialog.this.scale.getSelection() - 1);
                        ScreenShotDialog.this.scale.setToolTipText(ScreenShotDialog.this.getScaleLevel() + "%");
                    } else if (e.count > 0 && ScreenShotDialog.this.scale.getSelection() < 6) {
                        ScreenShotDialog.this.upScaleLevel();
                        ScreenShotDialog.this.scale.setSelection(ScreenShotDialog.this.scale.getSelection() + 1);
                        ScreenShotDialog.this.scale.setToolTipText(ScreenShotDialog.this.getScaleLevel() + "%");
                    } else {
                        return;
                    }
                    ScreenShotDialog.this.updateWindow();
                }
            }
        });
        this.scrollComposite = new ScrolledComposite((Composite)this.shell, 768);
        GridData gridData = new GridData(4, 4, true, true);
        this.scrollComposite.setLayoutData((Object)gridData);
        this.scrollComposite.setExpandHorizontal(true);
        this.scrollComposite.setExpandVertical(true);
        this.canvasShot = new Canvas((Composite)this.scrollComposite, 4);
        this.canvasShot.setBackground(this.shell.getDisplay().getSystemColor(16));
        this.scrollComposite.setContent((Control)this.canvasShot);
        this.createStatusBar(this.shell);
        this.shell.pack();
        this.adjustWindow(skin);
        this.createCanvasListener(this.canvasShot);
    }

    private void adjustWindow(EmulatorSkin skin) {
        Rectangle monitorBounds = Display.getDefault().getBounds();
        logger.info("host monitor display bounds : " + monitorBounds);
        Rectangle emulatorBounds = skin.getShell().getBounds();
        logger.info("current Emulator window bounds : " + emulatorBounds);
        Rectangle dialogBounds = this.shell.getBounds();
        logger.info("current ScreenShot window bounds : " + dialogBounds);
        this.shell.setSize(emulatorBounds.width, emulatorBounds.height);
        dialogBounds = this.shell.getBounds();
        logger.info("current ScreenShot Dialog bounds : " + dialogBounds);
        int x = emulatorBounds.x + emulatorBounds.width + 20;
        int y = emulatorBounds.y;
        if (x + dialogBounds.width > monitorBounds.x + monitorBounds.width) {
            x = emulatorBounds.x - dialogBounds.width - 20;
        }
        if (y < monitorBounds.y) {
            y = monitorBounds.y;
        } else if (y + dialogBounds.height > monitorBounds.y + monitorBounds.height) {
            y = monitorBounds.y + monitorBounds.height - dialogBounds.height;
        }
        this.shell.setLocation(x, y);
        logger.info("ScreenShot window bounds : " + this.shell.getBounds());
    }

    private void createCanvasListener(Canvas canvas) {
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                logger.fine("draw shot");
                if (null != ScreenShotDialog.this.imageShot && !ScreenShotDialog.this.imageShot.isDisposed()) {
                    e.gc.setInterpolation(0);
                    Rectangle imageBounds = ScreenShotDialog.this.imageShot.getBounds();
                    e.gc.drawImage(ScreenShotDialog.this.imageShot, 0, 0, imageBounds.width, imageBounds.height, 30, 30, (int)((double)imageBounds.width * ScreenShotDialog.this.scaleLevel / 100.0), (int)((double)imageBounds.height * ScreenShotDialog.this.scaleLevel / 100.0));
                }
            }
        });
        canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ScreenShotDialog.this.isCanvasDragging) {
                    Point origin = ScreenShotDialog.this.scrollComposite.getOrigin();
                    origin.x += ScreenShotDialog.this.canvasGrabPosition.x - e.x;
                    origin.y += ScreenShotDialog.this.canvasGrabPosition.y - e.y;
                    ScreenShotDialog.this.scrollComposite.setOrigin(origin);
                }
                int MaxWidth = 0;
                int MaxHeight = 0;
                ScreenShotDialog.this.scaleSize = ScreenShotDialog.this.scale.getSelection() - 3;
                int curX = (int)((double)(e.x - 30) * Math.pow(2.0, -ScreenShotDialog.this.scaleSize));
                int curY = (int)((double)(e.y - 30) * Math.pow(2.0, -ScreenShotDialog.this.scaleSize));
                switch (ScreenShotDialog.this.skin.getEmulatorSkinState().getCurrentRotationId()) {
                    case 1: 
                    case 3: {
                        MaxWidth = ScreenShotDialog.this.skin.getEmulatorSkinState().getCurrentResolutionHeight();
                        MaxHeight = ScreenShotDialog.this.skin.getEmulatorSkinState().getCurrentResolutionWidth();
                        break;
                    }
                    default: {
                        MaxWidth = ScreenShotDialog.this.skin.getEmulatorSkinState().getCurrentResolutionWidth();
                        MaxHeight = ScreenShotDialog.this.skin.getEmulatorSkinState().getCurrentResolutionHeight();
                    }
                }
                if (curX < 0) {
                    curX = 0;
                } else if (curX > MaxWidth) {
                    curX = MaxWidth;
                }
                if (curY < 0) {
                    curY = 0;
                } else if (curY > MaxHeight) {
                    curY = MaxHeight;
                }
                ScreenShotDialog.this.labelPoint.setText(" x : " + curX + ", y : " + curY + " ");
                ScreenShotDialog.this.labelPoint.update();
            }
        });
        canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    ScreenShotDialog.this.isCanvasDragging = true;
                    ScreenShotDialog.this.canvasGrabPosition.x = e.x;
                    ScreenShotDialog.this.canvasGrabPosition.y = e.y;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (1 == e.button) {
                    ScreenShotDialog.this.isCanvasDragging = false;
                    ScreenShotDialog.this.canvasGrabPosition.x = -1;
                    ScreenShotDialog.this.canvasGrabPosition.y = -1;
                }
            }
        });
        canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = true;
                    ScreenShotDialog.this.scrollComposite.setEnabled(false);
                    ScreenShotDialog.this.scale.setEnabled(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = false;
                    ScreenShotDialog.this.scrollComposite.setEnabled(true);
                    ScreenShotDialog.this.scale.setEnabled(true);
                }
            }
        });
    }

    private void clickShutter() throws ScreenShotException {
        this.capture();
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScreenShotDialog.this.updateWindow();
            }
        });
    }

    protected void capture() throws ScreenShotException {
    }

    private double getScaleLevel() {
        return this.scaleLevel;
    }

    private void setScaleLevel(double level) {
        this.scaleLevel = level;
        logger.info("set scaling level : " + this.scaleLevel);
    }

    private void downScaleLevel() {
        this.scaleLevel /= 2.0;
        logger.info("down scaling level : " + this.scaleLevel);
    }

    private void upScaleLevel() {
        this.scaleLevel *= 2.0;
        logger.info("up scaling level : " + this.scaleLevel);
    }

    private void updateWindow() {
        logger.info("update");
        if (this.imageShot != null) {
            ImageData imageData = this.imageShot.getImageData();
            int width = (int)((double)imageData.width * this.scaleLevel / 100.0) + 60;
            int height = (int)((double)imageData.height * this.scaleLevel / 100.0) + 60;
            logger.info("update composite width : " + width + ", height : " + height);
            this.scrollComposite.setMinSize(width, height);
        }
        this.canvasShot.redraw();
        if (this.labelScale != null) {
            this.labelScale.setText(" " + this.scaleLevel + "% ");
            this.labelScale.update();
        }
    }

    protected ImageData getRotateImageData(ImageData srcData) {
        int direction = 0;
        switch (this.skin.getEmulatorSkinState().getCurrentRotationId()) {
            case 0: {
                return srcData;
            }
            case 1: {
                direction = 16384;
                break;
            }
            case 2: {
                direction = 1024;
                break;
            }
            case 3: {
                direction = 131072;
                break;
            }
            default: {
                return srcData;
            }
        }
        ImageData rotatedData = this.rotateImageData(srcData, direction);
        return rotatedData;
    }

    private ImageData rotateImageData(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int srcWidth = 0;
        int srcHeight = 0;
        int destX = 0;
        int destY = 0;
        int destIndex = 0;
        int srcIndex = 0;
        for (int srcY = 0; srcY < srcData.height; ++srcY) {
            for (int srcX = 0; srcX < srcData.width; ++srcX) {
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        srcWidth = srcData.height;
                        srcHeight = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        srcWidth = srcData.height;
                        srcHeight = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        srcWidth = srcData.width;
                        srcHeight = srcData.height;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
            }
        }
        return new ImageData(srcWidth, srcHeight, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    private void createToolBar(final Shell parent) {
        ImageRegistry imageRegistry = this.skin.getImageRegistry();
        ToolBar toolBar = new ToolBar((Composite)parent, 2304);
        GridData gridData = new GridData(768, 2, true, false);
        toolBar.setLayoutData((Object)gridData);
        ToolItem saveItem = new ToolItem(toolBar, 0x800000);
        saveItem.setImage(imageRegistry.getIcon(ImageRegistry.IconName.SAVE_SCREEN_SHOT));
        saveItem.setToolTipText("Save to file");
        saveItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Save menu is selected");
                FileDialog fileDialog = new FileDialog(parent, 8192);
                fileDialog.setText("Save Image");
                String[] filter = new String[]{"*.png;*.PNG;*.jpg;*.JPG;*.jpeg;*.JPEG;*.bmp;*.BMP"};
                fileDialog.setFilterExtensions(filter);
                String[] filterName = new String[]{"Image files (*.png *.jpg *.jpeg *.bmp)"};
                fileDialog.setFilterNames(filterName);
                String vmName = SkinUtil.getVmName(ScreenShotDialog.this.config);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
                String dateString = formatter.format(new Date(System.currentTimeMillis()));
                fileDialog.setFileName(vmName + "-" + dateString + "." + ScreenShotDialog.DEFAULT_FILE_EXTENSION);
                String userHome = System.getProperty("user.home");
                if (!StringUtil.isEmpty(userHome)) {
                    fileDialog.setFilterPath(userHome);
                } else {
                    logger.warning("Cannot find user home path in java System properties.");
                }
                fileDialog.setOverwrite(true);
                String filePath = fileDialog.open();
                ScreenShotDialog.this.saveFile(filePath, fileDialog);
            }
        });
        this.copyItem = new ToolItem(toolBar, 0x800000);
        this.copyItem.setImage(imageRegistry.getIcon(ImageRegistry.IconName.COPY_SCREEN_SHOT));
        this.copyItem.setToolTipText("Copy to clipboard");
        this.copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("CopyToClipboard menu is selected");
                if (null == ScreenShotDialog.this.imageShot || ScreenShotDialog.this.imageShot.isDisposed()) {
                    SkinUtil.openMessage(parent, null, "Fail to copy to clipboard.", 1, ScreenShotDialog.this.config);
                    return;
                }
                ScreenShotDialog.this.copyItem.setEnabled(false);
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ScreenShotDialog.this.copyItem.setEnabled(true);
                    }
                });
                ImageLoader loader = new ImageLoader();
                ImageData shotData = ScreenShotDialog.this.imageShot.getImageData();
                if (SwtUtil.isWindowsPlatform()) {
                    shotData.palette = new PaletteData(-16777216, 0xFF0000, 65280);
                }
                loader.data = new ImageData[]{shotData};
                if (SwtUtil.isLinuxPlatform() && SwtUtil.is64bitPlatform()) {
                    FileOutputStream fos = null;
                    String fileName = "screenshot" + ScreenShotDialog.this.skin.config.getArgInt("vm.baseport") + ".png";
                    try {
                        fos = new FileOutputStream(fileName, false);
                    }
                    catch (FileNotFoundException ee) {
                        logger.log(Level.SEVERE, ee.getMessage(), ee);
                        SkinUtil.openMessage(ScreenShotDialog.this.shell, null, "Failed to copy to clipboard : \n" + ee.getMessage(), 1, ScreenShotDialog.this.config);
                        return;
                    }
                    loader.save((OutputStream)fos, 5);
                    IOUtil.close(fos);
                    ProcessBuilder procPy = new ProcessBuilder(new String[0]);
                    procPy.command("python", "clipboard.py", fileName);
                    logger.info(procPy.command().toString());
                    try {
                        procPy.start();
                    }
                    catch (Exception ee) {
                        logger.log(Level.SEVERE, ee.getMessage(), ee);
                        SkinUtil.openMessage(ScreenShotDialog.this.shell, null, "Failed to copy to clipboard : \n" + ee.getMessage(), 1, ScreenShotDialog.this.config);
                    }
                } else {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    loader.save((OutputStream)bao, 5);
                    ImageData pngData = new ImageData((InputStream)new ByteArrayInputStream(bao.toByteArray()));
                    Object[] imageObject = new Object[]{pngData};
                    Transfer[] transfer = new Transfer[]{ImageTransfer.getInstance()};
                    Clipboard clipboard = new Clipboard(parent.getDisplay());
                    clipboard.setContents(imageObject, transfer);
                    clipboard.dispose();
                }
            }
        });
        new ToolItem(toolBar, 2);
        this.refreshItem = new ToolItem(toolBar, 0x800000);
        this.refreshItem.setImage(imageRegistry.getIcon(ImageRegistry.IconName.REFRESH_SCREEN_SHOT));
        this.refreshItem.setToolTipText("Refresh image");
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Refresh menu is selected");
                ScreenShotDialog.this.refreshItem.setEnabled(false);
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ScreenShotDialog.this.refreshItem.setEnabled(true);
                    }
                });
                try {
                    ScreenShotDialog.this.clickShutter();
                }
                catch (ScreenShotException ex) {
                    logger.log(Level.SEVERE, "Fail to create a screen shot.", ex);
                    SkinUtil.openMessage(parent, null, "Fail to create a screen shot.", 1, ScreenShotDialog.this.config);
                }
            }
        });
        new ToolItem(toolBar, 2);
        this.scaleItem = new ToolItem(toolBar, 2);
        this.scaleItem.setWidth(100);
        this.scale = new Scale((Composite)toolBar, 256);
        this.scale.setMinimum(0);
        this.scale.setMaximum(6);
        this.scale.setPageIncrement(1);
        this.scale.setIncrement(1);
        this.scale.setSelection(3);
        this.scale.setToolTipText(this.scaleLevel + "%");
        this.scaleItem.setControl((Control)this.scale);
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenShotDialog.this.scaleSize = ScreenShotDialog.this.scale.getSelection() - 3;
                ScreenShotDialog.this.setScaleLevel(Math.pow(2.0, ScreenShotDialog.this.scaleSize) * 100.0);
                ScreenShotDialog.this.updateWindow();
                ScreenShotDialog.this.scale.setToolTipText(ScreenShotDialog.this.getScaleLevel() + "%");
                if (ScreenShotDialog.this.labelScale != null) {
                    ScreenShotDialog.this.labelScale.setText(" " + ScreenShotDialog.this.scaleLevel + "% ");
                    ScreenShotDialog.this.labelScale.update();
                }
            }
        });
        this.scale.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = true;
                    ScreenShotDialog.this.scrollComposite.setEnabled(false);
                    ScreenShotDialog.this.scale.setEnabled(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = false;
                    ScreenShotDialog.this.scrollComposite.setEnabled(true);
                    ScreenShotDialog.this.scale.setEnabled(true);
                }
            }
        });
        toolBar.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = true;
                    ScreenShotDialog.this.scrollComposite.setEnabled(false);
                    ScreenShotDialog.this.scale.setEnabled(false);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (262144 == e.keyCode) {
                    ScreenShotDialog.this.isCtrlPressed = false;
                    ScreenShotDialog.this.scrollComposite.setEnabled(true);
                    ScreenShotDialog.this.scale.setEnabled(true);
                }
            }
        });
    }

    private void createStatusBar(Shell parent) {
        this.statusComposite = new Composite((Composite)parent, 0);
        RowLayout row = new RowLayout(256);
        row.marginLeft = 0;
        row.marginBottom = 0;
        row.marginTop = 0;
        this.statusComposite.setLayout((Layout)row);
        this.labelResolution = new Label(this.statusComposite, 2052);
        this.labelResolution.setText(" Resolution : " + this.skin.getEmulatorSkinState().getCurrentResolutionWidth() + "x" + this.skin.getEmulatorSkinState().getCurrentResolutionHeight() + " ");
        this.labelScale = new Label(this.statusComposite, 2052);
        this.labelScale.setText(" " + this.scaleLevel + "% ");
        this.labelPoint = new Label(this.statusComposite, 2052);
        this.labelPoint.setText(" x : " + this.skin.getEmulatorSkinState().getCurrentResolutionWidth() * 8 + ", y : " + this.skin.getEmulatorSkinState().getCurrentResolutionHeight() * 8 + " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveFile(String fileFullPath, FileDialog fileDialog) {
        FileOutputStream fos;
        block13: {
            if (null == fileFullPath) {
                return;
            }
            String format = "";
            String[] split = fileFullPath.split("\\.");
            if (1 < split.length) {
                format = split[split.length - 1];
                if (new File(split[split.length - 2]).isDirectory()) {
                    SkinUtil.openMessage(this.shell, null, "Use correct file name.", 8, this.config);
                    String path = fileDialog.open();
                    this.saveFile(path, fileDialog);
                }
            }
            fos = null;
            try {
                if (StringUtil.isEmpty(format)) {
                    fileFullPath = fileFullPath.endsWith(".") ? fileFullPath + DEFAULT_FILE_EXTENSION : fileFullPath + ".png";
                }
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{this.imageShot.getImageData()};
                if (StringUtil.isEmpty(format) || format.equalsIgnoreCase(DEFAULT_FILE_EXTENSION)) {
                    fos = new FileOutputStream(fileFullPath, false);
                    loader.save((OutputStream)fos, 5);
                    break block13;
                }
                if (format.equalsIgnoreCase("jpg") || format.equalsIgnoreCase("jpeg")) {
                    fos = new FileOutputStream(fileFullPath, false);
                    loader.save((OutputStream)fos, 4);
                    break block13;
                }
                if (format.equalsIgnoreCase("bmp")) {
                    fos = new FileOutputStream(fileFullPath, false);
                    loader.save((OutputStream)fos, 0);
                    break block13;
                }
                SkinUtil.openMessage(this.shell, null, "Use the specified image formats. (PNG / JPG / JPEG / BMP)", 8, this.config);
                String path = fileDialog.open();
                this.saveFile(path, fileDialog);
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.WARNING, "Use correct file name.", ex);
                SkinUtil.openMessage(this.shell, null, "Use correct file name.", 8, this.config);
                String path = fileDialog.open();
                this.saveFile(path, fileDialog);
                IOUtil.close(fos);
            }
            catch (Exception ex2) {
                logger.log(Level.SEVERE, "Fail to save this image file.", ex2);
                SkinUtil.openMessage(this.shell, null, "Fail to save this image file.", 1, this.config);
                String path = fileDialog.open();
                this.saveFile(path, fileDialog);
                {
                    catch (Throwable throwable) {
                        IOUtil.close(fos);
                        throw throwable;
                    }
                }
                IOUtil.close(fos);
            }
        }
        IOUtil.close(fos);
    }

    public void open() throws ScreenShotException {
        if (this.shell.isDisposed()) {
            return;
        }
        try {
            this.clickShutter();
        }
        catch (ScreenShotException e) {
            this.shell.close();
            throw e;
        }
        this.shell.open();
    }

    public Shell getShell() {
        return this.shell;
    }
}

