#!/bin/sh

if [ "$(uname | cut -c 1-5)" = "Linux" ]; then
# under linux
SCRIPT_DIR=$(dirname "$(readlink -f "$0")")
EMULATOR_INSTALLED_PATH=$(readlink -f "$SCRIPT_DIR/..")
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin
EMULATOR_TOOL_PATH=$EMULATOR_INSTALLED_PATH/../../../../tools/emulator

# set env variables for linux
export LD_LIBRARY_PATH="$EMULATOR_BIN_PATH":"$EMULATOR_TOOL_PATH/remote/lib":
elif [ "$(uname | cut -c 1-6)" = "Darwin" ]; then
# under darwin
EMULATOR_INSTALLED_PATH=$(cd "$(dirname "$0")"; cd ..; pwd)
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin

# set env variables for darwin
# nothing now...
elif [ "$(uname | cut -c 1-5)" = "MINGW" ]; then
# under mingw
SCRIPT_DIR=$(dirname "$(readlink -f "$0")")
EMULATOR_INSTALLED_PATH=$(readlink -f "$SCRIPT_DIR/..")
EMULATOR_BIN_PATH=$EMULATOR_INSTALLED_PATH/bin
# set env variables for windows
export SDL_STDIO_REDIRECT=0
fi

# set platform independent environment variables
export GL_VERSION=2
export VIGS_SYNC_READ_PIXELS=1

# check "--with-gdb"
WITH_GDB="no"
if [ "$1" = "--with-gdb" ]; then
	shift
	WITH_GDB="yes"
fi

# try to use default conf file if no options provided
if [ -z $1 ]; then
	if [ -e $HOME/.emulator_default.conf ]; then
		set -- "--conf" "$HOME/.emulator_default.conf"
		echo "No options provided. Use default conf file [$HOME/.emulator_default.conf]."
	fi
fi

if [ -z $SWT_GTK3 ]; then
    export SWT_GTK3=0
fi

# run emulator
if [ "$WITH_GDB" = "yes" ]; then
	gdb --args "$EMULATOR_BIN_PATH/emulator-x86" "$@"
else
	"$EMULATOR_BIN_PATH/emulator-x86" "$@"
fi
