/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.IMessage;
import org.tizen.ecp.sock.SocketConstants;
import org.tizen.ecp.sock.SocketReceive;
import org.tizen.ecp.utils.LogUtil;

public class SocketClient {
    private static SocketClient client;
    private Logger logger = null;
    private Socket socket;
    private String ip = SocketConstants.DefaultIp;
    private int port = SocketConstants.DefaultPort;
    private boolean guestStatus = true;
    private DataOutputStream output;
    private DataInputStream input;
    private LinkedList<String> receiveQueue = new LinkedList();
    private List<IMessage> listeners = new ArrayList<IMessage>();
    private boolean running = false;
    private Thread receiveThread = null;
    private List<IConnection> connectionLsns = new ArrayList<IConnection>();

    public DataOutputStream getOutputStream() {
        return this.output;
    }

    public DataInputStream getInputStream() {
        return this.input;
    }

    public SocketClient() {
        LogUtil logUtil = LogUtil.getECPLogger(SocketClient.class);
        if (logUtil != null) {
            this.logger = logUtil.getLogger();
        }
    }

    public static SocketClient getInstance() {
        if (null == client) {
            client = new SocketClient();
        }
        return client;
    }

    public boolean connect() {
        return this.connect(this.port);
    }

    public boolean connect(int port) {
        try {
            this.socket = new Socket(this.ip, port);
            if (this.logger != null) {
                this.logger.info("socket created.ip: " + this.ip + ", port: " + port);
            }
            this.socket.setReuseAddress(true);
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.input = new DataInputStream(this.socket.getInputStream());
            this.running = true;
            this.receiveThread = new Thread(null, new SocketReceive(), "Socket Receive Thread");
            this.receiveThread.start();
        }
        catch (SocketException e) {
            if (this.logger != null) {
                this.logger.warning(e.getMessage());
            }
            return false;
        }
        catch (IOException e) {
            if (this.logger != null) {
                this.logger.warning(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public boolean tryClose(Object ... closeables) {
        if (null == closeables) {
            return false;
        }
        for (Object obj : closeables) {
            if (null == obj) continue;
            try {
                if (obj instanceof Closeable) {
                    ((Closeable)obj).close();
                    continue;
                }
                if (obj instanceof DataOutputStream) {
                    ((DataOutputStream)obj).close();
                    continue;
                }
                if (obj instanceof DataInputStream) {
                    ((DataInputStream)obj).close();
                    continue;
                }
                if (!(obj instanceof Socket)) continue;
                ((Socket)obj).close();
            }
            catch (IOException e) {
                if (this.logger != null) {
                    this.logger.warning(e.getMessage());
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect() {
        boolean result = false;
        this.running = false;
        if (null != this.receiveQueue) {
            LinkedList<String> linkedList = this.receiveQueue;
            synchronized (linkedList) {
                this.receiveQueue.notifyAll();
            }
        }
        try {
            if (this.receiveThread.isAlive()) {
                this.receiveThread.join(10L);
            }
        }
        catch (InterruptedException e) {
            this.logger.info("receiveThread join is interrupted.");
        }
        result = this.tryClose(this.input, this.output, this.socket);
        this.fireDisconnectEvent();
        return result;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isConnected() {
        if (null == this.socket) {
            return false;
        }
        return this.socket.isConnected();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean run) {
        this.running = run;
    }

    public LinkedList<String> getReceiveQueue() {
        return this.receiveQueue;
    }

    public void addListener(IMessage iMessage) {
        this.listeners.add(iMessage);
    }

    public List<IMessage> getListener() {
        return this.listeners;
    }

    public void setGuestStatus(boolean status) {
        this.guestStatus = status;
        if (status) {
            this.fireGuestOnEvent();
        } else {
            this.fireGuestOffEvent();
        }
    }

    public boolean getGuestStatus() {
        return this.guestStatus;
    }

    public synchronized void registerDisconnectListener(IConnection listener) {
        this.connectionLsns.add(listener);
    }

    private synchronized void fireDisconnectEvent() {
        for (IConnection conn : this.connectionLsns) {
            conn.disconnected();
        }
    }

    private synchronized void fireGuestOnEvent() {
        for (IConnection conn : this.connectionLsns) {
            conn.guestOn();
        }
    }

    private synchronized void fireGuestOffEvent() {
        for (IConnection conn : this.connectionLsns) {
            conn.guestOff();
        }
    }

    public synchronized void fireGuestOffMessage() {
        for (IConnection conn : this.connectionLsns) {
            conn.guestOffMessage();
        }
    }
}

