/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import com.google.protobuf.GeneratedMessage;
import org.json.simple.JSONObject;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.ListenMap;
import org.tizen.ecp.sock.ListenSet;

public class EventMgr {
    private ListenMap<ListenSet<ILsn>> m_lsns = new ListenMap();
    private static EventMgr _inst;

    public static EventMgr getInstance() {
        if (null == _inst) {
            _inst = new EventMgr();
        }
        return _inst;
    }

    public void AddLsnSet(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (this.m_lsns.Find(name) != null) {
            return;
        }
        ListenSet lsn = new ListenSet();
        this.m_lsns.add(name, lsn);
    }

    public void RemoveLsnSet(String name) {
        if (name != null && !name.isEmpty()) {
            this.m_lsns.remove(name);
        }
    }

    public void AddLsn(String name, ILsn lsn) {
        if (name != null && lsn != null && !name.isEmpty()) {
            ListenSet<ILsn> set = this.m_lsns.Find(name);
            if (set == null) {
                this.AddLsnSet(name);
                this.AddLsn(name, lsn);
            } else {
                set.add(lsn);
            }
        }
    }

    public void RemoveLsn(String name, ILsn lsn) {
        if (name == null || name.isEmpty()) {
            return;
        }
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        set.remove(lsn);
    }

    public void Invoke(String name, JSONObject param) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            ILsn lsn = set.get(i);
            if (lsn == null) continue;
            lsn.OnEventProc(name, param);
        }
    }

    public void InvokePB(String name, GeneratedMessage param) {
        ListenSet<ILsn> set = this.m_lsns.Find(name);
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            int group;
            ILsn lsn = set.get(i);
            if (lsn == null) continue;
            if (param instanceof Ecs.InjectorNtf) {
                Ecs.InjectorNtf ijntf = (Ecs.InjectorNtf)param;
                group = ijntf.getGroup();
                if (group == 15) {
                    lsn.OnStatusEventProcPB(param);
                    continue;
                }
                lsn.OnEventProcPB(name, param);
                continue;
            }
            if (param instanceof Ecs.DeviceNtf) {
                Ecs.DeviceNtf devNtf = (Ecs.DeviceNtf)param;
                group = devNtf.getGroup();
                if (group == 15) {
                    lsn.OnStatusEventProcPB(param);
                    continue;
                }
                lsn.OnEventProcPB(name, param);
                continue;
            }
            lsn.OnEventProcPB(name, param);
        }
    }
}

