/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.utils;

import org.tizen.cli.CLIManager;
import org.tizen.ecp.resources.StringResources;

public class OutputUtil {
    public static void println() {
        System.out.println();
    }

    public static void print(String output) {
        System.out.print(output);
    }

    public static void println(String output) {
        System.out.println(output);
    }

    public static void printFormatList(String name, String value) {
        OutputUtil.println(OutputUtil.getFormatList(name, value));
    }

    public static String getFormatList(String name) {
        return String.format("\t%-13s\n", name);
    }

    public static String getFormatList(String name, String value) {
        return String.format("\t%-13s : %s\n", name, value);
    }

    public static void printDeviceUsage(String device) {
        OutputUtil.print(OutputUtil.getDeviceUsage(device));
    }

    public static String getDeviceUsage(String device) {
        return "Usage: " + (CLIManager.getInstance().getSessionMode() ? "" : "ecp-cli [--target <VM name | serial>]") + " " + device + " " + "[cmds]" + StringResources.NEW_LINE + StringResources.NEW_LINE;
    }

    public static void printError(String desc) {
        OutputUtil.println("ERROR: " + desc);
    }

    public static void printError(String desc, Exception e) {
        OutputUtil.printError("ERROR: " + desc + "\"" + e.getMessage() + "\"");
    }

    public static void printError(String desc, String cause) {
        OutputUtil.println("ERROR: " + desc + " " + "\"" + cause + "\"");
    }

    public static void printHelpError(String desc, String help) {
        OutputUtil.println("ERROR: " + desc + StringResources.NEW_LINE + help);
    }

    public static void printOK() {
        OutputUtil.println("SUCCESS");
    }

    public static void printOK(String desc) {
        OutputUtil.println("SUCCESS : " + desc);
    }

    public static void printStatus(String key, String value) {
        OutputUtil.print(OutputUtil.getFormatList(key, value));
    }

    public static void printFail() {
        OutputUtil.println("FAIL");
    }

    public static String appendComplete(String des, String src) {
        return des + src;
    }

    public static void debug(String desc) {
    }
}

