/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.device;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.widgets.ECPButton;

public class HDSDisplay
extends ECPSubView
implements ILsn {
    private static final String HDS_MOUNT = "Mount";
    private static final String HDS_UMOUNT = "Unmount";
    private static final String HDS_CATEGORY = "hds";
    private static final String HDS_BROWSE = "Browse";
    private static final String HDS_TITLE = "Host Directory Sharing";
    private static final String HDS_GUEST_DEFAULT_PATH = "/mnt/host";
    private static final int HDS_ACT_MOUNT = 1;
    private static final int HDS_ACT_UMOUNT = 2;
    private static final int HDS_ACT_SLEEP = 1500;
    private static final int HDS_STRING_WIDTH = 90;
    private static final String END_LINE = "\n";
    private static Logger logger = LogUtil.getECPLogger(HDSDisplay.class).getLogger();
    private Text directoryText;
    private Text destText;
    private String directoryString;
    private ECPButton browserButton;
    private ECPButton mountButton;
    private ECPButton unmountButton;

    public HDSDisplay() {
        this.title = HDS_TITLE;
        this.pageHeight = 120;
    }

    @Override
    public void createView(Composite composite) {
        FormUtil.createLabel(composite, "Mount / Unmount", FontResources.FONT_12.getFont(), ColorResources.TEXT_GREEN.getColor());
        FormUtil.createVerticalSpace(composite, 4);
        Composite comp = FormUtil.createComposite(composite, 3);
        FormUtil.createLabel(comp, "Host Directory", true, 90);
        this.directoryText = FormUtil.createText(comp, "");
        GridData gd = FormUtil.createHGD();
        this.directoryText.setLayoutData((Object)gd);
        this.directoryText.setEditable(false);
        this.browserButton = FormUtil.createPushButton(comp, HDS_BROWSE);
        this.browserButton.setLayoutData(FormUtil.createGD(80, 20));
        this.browserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(new Shell());
                String dir = dialog.open();
                if (dir == null || dir.isEmpty()) {
                    return;
                }
                HDSDisplay.this.directoryString = dir;
                HDSDisplay.this.directoryText.setText(HDSDisplay.this.directoryString);
                if (!HDSDisplay.this.mountButton.isEnabled()) {
                    HDSDisplay.this.mountButton.setEnabled(true);
                }
            }
        });
        Composite destComp = FormUtil.createComposite(composite, 2);
        FormUtil.createLabel(destComp, "Destination", true, 90);
        this.destText = FormUtil.createText(destComp, 0x1000800);
        this.destText.setText(HDS_GUEST_DEFAULT_PATH);
        this.destText.setEditable(false);
        this.destText.setTextLimit(256);
        gd = new GridData(4, 2, true, false);
        this.destText.setLayoutData((Object)gd);
        Composite btnComp = FormUtil.createComposite(composite, 2);
        this.mountButton = FormUtil.createPushButton(btnComp, HDS_MOUNT);
        this.mountButton.setLayoutData(FormUtil.createGD(80, 22));
        this.mountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!HDSDisplay.this.validateHost(HDSDisplay.this.directoryText.getText())) {
                    MessageDialog dialog = new MessageDialog();
                    dialog.openInfoDialog("Please select host directory by 'Browser' button.\n");
                    return;
                }
                if (!HDSDisplay.this.validateDest(HDSDisplay.this.destText.getText())) {
                    MessageDialog dialog = new MessageDialog();
                    dialog.openInfoDialog("Please change the destination.\nIt can be under directory of '/opt' or '/mnt' only");
                    return;
                }
                HDSDisplay.this.doMount();
                HDSDisplay.this.disableButton();
            }
        });
        this.unmountButton = FormUtil.createPushButton(btnComp, HDS_UMOUNT);
        this.unmountButton.setLayoutData(FormUtil.createGD(80, 22));
        this.unmountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HDSDisplay.this.doUnMount();
                HDSDisplay.this.disableButton();
            }
        });
    }

    private boolean validateHost(String text) {
        return !text.isEmpty();
    }

    private boolean validateDest(String text) {
        return text.startsWith("/opt") || text.startsWith("/mnt");
    }

    private void initialButton() {
        this.browserButton.setEnabled(true);
        this.mountButton.setEnabled(true);
        this.unmountButton.setEnabled(false);
    }

    private void mountedButton() {
        this.browserButton.setEnabled(false);
        this.mountButton.setEnabled(false);
        this.unmountButton.setEnabled(true);
    }

    private void unMountedButton() {
        this.browserButton.setEnabled(true);
        this.mountButton.setEnabled(true);
        this.unmountButton.setEnabled(false);
        this.mountButton.setText(HDS_MOUNT);
    }

    private void disableButton() {
        this.browserButton.setEnabled(false);
        this.mountButton.setEnabled(false);
        this.unmountButton.setEnabled(false);
    }

    private void sendHDSMessage(int group, int action) {
        this.sendHDSMessage(group, action, "");
    }

    private void sendHDSMessage(int group, int action, String data) {
        MessageSender.getInstance().sendDeviceReq(HDS_CATEGORY, group, action, data);
    }

    private void doMount() {
        String msg = this.directoryString + END_LINE + this.destText.getText() + END_LINE;
        this.sendHDSMessage(100, 1, msg);
    }

    private void doUnMount() {
        this.sendHDSMessage(100, 2);
    }

    @Override
    protected void initializeWidget() {
        this.initialButton();
    }

    public void displayContents(VMView instance) {
        super.showComposite();
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        Ecs.DeviceNtf ntf;
        if (param instanceof Ecs.DeviceNtf && 100 == (ntf = (Ecs.DeviceNtf)param).getGroup()) {
            int action = ntf.getAction();
            logger.info("HDS NTF action: " + action);
            if (action == 1) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted ", e);
                }
                this.mountedButton();
            } else if (action == 2) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted ", e);
                }
                if (this.directoryString == null || this.directoryString.isEmpty()) {
                    this.initialButton();
                } else {
                    this.unMountedButton();
                }
            } else if (action == 3) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted ", e);
                }
                this.destText.setText(HDS_GUEST_DEFAULT_PATH);
                this.unMountedButton();
            } else if (action == 4) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted ", e);
                }
                this.mountedButton();
            } else if (action == 5) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interrupted ", e);
                }
                this.mountedButton();
            } else {
                logger.info("HDS unknown action notification: " + action);
            }
        }
    }

    @Override
    public void OnStatusEventProcPB(GeneratedMessage param) {
        Ecs.DeviceNtf ntf;
        if (param instanceof Ecs.DeviceNtf && 99 == (ntf = (Ecs.DeviceNtf)param).getAction()) {
            String data = ntf.getData().toStringUtf8();
            logger.info("HDS status is " + data);
            if (data == null || data.isEmpty()) {
                return;
            }
            String[] received = data.split(", ");
            if (received[0].equals("0")) {
                this.destText.setText(HDS_GUEST_DEFAULT_PATH);
                if (this.directoryString == null || this.directoryString.isEmpty()) {
                    this.initialButton();
                } else {
                    this.unMountedButton();
                }
            } else if (received[0].equals("1") && received[1] != null && !received[1].isEmpty()) {
                this.directoryString = received[1];
                this.directoryText.setText(this.directoryString);
                this.destText.setText(HDS_GUEST_DEFAULT_PATH);
                this.mountedButton();
            } else {
                logger.info("unknown HDS status : " + data);
            }
        }
    }

    @Override
    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn(HDS_CATEGORY, this);
        return true;
    }

    @Override
    public void OnActivate() {
        this.sendHDSMessage(15, 99);
    }
}

