/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.timer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Timer;
import org.eclipse.swt.widgets.Display;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.views.ViewMgr;

public class MessageTimer {
    private static MessageTimer instance;
    private Timer timer;
    private boolean mouseDown;
    private ActionListener timerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (MessageSender.getInstance().isMessageTimerExpired()) {
                        if (!MessageTimer.this.mouseDown) {
                            ViewMgr.getInstance().MessageTimerActivate();
                        }
                    } else {
                        MessageSender.getInstance().setMessageTimerExpired(true);
                    }
                }
            });
        }
    };

    public static MessageTimer getInstance() {
        if (instance == null) {
            instance = new MessageTimer();
        }
        return instance;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isRunning() throws IOException {
        if (this.timer == null) {
            throw new IOException("timer is Null");
        }
        return this.timer.isRunning();
    }

    public void setMouseDown(boolean down) {
        this.mouseDown = down;
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }

    public void startTimer(int time) {
        if (this.timer == null) {
            this.timer = new Timer(time, this.timerListener);
        }
        this.timer.start();
    }

    public void StopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void RestartTimer() {
        if (this.timer != null) {
            this.timer.restart();
        }
    }
}

