/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.CLIManager;
import org.tizen.cli.ConnectionManager;
import org.tizen.cli.utils.ArgsUtil;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xml.CliTypes;

public class TizenEmulatorAutoComplete {
    private static final String PLUGIN_XML = "ecp-plugin.xml";

    private static void initializeECPInfo(String name, int port) throws IOException, JAXBException {
        VMInfo.getInstance().initialize(name, port);
        String ecpInfoPath = VMInfo.getInstance().getPluginPath() + File.separator + PLUGIN_XML;
        ECPInfo.getInstance().initialize(ecpInfoPath);
    }

    private static String appendComplete(String des, String src) {
        return des + (src + " ");
    }

    private static String getDeviceList(boolean help) {
        String devices = "";
        List deviceList = ECPInfo.getInstance().getCLIInfo();
        String[] qmpCmds = new String[]{"hmp", "qmp", "keycode", "hds"};
        if (deviceList != null) {
            for (CliTypes.Device d : deviceList) {
                devices = TizenEmulatorAutoComplete.appendComplete(devices, d.getName() + " ");
            }
            for (String elsecmd : qmpCmds) {
                devices = TizenEmulatorAutoComplete.appendComplete(devices, elsecmd + " ");
            }
        }
        if (help) {
            devices = TizenEmulatorAutoComplete.appendComplete(devices, "help");
        }
        return devices;
    }

    private static String getCommandList(String device) throws ClassNotFoundException {
        String command = "";
        CliTypes.Device matchDevice = CLIManager.getInstance().findDevice(device);
        if (matchDevice == null) {
            return command;
        }
        Class dClass = DynamicLoader.dynamicLoadClass((String)ECPInfo.getInstance().getJarPath(), (String)matchDevice.getImpl());
        if (dClass == null) {
            return command;
        }
        for (Field field : dClass.getDeclaredFields()) {
            SubCommands cmds = field.getAnnotation(SubCommands.class);
            if (cmds == null) continue;
            for (SubCommand cmd : cmds.value()) {
                command = TizenEmulatorAutoComplete.appendComplete(command, cmd.name() + " ");
            }
        }
        return command;
    }

    private static String getArgsList(String device, String command) throws ClassNotFoundException {
        String argsList = "";
        CliTypes.Device matchDevice = CLIManager.getInstance().findDevice(device);
        if (matchDevice == null || command == null || command.isEmpty()) {
            return argsList;
        }
        Class dClass = DynamicLoader.dynamicLoadClass((String)ECPInfo.getInstance().getJarPath(), (String)matchDevice.getImpl());
        if (dClass == null) {
            return argsList;
        }
        for (Field f : dClass.getDeclaredFields()) {
            SubCommands cmds = f.getAnnotation(SubCommands.class);
            if (cmds == null) continue;
            for (SubCommand cmd : cmds.value()) {
                Class matchClass;
                if (!cmd.name().equals(command) || (matchClass = DynamicLoader.dynamicLoadClass((String)ECPInfo.getInstance().getJarPath(), (String)cmd.impl().getCanonicalName())) == null) continue;
                for (Field field : matchClass.getDeclaredFields()) {
                    String[] metaArgs;
                    Argument argument = field.getAnnotation(Argument.class);
                    if (argument == null) continue;
                    for (String value : metaArgs = argument.metaVar().split(" ")) {
                        if (value == null || value.isEmpty()) continue;
                        argsList = TizenEmulatorAutoComplete.appendComplete(argsList, value + " ");
                    }
                }
            }
        }
        return argsList;
    }

    private static void checkTarget(String[] args) {
        List<EmulatorDevice> devices = CLIManager.getInstance().getDevices();
        if (ArgsUtil.isTargetSpecified(args)) {
            String targetSpecified = ArgsUtil.getTargetSpecified(args);
            for (EmulatorDevice dev : devices) {
                String name = dev.getVmName();
                String target = dev.getTarget();
                if ((name == null || !name.equals(targetSpecified)) && (target == null || !target.equals(targetSpecified))) continue;
                CLIManager.getInstance().setSelectedDevice(dev);
            }
        } else if (devices.size() == 1) {
            CLIManager.getInstance().setSelectedDevice(devices.get(0));
        }
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException, JAXBException {
        EmulatorDevice device;
        String complete = "";
        String[] argument = args;
        ConnectionManager.getInstance().checkServer();
        TizenEmulatorAutoComplete.checkTarget(argument);
        if (ArgsUtil.isTargetOptionSpecified(argument) && !ArgsUtil.isTargetSpecified(argument)) {
            System.exit(0);
        }
        if ((device = CLIManager.getInstance().getSelectedDevice()) == null && args.length == 1) {
            System.out.println("help");
            System.exit(0);
        } else if (device == null) {
            System.exit(0);
        }
        TizenEmulatorAutoComplete.initializeECPInfo(device.getVmName(), device.getPort() - 3);
        if (ArgsUtil.isTargetSpecified(argument) && (argument = ArgsUtil.removeTargetSpecified(argument)) == null) {
            System.exit(0);
        }
        if (argument.length == 1) {
            complete = TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getDeviceList(true));
        } else if (argument.length == 2) {
            complete = argument[1].toLowerCase().equals("help") ? TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getDeviceList(false)) : TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getCommandList(argument[1]));
        } else if (argument.length == 3) {
            complete = TizenEmulatorAutoComplete.appendComplete(complete, TizenEmulatorAutoComplete.getArgsList(argument[1], argument[2]));
        }
        if (complete != null && !complete.isEmpty()) {
            System.out.println(complete.trim());
        }
        System.exit(0);
    }
}

