/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialogs;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class MessageDialog {
    private Shell shell;
    private static final String INFO = "Info";
    private static final String WARNING = "Warning";
    private static final String ERROR = "Error";
    private static final String DIALOG_EMULATOR_NOT_READY = "Emulator is not ready. Please retry when the emulator is ready.";

    public MessageDialog(Shell shell) {
        this.shell = shell;
    }

    public MessageDialog() {
        this.shell = new Shell();
    }

    public int openInfoDialog(String message) {
        return this.openInfoDialog(INFO, message);
    }

    public int openInfoDialog(String title, String message) {
        return this.openMessageDialog(title, message, 2, 32);
    }

    public int openWarningDialog(String message) {
        return this.openWarningDialog(WARNING, message);
    }

    public int openWarningDialog(String title, String message) {
        return this.openMessageDialog(title, message, 8, 32);
    }

    public int openSelectionDialog(String message) {
        return this.openSelectionDialog(WARNING, message);
    }

    public int openSelectionDialog(String title, String message) {
        return this.openMessageDialog(title, message, 8, 288);
    }

    public int openErrorDialog(String message) {
        return this.openErrorDialog(ERROR, message);
    }

    public int openErrorDialog(String title, String message) {
        return this.openMessageDialog(title, message, 1, 32);
    }

    public int openNotReadyDialog() {
        return this.openMessageDialog(ERROR, DIALOG_EMULATOR_NOT_READY, 1, 32);
    }

    public int openMessageDialog(String title, String message, int icon_style, int style) {
        Shell dShell = new Shell(this.shell, 67680);
        MessageBox dialog = new MessageBox(dShell, icon_style | style);
        dialog.setText(title);
        dialog.setMessage(message);
        return dialog.open();
    }
}

