/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.tizen.emulator.skin.EmulatorFingers;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.data.DisplayStateData;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.OptionType;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.SdlScreenShotWindow;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorSdlSkin
extends EmulatorSkin {
    public static final int DISPLAY_COLOR_DEPTH = 32;
    private Logger logger = SkinLogger.getSkinLogger(EmulatorSdlSkin.class).getLogger();
    private PaletteData palette = new PaletteData(65280, 0xFF0000, -16777216);
    protected static int pressingX = -1;
    protected static int pressingY = -1;
    protected static int pressingOriginX = -1;
    protected static int pressingOriginY = -1;
    private EmulatorFingers fingers;
    private int multiTouchKey;
    private int multiTouchKeySub1;
    private int multiTouchKeySub2;

    public EmulatorSdlSkin(EmulatorConfig config, SkinInformation skinInfo, boolean isOnTop) {
        super(config, skinInfo, 0x1000000, isOnTop);
    }

    @Override
    protected void skinFinalize() {
        if (this.fingers != null) {
            this.fingers.cleanupMultiTouchState();
        }
        super.skinFinalize();
    }

    @Override
    public StartData initSkin() {
        this.initLayout();
        this.multiTouchKey = 262144;
        this.multiTouchKeySub1 = 131072;
        this.multiTouchKeySub2 = 65536;
        this.fingers = new EmulatorFingers(this, this.palette, this.config.getArgInt("input.touch.maxpoint"));
        long id = this.getDisplayHandleId();
        int width = this.getEmulatorSkinState().getCurrentResolutionWidth();
        int height = this.getEmulatorSkinState().getCurrentResolutionHeight();
        int scale = this.getEmulatorSkinState().getCurrentScale();
        short rotation = this.getEmulatorSkinState().getCurrentRotationId();
        boolean isBlankGuide = true;
        OptionType option = this.config.getDbiContents().getOption();
        if (option != null) {
            isBlankGuide = option.getBlankGuide() == null ? true : option.getBlankGuide().isVisible();
        }
        StartData startData = new StartData(id, width, height, scale, rotation, isBlankGuide);
        this.logger.info("" + startData);
        return startData;
    }

    private long getDisplayHandleId() {
        long windowHandleId = 0L;
        if (SwtUtil.isLinuxPlatform()) {
            try {
                Field field = ((Object)((Object)this.displayCanvas)).getClass().getField("embeddedHandle");
                windowHandleId = field.getLong((Object)this.displayCanvas);
                this.logger.info("displayCanvas.embeddedHandle:" + windowHandleId);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (SecurityException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (NoSuchFieldException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
        } else if (SwtUtil.isWindowsPlatform()) {
            try {
                Field field = ((Object)((Object)this.displayCanvas)).getClass().getField("handle");
                windowHandleId = field.getLong((Object)this.displayCanvas);
                this.logger.info("displayCanvas.handle:" + windowHandleId);
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (SecurityException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
            catch (NoSuchFieldException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.shutdown();
            }
        } else {
            this.logger.severe("Not Supported OS platform:" + SWT.getPlatform());
            this.shutdown();
        }
        return windowHandleId;
    }

    @Override
    public void updateDisplay() {
        this.logger.info("update display");
        DisplayStateData stateData = new DisplayStateData(this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_DISPLAY_STATE, stateData, false);
    }

    @Override
    public void displayOn() {
        super.displayOn();
    }

    @Override
    public void displayOff() {
        super.displayOff();
    }

    @Override
    protected void mouseMoveDelivery(MouseEvent e, int eventType) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(eventType, e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(eventType, e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(eventType, e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), eventType, e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseUpDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        this.logger.info("mouseUp in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingY = -1;
        pressingX = -1;
        pressingOriginY = -1;
        pressingOriginX = -1;
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseDownDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        this.logger.info("mouseDown in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingX = geometry[0];
        pressingY = geometry[1];
        pressingOriginX = e.x;
        pressingOriginY = e.y;
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void keyReleasedDelivery(int keyCode, int stateMask, int keyLocation, boolean remove) {
        if (this.fingers.getMaxTouchPoint() > 1) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (keyCode == this.multiTouchKey || keyCode == this.multiTouchKeySub1) {
                if (tempStateMask == (this.multiTouchKeySub1 | this.multiTouchKey)) {
                    this.fingers.setMultiTouchEnable(1);
                    this.logger.info("enable multi-touch mode 2->1");
                } else {
                    this.fingers.clearFingerSlot(false);
                    this.logger.info("disable multi-touch");
                }
            } else if (keyCode == this.multiTouchKeySub2) {
                if (tempStateMask == (this.multiTouchKey | this.multiTouchKeySub2)) {
                    this.fingers.setMultiTouchEnable(1);
                    this.logger.info("enable multi-touch mode 3->1");
                } else {
                    this.fingers.clearFingerSlot(false);
                    this.logger.info("disable multi-touch");
                }
            }
        }
        super.keyReleasedDelivery(keyCode, stateMask, keyLocation, remove);
    }

    @Override
    protected void keyPressedDelivery(int keyCode, int stateMask, int keyLocation, boolean add) {
        if (this.fingers.getMaxTouchPoint() > 1) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (keyCode == this.multiTouchKey && tempStateMask == this.multiTouchKeySub2 || keyCode == this.multiTouchKeySub2 && tempStateMask == this.multiTouchKey) {
                for (int i = this.fingers.getFingerCnt(); i > 2; --i) {
                    this.fingers.removeFingerPointFromSlot(i - 1);
                }
                this.fingers.setMultiTouchEnable(3);
                this.logger.info("enable multi-touch mode 3");
            } else if (keyCode == this.multiTouchKey && tempStateMask == this.multiTouchKeySub1 || keyCode == this.multiTouchKeySub1 && tempStateMask == this.multiTouchKey) {
                this.fingers.setMultiTouchEnable(2);
                this.logger.info("enable multi-touch mode 2");
            } else if (keyCode == this.multiTouchKeySub1 || keyCode == this.multiTouchKey) {
                this.fingers.setMultiTouchEnable(1);
                this.logger.info("enable multi-touch mode 1");
            } else if (this.fingers.getMultiTouchEnable() != 0) {
                this.fingers.clearFingerSlot(false);
                this.logger.info("disable multi-touch");
            }
        }
        super.keyPressedDelivery(keyCode, stateMask, keyLocation, add);
    }

    @Override
    protected void openScreenShotWindow() {
        if (this.screenShotDialog != null) {
            this.logger.info("screenshot window was already opened");
            return;
        }
        this.screenShotDialog = new SdlScreenShotWindow(this, this.config, this.palette, this.imageRegistry.getIcon(ImageRegistry.IconName.SCREENSHOT));
        try {
            this.screenShotDialog.open();
        }
        catch (ScreenShotException ex) {
            this.screenShotDialog = null;
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "Fail to create a screen shot.", 1, this.config);
        }
        catch (Exception ex) {
            this.screenShotDialog = null;
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "ScreenShot is not ready.\nPlease wait until the emulator is completely boot up.", 8, this.config);
        }
    }
}

