/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorFingers;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.OptionType;
import org.tizen.emulator.skin.exception.ScreenShotException;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.screenshot.ShmScreenShotWindow;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorShmSkin
extends EmulatorSkin {
    public static final String JNI_LIBRARY_FILE = "shared";
    public static final int DISPLAY_COLOR_DEPTH = 24;
    private static Logger logger = SkinLogger.getSkinLogger(EmulatorShmSkin.class).getLogger();
    private PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
    private BufferPainter bufferPainter;
    private Image imageCover;
    protected static int pressingX;
    protected static int pressingY;
    protected static int pressingOriginX;
    protected static int pressingOriginY;
    private EmulatorFingers fingers;
    private int multiTouchKey;
    private int multiTouchKeySub1;
    private int multiTouchKeySub2;

    public native int shmget(int var1, int var2);

    public native int shmdt();

    public native int getPixels(int[] var1);

    public EmulatorShmSkin(EmulatorConfig config, SkinInformation skinInfo, boolean isOnTop) {
        super(config, skinInfo, 0, isOnTop);
    }

    @Override
    protected void skinFinalize() {
        this.bufferPainter.stopRequest();
        if (this.fingers != null) {
            this.fingers.cleanupMultiTouchState();
        }
        super.skinFinalize();
    }

    @Override
    public StartData initSkin() {
        this.initLayout();
        this.multiTouchKey = SwtUtil.isMacPlatform() ? 0x400000 : 262144;
        this.multiTouchKeySub1 = 131072;
        this.multiTouchKeySub2 = 65536;
        this.fingers = new EmulatorFingers(this, this.palette, this.config.getArgInt("input.touch.maxpoint"));
        this.initDisplay();
        int width = this.getEmulatorSkinState().getCurrentResolutionWidth();
        int height = this.getEmulatorSkinState().getCurrentResolutionHeight();
        int scale = this.getEmulatorSkinState().getCurrentScale();
        short rotation = this.getEmulatorSkinState().getCurrentRotationId();
        boolean isBlankGuide = true;
        OptionType option = this.config.getDbiContents().getOption();
        if (option != null) {
            isBlankGuide = option.getBlankGuide() == null ? true : option.getBlankGuide().isVisible();
        }
        StartData startData = new StartData(0L, width, height, scale, rotation, isBlankGuide);
        logger.info("" + startData);
        return startData;
    }

    private void initDisplay() {
        int shmkey = this.config.getArgInt("vm.baseport") + 2;
        logger.info("shmkey = " + shmkey);
        int result = this.shmget(shmkey, this.currentState.getCurrentResolutionWidth() * this.currentState.getCurrentResolutionHeight() * 4);
        logger.info("shmget native function returned " + result);
        if (result == 1) {
            logger.severe("Failed to get identifier of the shared memory segment.");
            SkinUtil.openMessage(this.shell, null, "Cannot launch this VM.\nFailed to get identifier of the shared memory segment.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        } else if (result == 2) {
            logger.severe("Failed to attach the shared memory segment.");
            SkinUtil.openMessage(this.shell, null, "Cannot launch this VM.\nFailed to attach the shared memory segment.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.bufferPainter = new BufferPainter(this.palette, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight());
        this.displayCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int screen_width = EmulatorShmSkin.this.displayCanvas.getSize().x;
                int screen_height = EmulatorShmSkin.this.displayCanvas.getSize().y;
                if (EmulatorShmSkin.this.imageCover != null) {
                    logger.info("draw cover image");
                    EmulatorShmSkin.this.drawImage(e.gc, EmulatorShmSkin.this.imageCover, screen_width, screen_height);
                    EmulatorShmSkin.this.imageCover = null;
                    return;
                }
                if (!EmulatorShmSkin.this.isOnInterpolation) {
                    e.gc.setInterpolation(0);
                } else {
                    e.gc.setInterpolation(2);
                }
                switch (EmulatorShmSkin.this.currentState.getCurrentRotationId()) {
                    case 1: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_height, screen_width);
                        e.gc.setTransform(null);
                        break;
                    }
                    case 2: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_width, screen_height);
                        e.gc.setTransform(null);
                        break;
                    }
                    case 3: {
                        e.gc.setTransform(EmulatorShmSkin.this.displayTransform);
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_height, screen_width);
                        e.gc.setTransform(null);
                        break;
                    }
                    default: {
                        e.gc.drawImage(EmulatorShmSkin.this.bufferPainter.imageFramebuffer, 0, 0, EmulatorShmSkin.this.bufferPainter.widthFB, EmulatorShmSkin.this.bufferPainter.heightFB, 0, 0, screen_width, screen_height);
                    }
                }
                if (EmulatorShmSkin.this.fingers != null && EmulatorShmSkin.this.fingers.getMultiTouchEnable() != 0) {
                    EmulatorShmSkin.this.fingers.drawFingerPoints(e.gc);
                }
            }
        });
        this.bufferPainter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisplay() {
        this.bufferPainter.getPixelsFromSharedMemory();
        BufferPainter bufferPainter = this.bufferPainter;
        synchronized (bufferPainter) {
            this.bufferPainter.notify();
        }
    }

    @Override
    public void setSuitableTransform() {
        super.setSuitableTransform();
        if (this.fingers != null) {
            this.fingers.rearrangeFingerPoints(this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        }
    }

    @Override
    public void setCoverImage(final Image image) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EmulatorShmSkin.this.imageCover = image;
                EmulatorShmSkin.this.displayCanvas.redraw();
            }
        });
    }

    private void drawImage(GC gc, Image imageSrc, int widthDst, int heightDst) {
        int widthSrc = imageSrc.getImageData().width;
        int heightSrc = imageSrc.getImageData().height;
        int margin_w = widthDst - widthSrc;
        int margin_h = heightDst - heightSrc;
        int margin = Math.min(margin_w, margin_h);
        int widthScaledImage = widthSrc;
        int heightScaledImage = heightSrc;
        if (margin < 0) {
            widthScaledImage += margin;
            heightScaledImage += margin;
        }
        gc.drawImage(imageSrc, 0, 0, widthSrc, heightSrc, (widthDst - widthScaledImage) / 2, (heightDst - heightScaledImage) / 2, widthScaledImage, heightScaledImage);
    }

    @Override
    public void displayOn() {
        super.displayOn();
    }

    @Override
    public void displayOff() {
        super.displayOff();
    }

    @Override
    protected void mouseMoveDelivery(MouseEvent e, int eventType) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(eventType, e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(eventType, e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(eventType, e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), eventType, e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseUpDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseUp in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingY = -1;
        pressingX = -1;
        pressingOriginY = -1;
        pressingOriginX = -1;
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void mouseDownDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseDown in display x:" + geometry[0] + " y:" + geometry[1]);
        pressingX = geometry[0];
        pressingY = geometry[1];
        pressingOriginX = e.x;
        pressingOriginY = e.y;
        if (this.fingers.getMultiTouchEnable() == 1) {
            this.fingers.maruFingerProcessing1(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 2) {
            this.fingers.maruFingerProcessing2(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        if (this.fingers.getMultiTouchEnable() == 3) {
            this.fingers.maruFingerProcessing3(ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1]);
            this.displayCanvas.redraw();
            return;
        }
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    @Override
    protected void keyReleasedDelivery(int keyCode, int stateMask, int keyLocation, boolean remove) {
        if (this.fingers.getMaxTouchPoint() > 1) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (keyCode == this.multiTouchKey || keyCode == this.multiTouchKeySub1) {
                if (tempStateMask == (this.multiTouchKeySub1 | this.multiTouchKey)) {
                    this.fingers.setMultiTouchEnable(1);
                    logger.info("enable multi-touch mode 2->1");
                } else {
                    this.fingers.clearFingerSlot(false);
                    logger.info("disable multi-touch");
                }
                this.displayCanvas.redraw();
            } else if (keyCode == this.multiTouchKeySub2) {
                if (tempStateMask == (this.multiTouchKey | this.multiTouchKeySub2)) {
                    this.fingers.setMultiTouchEnable(1);
                    logger.info("enable multi-touch mode 3->1");
                } else {
                    this.fingers.clearFingerSlot(false);
                    logger.info("disable multi-touch");
                }
                this.displayCanvas.redraw();
            }
        }
        super.keyReleasedDelivery(keyCode, stateMask, keyLocation, remove);
    }

    @Override
    protected void keyPressedDelivery(int keyCode, int stateMask, int keyLocation, boolean add) {
        if (this.fingers.getMaxTouchPoint() > 1) {
            int tempStateMask = stateMask & 0xFFF7FFFF;
            if (keyCode == this.multiTouchKey && tempStateMask == this.multiTouchKeySub2 || keyCode == this.multiTouchKeySub2 && tempStateMask == this.multiTouchKey) {
                for (int i = this.fingers.getFingerCnt(); i > 2; --i) {
                    this.fingers.removeFingerPointFromSlot(i - 1);
                }
                this.displayCanvas.redraw();
                this.fingers.setMultiTouchEnable(3);
                logger.info("enable multi-touch mode 3");
            } else if (keyCode == this.multiTouchKey && tempStateMask == this.multiTouchKeySub1 || keyCode == this.multiTouchKeySub1 && tempStateMask == this.multiTouchKey) {
                this.fingers.setMultiTouchEnable(2);
                logger.info("enable multi-touch mode 2");
            } else if (keyCode == this.multiTouchKeySub1 || keyCode == this.multiTouchKey) {
                this.fingers.setMultiTouchEnable(1);
                if (this.fingers.getFingerCnt() == 0 && pressingX != -1 && pressingY != -1 && pressingOriginX != -1 && pressingOriginY != -1) {
                    if (this.fingers.addFingerPoint(pressingOriginX, pressingOriginY, pressingX, pressingY) != -1) {
                        this.displayCanvas.redraw();
                    }
                    pressingY = -1;
                    pressingX = -1;
                    pressingOriginY = -1;
                    pressingOriginX = -1;
                }
                logger.info("enable multi-touch mode 1");
            } else if (this.fingers.getMultiTouchEnable() != 0) {
                this.fingers.clearFingerSlot(false);
                logger.info("disable multi-touch");
                this.displayCanvas.redraw();
            }
        }
        super.keyPressedDelivery(keyCode, stateMask, keyLocation, add);
    }

    @Override
    protected void openScreenShotWindow() {
        if (this.screenShotDialog != null) {
            logger.info("screenshot window was already opened");
            return;
        }
        this.screenShotDialog = new ShmScreenShotWindow(this, this.config, this.palette, this.imageRegistry.getIcon(ImageRegistry.IconName.SCREENSHOT));
        try {
            this.screenShotDialog.open();
        }
        catch (ScreenShotException ex) {
            this.screenShotDialog = null;
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "Fail to create a screen shot.", 1, this.config);
        }
        catch (Exception ex) {
            this.screenShotDialog = null;
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            SkinUtil.openMessage(this.shell, null, "ScreenShot is not ready.\nPlease wait until the emulator is completely boot up.", 8, this.config);
        }
    }

    static {
        try {
            System.loadLibrary(JNI_LIBRARY_FILE);
        }
        catch (UnsatisfiedLinkError e) {
            logger.severe("Failed to load a shared file.\n" + e);
            Shell temp = new Shell(Display.getDefault());
            MessageBox messageBox = new MessageBox(temp, 1);
            messageBox.setText("Emulator");
            messageBox.setMessage("Failed to load a JNI library file from " + System.getProperty("java.library.path") + ".\n\n" + e);
            messageBox.open();
            temp.dispose();
            EmulatorSkinMain.terminateImmediately(-1);
        }
        pressingX = -1;
        pressingY = -1;
        pressingOriginX = -1;
        pressingOriginY = -1;
    }

    class BufferPainter
    extends Thread {
        private Display display = Display.getDefault();
        private int widthFB;
        private int heightFB;
        private int sizeFramebuffer;
        private int[] arrayFramebuffer;
        private ImageData dataFramebuffer;
        private Image imageFramebuffer;
        private volatile boolean stopRequest;
        private Runnable runnable;
        private int intervalWait;

        public BufferPainter(PaletteData paletteDisplay, int widthFB, int heightFB) {
            this.widthFB = widthFB;
            this.heightFB = heightFB;
            this.sizeFramebuffer = widthFB * heightFB;
            this.arrayFramebuffer = new int[this.sizeFramebuffer];
            this.dataFramebuffer = new ImageData(widthFB, heightFB, 24, paletteDisplay);
            this.imageFramebuffer = new Image((Device)Display.getDefault(), this.dataFramebuffer);
            this.setName("BufferPainter");
            this.setDaemon(true);
            this.setWaitIntervalTime(0);
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    if (!EmulatorShmSkin.this.displayCanvas.isDisposed()) {
                        EmulatorShmSkin.this.displayCanvas.redraw();
                    }
                }
            };
        }

        public synchronized void setWaitIntervalTime(int ms) {
            this.intervalWait = ms;
        }

        public synchronized int getWaitIntervalTime() {
            return this.intervalWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.stopRequest = false;
            while (!this.stopRequest) {
                BufferPainter bufferPainter = this;
                synchronized (bufferPainter) {
                    try {
                        this.wait(this.intervalWait);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (this.stopRequest) break;
                if (this.display.isDisposed()) continue;
                this.display.asyncExec(this.runnable);
            }
            logger.info("PollFBThread is stopped");
            int result = EmulatorShmSkin.this.shmdt();
            logger.info("shmdt native function returned " + result);
        }

        public void getPixelsFromSharedMemory() {
            EmulatorShmSkin.this.getPixels(this.arrayFramebuffer);
            EmulatorShmSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.RESPONSE_DRAW_FRAME, null, true);
            this.dataFramebuffer.setPixels(0, 0, this.sizeFramebuffer, this.arrayFramebuffer, 0);
            if (!this.display.isDisposed()) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BufferPainter.this.imageFramebuffer.dispose();
                        BufferPainter.this.imageFramebuffer = new Image((Device)BufferPainter.this.display, BufferPainter.this.dataFramebuffer);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRequest() {
            this.stopRequest = true;
            BufferPainter bufferPainter = EmulatorShmSkin.this.bufferPainter;
            synchronized (bufferPainter) {
                EmulatorShmSkin.this.bufferPainter.notify();
            }
        }
    }
}

