/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.custom;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.emulator.skin.custom.CustomScrollBar;
import org.tizen.emulator.skin.custom.ScrolledCompositeLayout;
import org.tizen.emulator.skin.log.SkinLogger;

public class CustomScrolledComposite
extends Composite {
    private Logger logger = SkinLogger.getSkinLogger(CustomScrolledComposite.class).getLogger();
    Control content;
    Listener contentListener;
    Listener filter;
    Point sizeContent;
    Composite compositeRight;
    CustomScrollBar vBar;
    private Image[] imagesArrowUp;
    private Image[] imagesArrowDown;
    private Image imageThumb;
    private Image imageShaft;
    public int minHeight = 0;
    public int minWidth = 0;
    public boolean expandHorizontal = false;
    public boolean expandVertical = false;

    public CustomScrolledComposite(Composite parent, int style, Image[] imagesArrowUp, Image[] imagesArrowDown, Image imageThumb, Image imageShaft) {
        super(parent, style);
        super.setLayout((Layout)new ScrolledCompositeLayout());
        this.compositeRight = new Composite((Composite)this, 0);
        this.compositeRight.setBackground(Display.getDefault().getSystemColor(7));
        GridLayout compositeGridLayout = new GridLayout(1, false);
        compositeGridLayout.marginRight = 0;
        compositeGridLayout.marginLeft = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.verticalSpacing = 0;
        compositeGridLayout.horizontalSpacing = 0;
        this.compositeRight.setLayout((Layout)compositeGridLayout);
        this.imagesArrowUp = imagesArrowUp;
        this.imagesArrowDown = imagesArrowDown;
        this.imageThumb = imageThumb;
        this.imageShaft = imageShaft;
    }

    public CustomScrollBar getScrollBar() {
        return this.vBar;
    }

    public void setContent(Control content, Point sizeContent) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeListener(11, this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = content;
        this.sizeContent = sizeContent;
        if (this.content != null) {
            if (this.vBar == null) {
                this.compositeRight.setBackground(this.content.getBackground());
                this.vBar = new CustomScrollBar(this.compositeRight, 0, sizeContent.y, this.imagesArrowUp, this.imagesArrowDown, this.imageThumb, this.imageShaft);
            }
            content.setLocation(0, 0);
            this.layout(false);
        }
    }

    public void setExpandHorizontal(boolean expand) {
        this.checkWidget();
        if (expand == this.expandHorizontal) {
            return;
        }
        this.expandHorizontal = expand;
        this.layout(false);
    }

    public void setExpandVertical(boolean expand) {
        this.checkWidget();
        if (expand == this.expandVertical) {
            return;
        }
        this.expandVertical = expand;
        this.layout(false);
    }

    public void setMinSize(Point size) {
        if (size == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(size.x, size.y);
        }
    }

    public void setMinSize(int width, int height) {
        this.checkWidget();
        if (width == this.minWidth && height == this.minHeight) {
            return;
        }
        this.minWidth = Math.max(0, width);
        this.minHeight = Math.max(0, height);
        this.logger.info("composite minWidth : " + this.minWidth + ", minHeight : " + this.minHeight);
        this.layout(false);
    }

    public int getMinWidth() {
        this.checkWidget();
        return this.minWidth;
    }

    public int getMinHeight() {
        this.checkWidget();
        return this.minHeight;
    }

    public void vScroll() {
        if (this.content == null) {
            return;
        }
        Point location = this.content.getLocation();
        int vSelection = this.vBar.getSelection();
        this.content.setLocation(location.x, -vSelection);
    }
}

