/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.dialog;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dialog.SkinDialog;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SkinUtil;

public class RamdumpDialog
extends SkinDialog {
    public static final String RAMDUMP_DIALOG_TITLE = "Ram Dump";
    public static final String INDICATOR_IMAGE_PATH = "images/process.gif";
    private Logger logger = SkinLogger.getSkinLogger(RamdumpDialog.class).getLogger();
    private SocketCommunicator communicator;
    private Composite compositeBase;
    private ImageData[] frames;

    public RamdumpDialog(Shell parent, SocketCommunicator communicator, EmulatorConfig config) throws IOException {
        super(parent, 67680, "Ram Dump - " + SkinUtil.makeEmulatorName(config), false);
        this.communicator = communicator;
    }

    @Override
    protected Composite createArea(Composite parent) {
        Composite composite;
        try {
            composite = this.createContents(parent);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (RamdumpDialog.this.communicator.getRamdumpFlag()) {
                    RamdumpDialog.this.logger.info("do nothing");
                    event.doit = false;
                }
            }
        });
        return composite;
    }

    private Composite createContents(Composite parent) throws IOException {
        this.compositeBase = new Composite(parent, 0);
        this.compositeBase.setLayout((Layout)new GridLayout(2, false));
        final Display display = Display.getDefault();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ImageLoader loader = new ImageLoader();
        try {
            this.frames = loader.load(classLoader.getResourceAsStream(INDICATOR_IMAGE_PATH));
        }
        catch (Exception e) {
            this.frames = null;
        }
        final Label labelImage = new Label(this.compositeBase, 0);
        if (this.frames != null) {
            labelImage.setImage(new Image((Device)display, this.frames[0]));
        }
        Label waitMsg = new Label(this.compositeBase, 0);
        waitMsg.setText("     Please wait...");
        Thread animation = new Thread(){
            int currentFrame = 0;
            boolean isDisposed = false;

            @Override
            public void run() {
                while (!this.isDisposed) {
                    try {
                        if (RamdumpDialog.this.frames != null) {
                            2.sleep(50L);
                        } else {
                            2.sleep(500L);
                        }
                    }
                    catch (InterruptedException e) {
                        RamdumpDialog.this.logger.warning("InterruptedException");
                    }
                    if (RamdumpDialog.this.frames != null) {
                        this.currentFrame = (this.currentFrame + 1) % RamdumpDialog.this.frames.length;
                    }
                    if (display.isDisposed()) {
                        return;
                    }
                    if (RamdumpDialog.this.frames != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Image newImage = new Image((Device)display, RamdumpDialog.this.frames[currentFrame]);
                                    labelImage.getImage().dispose();
                                    labelImage.setImage(newImage);
                                }
                                catch (SWTException e) {
                                    isDisposed = true;
                                }
                            }
                        });
                    }
                    if (RamdumpDialog.this.communicator.getRamdumpFlag()) continue;
                    this.isDisposed = true;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RamdumpDialog.this.logger.info("ramdump complete");
                        if (RamdumpDialog.this.shell.isDisposed()) {
                            return;
                        }
                        if (labelImage.getImage() != null) {
                            labelImage.getImage().dispose();
                        }
                        RamdumpDialog.this.shell.setCursor(null);
                        RamdumpDialog.this.shell.close();
                    }
                });
            }
        };
        this.shell.setCursor(display.getSystemCursor(1));
        animation.start();
        return this.compositeBase;
    }

    @Override
    protected void setShellSize() {
        this.shell.setSize(280, 140);
        Rectangle boundsClient = this.shell.getClientArea();
        Rectangle boundsBase = this.compositeBase.getBounds();
        this.compositeBase.setBounds(boundsClient.x + boundsClient.width / 2 - boundsBase.width / 2, boundsClient.y + boundsClient.height / 2 - boundsBase.height / 2, boundsBase.width, boundsBase.height);
    }
}

