/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.image;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;

public class GeneralSkinImageRegistry {
    private static final String PATCH_IMAGES_PATH = "emul-window";
    private static Logger logger = SkinLogger.getSkinLogger(GeneralSkinImageRegistry.class).getLogger();
    private Display display;
    private Map<String, Image> skinImageMap;

    public GeneralSkinImageRegistry(Display display) {
        this.display = display;
        this.skinImageMap = new HashMap<String, Image>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getSkinImage(GeneralSkinImageName name) {
        if (this.skinImageMap.size() == 0) {
            GeneralSkinImageName[] values;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream is = null;
            for (GeneralSkinImageName value : values = GeneralSkinImageName.values()) {
                String imageName = value.getName();
                String imagePath = "images/emul-window/" + imageName;
                try {
                    is = classLoader.getResourceAsStream(imagePath);
                    if (null != is) {
                        logger.fine("KeyWindow image is loaded : " + imagePath);
                        this.skinImageMap.put(imageName, new Image((Device)this.display, is));
                        continue;
                    }
                    logger.severe("missing image : " + imagePath);
                }
                finally {
                    IOUtil.close(is);
                }
            }
        }
        return this.skinImageMap.get(name.getName());
    }

    public void dispose() {
        logger.info("dispose");
        if (null != this.skinImageMap) {
            Image image2 = null;
            Collection<Image> images = this.skinImageMap.values();
            for (Image image2 : images) {
                if (image2 == null) continue;
                image2.dispose();
            }
        }
    }

    public static enum GeneralSkinImageName {
        SKIN_PATCH_LT("LT.png"),
        SKIN_PATCH_T("T.png"),
        SKIN_PATCH_RT("RT.png"),
        SKIN_PATCH_L("L.png"),
        SKIN_PATCH_R("R.png"),
        SKIN_PATCH_LB("LB.png"),
        SKIN_PATCH_B("B.png"),
        SKIN_PATCH_RB("RB.png"),
        TOGGLE_BUTTON_NORMAL("arrow_nml.png"),
        TOGGLE_BUTTON_HOVER("arrow_hover.png"),
        TOGGLE_BUTTON_PUSHED("arrow_pushed.png");

        private String name;

        private GeneralSkinImageName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

