/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout;

import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.RotaryEventData;
import org.tizen.emulator.skin.image.ProfileSkinImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SkinUtil;

public class Rotary
extends Canvas {
    private Logger logger = SkinLogger.getSkinLogger(Rotary.class).getLogger();
    private Shell parent;
    private ProfileSkinImageRegistry imageRegistry;
    private SocketCommunicator communicator;
    private Image image;
    private int degrees;
    private int angleDelta;
    private Point grabPosition;

    Rotary(Shell parent, int style, ProfileSkinImageRegistry imageRegistry, SocketCommunicator communicator) {
        super((Composite)parent, style);
        this.parent = parent;
        this.imageRegistry = imageRegistry;
        this.communicator = communicator;
        this.image = null;
        this.degrees = 0;
        this.angleDelta = 0;
        this.grabPosition = new Point(-1, -1);
        this.addListeners();
        this.setBackground(parent.getDisplay().getSystemColor(15));
    }

    public Image getImage() {
        return this.image;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public void arrange(int scale, short rotationId) {
        Image imageRotary;
        this.logger.info("scale : " + scale + ", rotate : " + rotationId);
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if ((imageRotary = this.imageRegistry.getSkinImage(rotationId, ProfileSkinImageRegistry.SkinImageType.DISPLAY_ROTARY_IMAGE)) != null) {
            this.image = SkinUtil.createScaledImage(this.parent.getDisplay(), imageRotary, rotationId, scale);
        }
        this.redraw();
    }

    private void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (Rotary.this.image != null) {
                    int imageHalfW = Rotary.this.getImage().getImageData().width / 2;
                    int imageHalfH = Rotary.this.getImage().getImageData().height / 2;
                    Transform transform = new Transform((Device)Rotary.this.parent.getDisplay());
                    transform.translate((float)imageHalfW, (float)imageHalfH);
                    transform.rotate((float)Rotary.this.degrees);
                    e.gc.setTransform(transform);
                    e.gc.drawImage(Rotary.this.getImage(), -imageHalfW, -imageHalfH);
                    transform.dispose();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (((Rotary)Rotary.this).grabPosition.x >= 0 && ((Rotary)Rotary.this).grabPosition.y >= 0 && e.button == 0) {
                    int angle = SkinUtil.getAngleFromVector((Control)Rotary.this, e.x, e.y);
                    int delta = angle - Rotary.this.angleDelta;
                    Rotary.this.degrees = Rotary.this.degrees + delta;
                    if (delta != 0) {
                        if (delta < -180) {
                            delta += 360;
                        } else if (delta > 180) {
                            delta -= 360;
                        }
                        Rotary.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_ROTARY_EVENT, new RotaryEventData(0, delta), false);
                        Rotary.this.redraw();
                    }
                    Rotary.this.angleDelta = angle;
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    ((Rotary)Rotary.this).grabPosition.x = e.x;
                    ((Rotary)Rotary.this).grabPosition.y = e.y;
                    Rotary.this.angleDelta = SkinUtil.getAngleFromVector((Control)Rotary.this, e.x, e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    ((Rotary)Rotary.this).grabPosition.x = -1;
                    ((Rotary)Rotary.this).grabPosition.y = -1;
                    Rotary.this.angleDelta = 0;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }
}

