/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout.rotation;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tizen.emulator.skin.dbi.RotationNameType;
import org.tizen.emulator.skin.dbi.RotationType;
import org.tizen.emulator.skin.layout.rotation.Rotation;

public class SkinRotations {
    public static final short PORTRAIT_ID = 0;
    public static final short LANDSCAPE_ID = 1;
    public static final short REVERSE_PORTRAIT_ID = 2;
    public static final short REVERSE_LANDSCAPE_ID = 3;
    private static Map<Short, Rotation> rotationMap = new LinkedHashMap<Short, Rotation>();

    private SkinRotations() {
    }

    public static void put(RotationType rotationType) {
        Rotation rotation = new Rotation();
        rotation.setName(rotationType.getName());
        rotation.setDisplay(rotationType.getDisplay());
        rotation.setImageList(rotationType.getImageList());
        rotation.setKeyMapList(rotationType.getKeyMapList());
        if (RotationNameType.PORTRAIT.value().equalsIgnoreCase(rotationType.getName().value())) {
            rotation.setAngle(0);
            rotationMap.put((short)0, rotation);
        } else if (RotationNameType.LANDSCAPE.value().equalsIgnoreCase(rotationType.getName().value())) {
            rotation.setAngle(-90);
            rotationMap.put((short)1, rotation);
        } else if (RotationNameType.REVERSE_PORTRAIT.value().equalsIgnoreCase(rotationType.getName().value())) {
            rotation.setAngle(180);
            rotationMap.put((short)2, rotation);
        } else if (RotationNameType.REVERSE_LANDSCAPE.value().equalsIgnoreCase(rotationType.getName().value())) {
            rotation.setAngle(90);
            rotationMap.put((short)3, rotation);
        }
    }

    public static Rotation getRotation(Short rotationId) {
        return rotationMap.get(rotationId);
    }

    public static int getAngle(Short rotationId) {
        Rotation rotation = rotationMap.get(rotationId);
        if (rotation == null) {
            return 0;
        }
        return rotation.getAngle();
    }

    public static Iterator<Map.Entry<Short, Rotation>> getRotationIterator() {
        return rotationMap.entrySet().iterator();
    }
}

