/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.menu;

import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.data.KeyEventData;
import org.tizen.emulator.skin.custom.ColorTag;
import org.tizen.emulator.skin.custom.CustomButton;
import org.tizen.emulator.skin.custom.CustomScrolledComposite;
import org.tizen.emulator.skin.custom.SkinWindow;
import org.tizen.emulator.skin.dbi.KeyMapType;
import org.tizen.emulator.skin.image.GeneralKeyWindowImageRegistry;
import org.tizen.emulator.skin.layout.SkinPatches;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class GeneralKeyWindow
extends SkinWindow {
    private static final int SHELL_MARGIN_BOTTOM = 3;
    private static final int PAIRTAG_CIRCLE_SIZE = 8;
    private static final int PAIRTAG_MARGIN_BOTTOM = 6;
    private static final int BUTTON_DEFAULT_CNT = 4;
    private static final int BUTTON_VERTICAL_SPACING = 7;
    private static final int SCROLLBAR_HORIZONTAL_SPACING = 4;
    private static final int SCROLLBAR_SIZE_WIDTH = 14;
    private EmulatorSkin skin;
    private SkinPatches frameMaker;
    private int widthBase;
    private int heightBase;
    private int widthScrollbar;
    private int cntHiddenButton;
    private Image imageNormal;
    private Image imageHover;
    private Image imagePushed;
    private Image imageFrame;
    private Color colorFrame;
    private GeneralKeyWindowImageRegistry imageRegistry;
    private List<KeyMapType> keyMapList;
    private ShellListener shellListener;
    private PaintListener shellPaintListener;
    private MouseMoveListener shellMouseMoveListener;
    private MouseListener shellMouseListener;
    private boolean isGrabbedShell;
    private Point grabPosition;

    public GeneralKeyWindow(EmulatorSkin skin, GeneralKeyWindowImageRegistry imageRegstry, List<KeyMapType> keyMapList) {
        super(skin.getShell(), 0x1020000);
        this.skin = skin;
        this.parent = skin.getShell();
        this.shell = new Shell(this.parent.getDisplay(), 524316);
        this.imageRegistry = imageRegstry;
        this.frameMaker = new SkinPatches(this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_LT), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_T), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_RT), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_L), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_R), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_LB), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_B), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYWINDOW_PATCH_RB));
        this.keyMapList = keyMapList;
        this.grabPosition = new Point(0, 0);
        this.shell.setText(this.parent.getText());
        this.shell.setImage(this.parent.getImage());
        this.imageNormal = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYBUTTON_NORMAL);
        this.imageHover = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYBUTTON_HOVER);
        this.imagePushed = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.KEYBUTTON_PUSHED);
        int cntButton = 4;
        if (keyMapList != null) {
            cntButton = Math.min(keyMapList.size(), cntButton);
        }
        this.widthBase = this.imageNormal.getImageData().width;
        this.heightBase = this.imageNormal.getImageData().height * cntButton + 7 * (cntButton - 1);
        this.widthScrollbar = 18;
        int heightHeaderPart = 14;
        int heightTailPart = 3;
        if (keyMapList != null) {
            this.cntHiddenButton = keyMapList.size() - cntButton;
        }
        this.imageFrame = this.frameMaker.getPatchedImage(this.widthBase + (this.cntHiddenButton > 0 ? this.widthScrollbar : 0), this.heightBase + 14 + 3);
        this.colorFrame = new Color((Device)this.shell.getDisplay(), new RGB(38, 38, 38));
        this.shell.setBackground(this.colorFrame);
        this.createContents();
        this.trimWindow();
        this.addKeyWindowListener();
        this.shell.setSize(this.imageFrame.getImageData().width, this.imageFrame.getImageData().height);
    }

    protected void createContents() {
        GridLayout shellGridLayout = new GridLayout(1, false);
        shellGridLayout.marginLeft = shellGridLayout.marginRight = this.frameMaker.getPatchWidth();
        shellGridLayout.marginTop = this.frameMaker.getPatchHeight();
        shellGridLayout.marginBottom = this.frameMaker.getPatchHeight() + 3;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginWidth = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        this.shell.setLayout((Layout)shellGridLayout);
        ColorTag pairTagCanvas = new ColorTag(this.shell, 0, this.skin.getColorVM());
        pairTagCanvas.setLayoutData(new GridData(8, 14));
        if (this.cntHiddenButton > 0) {
            Image[] imagesScrollArrowUp = new Image[3];
            Image[] imagesScrollArrowDown = new Image[3];
            imagesScrollArrowUp[0] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_UPBUTTON_NORMAL);
            imagesScrollArrowUp[1] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_UPBUTTON_HOVER);
            imagesScrollArrowUp[2] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_UPBUTTON_PUSHED);
            imagesScrollArrowDown[0] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_DOWNBUTTON_NORMAL);
            imagesScrollArrowDown[1] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_DOWNBUTTON_HOVER);
            imagesScrollArrowDown[2] = this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_DOWNBUTTON_PUSHED);
            CustomScrolledComposite compositeScroll = new CustomScrolledComposite((Composite)this.shell, 0, imagesScrollArrowUp, imagesScrollArrowDown, this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_THUMB), this.imageRegistry.getKeyWindowImage(GeneralKeyWindowImageRegistry.GeneralKeyWindowImageName.SCROLL_SHAFT));
            compositeScroll.setLayoutData(new GridData(16384, 128, true, true, 1, 1));
            Composite compositeBase = new Composite((Composite)compositeScroll, 0);
            this.createHwKeys(compositeBase);
            Point sizeContent = compositeBase.computeSize(this.widthBase + this.widthScrollbar, this.heightBase);
            compositeScroll.setContent((Control)compositeBase, sizeContent);
            compositeScroll.setExpandHorizontal(true);
            compositeScroll.setExpandVertical(true);
            sizeContent.y += this.imageNormal.getImageData().height * this.cntHiddenButton + 7 * this.cntHiddenButton;
            compositeScroll.setMinSize(sizeContent);
        } else {
            ScrolledComposite compositeScroll = new ScrolledComposite((Composite)this.shell, 512);
            compositeScroll.setLayoutData((Object)new GridData(16384, 128, true, true, 1, 1));
            Composite compositeBase = new Composite((Composite)compositeScroll, 0);
            this.createHwKeys(compositeBase);
            compositeScroll.setContent((Control)compositeBase);
            compositeScroll.setExpandHorizontal(true);
            compositeScroll.setExpandVertical(true);
            compositeScroll.setMinSize(compositeBase.computeSize(-1, -1));
        }
    }

    protected void createHwKeys(Composite composite) {
        composite.setBackground(this.colorFrame);
        GridLayout compositeGridLayout = new GridLayout(1, false);
        compositeGridLayout.marginRight = 0;
        compositeGridLayout.marginLeft = 0;
        compositeGridLayout.marginBottom = 0;
        compositeGridLayout.marginTop = 0;
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        compositeGridLayout.horizontalSpacing = 0;
        compositeGridLayout.verticalSpacing = 7;
        composite.setLayout((Layout)compositeGridLayout);
        if (this.keyMapList != null && !this.keyMapList.isEmpty()) {
            for (KeyMapType keyEntry : this.keyMapList) {
                final CustomButton HWKeyButton = new CustomButton(composite, 524288, this.imageNormal, this.imageHover, this.imagePushed);
                HWKeyButton.setText(keyEntry.getEventInfo().getKeyName());
                HWKeyButton.setToolTipText(keyEntry.getTooltip());
                HWKeyButton.setBackground(this.colorFrame);
                HWKeyButton.setLayoutData(new GridData(this.imageNormal.getImageData().width, this.imageNormal.getImageData().height));
                final int keycode = keyEntry.getEventInfo().getKeyCode();
                HWKeyButton.addMouseListener(new MouseListener(){

                    public void mouseDown(MouseEvent e) {
                        GeneralKeyWindow.this.logger.info(HWKeyButton.getText() + " key is pressed");
                        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.PRESSED.value(), keycode, 0, 0);
                        ((GeneralKeyWindow)GeneralKeyWindow.this).skin.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                    }

                    public void mouseUp(MouseEvent e) {
                        GeneralKeyWindow.this.logger.info(HWKeyButton.getText() + " key is released");
                        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), keycode, 0, 0);
                        ((GeneralKeyWindow)GeneralKeyWindow.this).skin.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                    }
                });
            }
        }
    }

    private static Region getTrimmedRegion(Image image) {
        if (null == image) {
            return null;
        }
        ImageData imageData = image.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        Region region = new Region();
        region.add(new Rectangle(0, 0, width, height));
        Display display = Display.getDefault();
        int r = display.getSystemColor(11).getRed();
        int g = display.getSystemColor(11).getGreen();
        int b = display.getSystemColor(11).getBlue();
        int colorKey = 0;
        colorKey = SwtUtil.isWindowsPlatform() ? r << 24 | g << 16 | b << 8 : r << 16 | g << 8 | b;
        int j = 0;
        for (int i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int colorPixel = imageData.getPixel(i, j);
                if (colorPixel != colorKey) continue;
                region.subtract(i, j, 1, 1);
            }
        }
        return region;
    }

    protected void trimWindow() {
        Region region;
        Region region2 = region = !SwtUtil.isLinuxPlatform() ? GeneralKeyWindow.getTrimmedRegion(this.imageFrame) : SkinUtil.getTrimmedRegion(this.imageFrame);
        if (region != null) {
            this.shell.setRegion(region);
        }
    }

    private void addKeyWindowListener() {
        this.shellPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (GeneralKeyWindow.this.imageFrame != null) {
                    e.gc.drawImage(GeneralKeyWindow.this.imageFrame, 0, 0);
                }
            }
        };
        this.shell.addPaintListener(this.shellPaintListener);
        this.shellListener = new ShellListener(){

            public void shellClosed(ShellEvent event) {
                GeneralKeyWindow.this.logger.info("General Key Window is closed");
                GeneralKeyWindow.this.dispose();
            }

            public void shellActivated(ShellEvent event) {
                GeneralKeyWindow.this.logger.info("activate");
                if (SwtUtil.isMacPlatform()) {
                    if (!GeneralKeyWindow.this.parent.isDisposed()) {
                        GeneralKeyWindow.this.parent.moveAbove((Control)GeneralKeyWindow.this.shell);
                    }
                } else {
                    GeneralKeyWindow.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GeneralKeyWindow.this.parent.setActive();
                        }
                    });
                }
            }

            public void shellDeactivated(ShellEvent event) {
                GeneralKeyWindow.this.logger.info("deactivate");
            }

            public void shellIconified(ShellEvent event) {
            }

            public void shellDeiconified(ShellEvent event) {
                GeneralKeyWindow.this.logger.info("deiconified");
                GeneralKeyWindow.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GeneralKeyWindow.this.parent.getMinimized()) {
                            GeneralKeyWindow.this.parent.setMinimized(false);
                        }
                    }
                });
            }
        };
        this.shell.addShellListener(this.shellListener);
        this.shellMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (GeneralKeyWindow.this.isGrabbedShell && e.button == 0) {
                    if (GeneralKeyWindow.this.getDockPosition() != 0) {
                        GeneralKeyWindow.this.dock(0, false, false);
                        GeneralKeyWindow.this.shell.moveAbove((Control)GeneralKeyWindow.this.parent);
                    }
                    Point previousLocation = GeneralKeyWindow.this.shell.getLocation();
                    int x = previousLocation.x + (e.x - ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.x);
                    int y = previousLocation.y + (e.y - ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.y);
                    GeneralKeyWindow.this.shell.setLocation(x, y);
                    return;
                }
            }
        };
        this.shell.addMouseMoveListener(this.shellMouseMoveListener);
        this.shellMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    GeneralKeyWindow.this.isGrabbedShell = false;
                    ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.y = 0;
                    ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.x = 0;
                    Rectangle parentBounds = GeneralKeyWindow.this.parent.getBounds();
                    Rectangle childBounds = GeneralKeyWindow.this.shell.getBounds();
                    int heightOneThird = parentBounds.height / 3;
                    int widthDockingArea = 30;
                    int widthIntersectRegion = 5;
                    Rectangle attachBoundsRC = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y + heightOneThird, widthDockingArea, heightOneThird);
                    Rectangle attachBoundsRT = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y, widthDockingArea, heightOneThird);
                    Rectangle attachBoundsRB = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y + heightOneThird * 2, widthDockingArea, heightOneThird);
                    Rectangle attachBoundsLC = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y + heightOneThird, widthDockingArea, heightOneThird);
                    Rectangle attachBoundsLT = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y, widthDockingArea, heightOneThird);
                    Rectangle attachBoundsLB = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y + heightOneThird * 2, widthDockingArea, heightOneThird);
                    if (childBounds.intersects(attachBoundsRC)) {
                        GeneralKeyWindow.this.dock(0x1020000, false, true);
                    } else if (childBounds.intersects(attachBoundsRT)) {
                        GeneralKeyWindow.this.dock(131200, false, true);
                    } else if (childBounds.intersects(attachBoundsRB)) {
                        GeneralKeyWindow.this.dock(132096, false, true);
                    } else if (childBounds.intersects(attachBoundsLC)) {
                        GeneralKeyWindow.this.dock(0x1004000, false, true);
                    } else if (childBounds.intersects(attachBoundsLT)) {
                        GeneralKeyWindow.this.dock(16512, false, true);
                    } else if (childBounds.intersects(attachBoundsLB)) {
                        GeneralKeyWindow.this.dock(17408, false, true);
                    } else {
                        GeneralKeyWindow.this.dock(0, false, true);
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    GeneralKeyWindow.this.isGrabbedShell = true;
                    ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.x = e.x;
                    ((GeneralKeyWindow)GeneralKeyWindow.this).grabPosition.y = e.y;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.shell.addMouseListener(this.shellMouseListener);
        if (!SwtUtil.isWindowsPlatform()) {
            this.shell.getDisplay().addListener(39, new Listener(){

                public void handleEvent(Event e) {
                    GeneralKeyWindow.this.trimWindow();
                }
            });
        }
    }

    private void dispose() {
        if (null != this.shellPaintListener) {
            this.shell.removePaintListener(this.shellPaintListener);
        }
        if (null != this.shellListener) {
            this.shell.removeShellListener(this.shellListener);
        }
        if (null != this.shellMouseMoveListener) {
            this.shell.removeMouseMoveListener(this.shellMouseMoveListener);
        }
        if (null != this.shellMouseListener) {
            this.shell.removeMouseListener(this.shellMouseListener);
        }
        this.colorFrame.dispose();
    }
}

