/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.menu;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.custom.SkinWindow;
import org.tizen.emulator.skin.dbi.KeyMapType;
import org.tizen.emulator.skin.image.GeneralKeyWindowImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.menu.GeneralKeyWindow;
import org.tizen.emulator.skin.menu.SpecialKeyWindow;
import org.tizen.emulator.skin.util.SkinUtil;

public class KeyWindowKeeper {
    public static final int DEFAULT_DOCK_POSITION = 0x1020000;
    private static Logger logger = SkinLogger.getSkinLogger(KeyWindowKeeper.class).getLogger();
    private EmulatorSkin skin;
    private SkinWindow keyWindow;
    private int recentlyDocked;
    private int indexLayout;
    private GeneralKeyWindowImageRegistry imageRegstry;

    public KeyWindowKeeper(EmulatorSkin skin) {
        this.skin = skin;
        this.recentlyDocked = 0;
        this.indexLayout = -1;
        this.imageRegstry = null;
    }

    public void openKeyWindow(int dockValue, boolean recreate) {
        if (this.getKeyWindow() != null) {
            if (!recreate) {
                this.skin.isKeyWindow = true;
                this.selectKeyWindowMenu(true);
                this.keyWindow.getShell().setVisible(true);
                SkinUtil.setTopMost(this.keyWindow.getShell(), this.skin.isOnTop);
                this.skin.updateSkin();
                return;
            }
            logger.info("recreate a keywindow");
            this.closeKeyWindow();
        }
        this.determineLayout();
        if (this.isGeneralKeyWindow()) {
            if (this.imageRegstry == null) {
                logger.warning("GeneralKeyWindowImageRegistry is null");
                return;
            }
            List<KeyMapType> keyMapList = SkinUtil.getHWKeyMapList(this.skin.getEmulatorSkinState().getCurrentRotationId());
            if (keyMapList == null) {
                logger.info("keyMapList is null");
                this.skin.isKeyWindow = false;
                this.selectKeyWindowMenu(false);
                return;
            }
            if (keyMapList.isEmpty()) {
                logger.info("keyMapList is empty");
                this.skin.isKeyWindow = false;
                this.selectKeyWindowMenu(false);
                return;
            }
            this.keyWindow = new GeneralKeyWindow(this.skin, this.imageRegstry, keyMapList);
        } else {
            Menu keywindowMenu = this.skin.getPopupMenu().keyWindowItem.getMenu();
            MenuItem layout = keywindowMenu.getItem(this.indexLayout);
            if (layout == null) {
                layout = keywindowMenu.getItem(0);
                if (layout == null) {
                    return;
                }
                layout.setSelection(true);
            }
            String layoutName = layout.getText();
            logger.info("generate a '" + layoutName + "' key window!");
            this.keyWindow = new SpecialKeyWindow(this.skin, layoutName);
        }
        this.skin.isKeyWindow = true;
        this.selectKeyWindowMenu(true);
        SkinUtil.setTopMost(this.keyWindow.getShell(), this.skin.isOnTop);
        this.keyWindow.open(dockValue);
        this.skin.updateSkin();
    }

    public void closeKeyWindow() {
        this.skin.isKeyWindow = false;
        this.selectKeyWindowMenu(false);
        if (this.getKeyWindow() != null) {
            this.keyWindow.getShell().close();
            this.keyWindow = null;
        }
        this.skin.updateSkin();
    }

    public void hideKeyWindow() {
        this.skin.isKeyWindow = false;
        this.selectKeyWindowMenu(false);
        if (this.getKeyWindow() != null) {
            this.keyWindow.getShell().setVisible(false);
        }
        this.skin.updateSkin();
    }

    public SkinWindow getKeyWindow() {
        if (this.keyWindow != null && this.keyWindow.getShell().isDisposed()) {
            this.keyWindow = null;
        }
        return this.keyWindow;
    }

    public int getLayoutIndex() {
        return this.indexLayout;
    }

    public boolean isGeneralKeyWindow() {
        return this.getLayoutIndex() < 0;
    }

    public int determineLayout() {
        MenuItem keywindowItem = this.skin.getPopupMenu().keyWindowItem;
        if (keywindowItem != null && keywindowItem.getMenu() != null) {
            logger.info("key window has a special layout");
            this.indexLayout = 0;
            MenuItem[] layouts = keywindowItem.getMenu().getItems();
            for (int i = 0; i < layouts.length; ++i) {
                MenuItem layout = layouts[i];
                if (!layout.getSelection()) continue;
                this.indexLayout = i;
                logger.info("the '" + layout.getText() + "' layout is selected for key window");
                break;
            }
        } else {
            logger.info("key window has a general layout");
            this.indexLayout = -1;
            if (this.imageRegstry == null) {
                this.imageRegstry = new GeneralKeyWindowImageRegistry(this.skin.getShell().getDisplay());
            }
        }
        return this.indexLayout;
    }

    public boolean isSelectKeyWindowMenu() {
        MenuItem keywindowMenu = this.skin.getPopupMenu().keyWindowItem;
        if (keywindowMenu != null) {
            if (this.isGeneralKeyWindow()) {
                return keywindowMenu.getSelection();
            }
            for (MenuItem layout : keywindowMenu.getMenu().getItems()) {
                if (!layout.getSelection()) continue;
                return true;
            }
        }
        return false;
    }

    public void selectKeyWindowMenu(boolean on) {
        MenuItem keywindowMenu = this.skin.getPopupMenu().keyWindowItem;
        if (keywindowMenu != null) {
            if (this.isGeneralKeyWindow()) {
                keywindowMenu.setSelection(on);
            } else {
                MenuItem layout = keywindowMenu.getMenu().getItem(this.indexLayout);
                if (layout != null) {
                    layout.setSelection(on);
                }
            }
        }
    }

    public void redock(boolean correction, boolean enableLogger) {
        if (this.keyWindow != null) {
            this.keyWindow.redock(correction, enableLogger);
        }
    }

    public int getDockPosition() {
        if (this.keyWindow == null) {
            return 0;
        }
        return this.keyWindow.getDockPosition();
    }

    public int getRecentlyDocked() {
        return this.recentlyDocked;
    }

    public void setRecentlyDocked(int dockValue) {
        this.recentlyDocked = dockValue;
    }

    public void dispose() {
        this.closeKeyWindow();
        if (this.imageRegstry != null) {
            this.imageRegstry.dispose();
        }
    }
}

