/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.dbi.EventInfoType;
import org.tizen.emulator.skin.dbi.KeyMapType;
import org.tizen.emulator.skin.dbi.RegionType;
import org.tizen.emulator.skin.layout.HWKey;
import org.tizen.emulator.skin.layout.HWKeyRegion;
import org.tizen.emulator.skin.layout.rotation.Rotation;
import org.tizen.emulator.skin.layout.rotation.SkinRotations;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class SkinUtil {
    public static final String GTK_OS_CLASS = "org.eclipse.swt.internal.gtk.OS";
    public static final String WIN32_OS_CLASS = "org.eclipse.swt.internal.win32.OS";
    public static final String COCOA_OS_CLASS = "org.eclipse.swt.internal.cocoa.OS";
    public static final int UNKNOWN_KEYCODE = -1;
    public static final int SCALE_CONVERTER = 100;
    public static final String EMULATOR_PREFIX = "Emulator";
    private static Logger logger = SkinLogger.getSkinLogger(SkinUtil.class).getLogger();
    private static String binaryPath;

    private SkinUtil() {
    }

    public static String getVmName(EmulatorConfig config) {
        String vmPath = config.getArg("vm.path");
        String regex = "";
        regex = SwtUtil.isWindowsPlatform() ? "\\" + File.separator : File.separator;
        String[] split = StringUtil.nvl(vmPath).split(regex);
        String vmName = split[split.length - 1];
        return vmName;
    }

    public static String makeEmulatorName(EmulatorConfig config) {
        String vmName = SkinUtil.getVmName(config);
        if (StringUtil.isEmpty(vmName)) {
            vmName = EMULATOR_PREFIX;
        }
        int portNumber = config.getArgInt("vm.baseport") + 1;
        return vmName + ":" + portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String filePath, boolean create) {
        FileInputStream fis = null;
        Properties properties = null;
        try {
            File file = new File(filePath);
            if (create) {
                if (!file.exists() && !file.createNewFile()) {
                    logger.severe("Fail to create new " + filePath + " property file.");
                    Properties properties2 = null;
                    IOUtil.close(fis);
                    return properties2;
                }
                fis = new FileInputStream(filePath);
                properties = new Properties();
                properties.load(fis);
            } else if (file.exists()) {
                fis = new FileInputStream(filePath);
                properties = new Properties();
                properties.load(fis);
            }
            logger.info("load properties file : " + filePath);
            IOUtil.close(fis);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "failed to load skin properties file", e);
        }
        finally {
            IOUtil.close(fis);
        }
        return properties;
    }

    public static String getSdbPath() {
        StringBuilder sdbPath = new StringBuilder(".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "tools" + File.separator);
        if (SwtUtil.isWindowsPlatform()) {
            sdbPath.append("ansicon.exe");
        } else {
            sdbPath.append("sdb");
        }
        return binaryPath + sdbPath.toString();
    }

    public static String getEcpPath() {
        return binaryPath + "emulator-control-panel.jar";
    }

    public static String getSdkVersionFilePath() {
        return binaryPath + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + ".." + File.separator + "sdk.version";
    }

    public static List<KeyMapType> getHWKeyMapList(short rotationId) {
        Rotation rotation = SkinRotations.getRotation(rotationId);
        if (rotation == null) {
            return null;
        }
        return rotation.getListHWKey();
    }

    public static HWKey getHWKey(int currentX, int currentY, int scale, short rotationId) {
        float convertedScale = SkinUtil.convertScale(scale);
        List<KeyMapType> keyMapList = SkinUtil.getHWKeyMapList(rotationId);
        if (keyMapList == null) {
            return null;
        }
        RegionType region = null;
        for (KeyMapType keyEntry : keyMapList) {
            int scaledHeight;
            int scaledWidth;
            int scaledY;
            region = keyEntry.getRegion();
            int scaledX = (int)((float)region.getLeft().intValue() * convertedScale);
            if (!SkinUtil.isInGeometry(currentX, currentY, scaledX, scaledY = (int)((float)region.getTop().intValue() * convertedScale), scaledWidth = (int)((float)region.getWidth().intValue() * convertedScale), scaledHeight = (int)((float)region.getHeight().intValue() * convertedScale))) continue;
            EventInfoType eventInfo = keyEntry.getEventInfo();
            HWKey hwKey = new HWKey(eventInfo.getKeyName(), eventInfo.getKeyCode(), new HWKeyRegion(scaledX, scaledY, scaledWidth, scaledHeight, keyEntry.getRegion().isUpdate()), keyEntry.getTooltip());
            return hwKey;
        }
        return null;
    }

    public static boolean isInGeometry(int currentX, int currentY, int targetX, int targetY, int targetWidth, int targetHeight) {
        return currentX >= targetX && currentY >= targetY && currentX <= targetX + targetWidth && currentY <= targetY + targetHeight;
    }

    public static void setColorKeyFromMask(Display display, int colorKey, int fakeKey, ImageData srcData, ImageData dstData) {
        if (srcData == null || dstData == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < dstData.width; ++i) {
            for (j = 0; j < dstData.height; ++j) {
                if (srcData.getAlpha(i, j) == 0) {
                    dstData.setPixel(i, j, colorKey);
                    continue;
                }
                if (srcData.getPixel(i, j) != colorKey) continue;
                dstData.setPixel(i, j, fakeKey);
            }
        }
    }

    public static ImageData getMaskDataForImage(Display display, Image srcImage) {
        if (srcImage == null || srcImage.isDisposed()) {
            return null;
        }
        ImageData srcImageData = srcImage.getImageData();
        int[] maskArray = new int[srcImageData.width * srcImageData.height];
        int j = 0;
        for (int i = 0; i < srcImageData.width; ++i) {
            for (j = 0; j < srcImageData.height; ++j) {
                maskArray[i * srcImageData.width + j] = srcImageData.getAlpha(i, j) != 0 ? 1 : 0;
            }
        }
        ImageData maskData = new ImageData(srcImageData.width, srcImageData.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        maskData.setPixels(0, 0, srcImageData.width * srcImageData.height, maskArray, 0);
        return maskData;
    }

    public static Region getTrimmedRegion(Image image) {
        if (null == image) {
            return null;
        }
        ImageData imageData = image.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        Region region = new Region();
        region.add(new Rectangle(0, 0, width, height));
        int j = 0;
        for (int i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                if (0 != imageData.getAlpha(i, j)) continue;
                region.subtract(i, j, 1, 1);
            }
        }
        return region;
    }

    public static void trimShell(Shell shell, Image image, int left, int top, int width, int height) {
        if (image == null || width == 0 && height == 0) {
            return;
        }
        ImageData imageData = image.getImageData();
        int right = left + width;
        int bottom = top + height;
        Region region = shell.getRegion();
        if (region == null) {
            return;
        }
        int j = 0;
        for (int i = left; i < right; ++i) {
            for (j = top; j < bottom; ++j) {
                if (0 == imageData.getAlpha(i, j)) {
                    region.subtract(i, j, 1, 1);
                    continue;
                }
                region.add(i, j, 1, 1);
            }
        }
        shell.setRegion(region);
    }

    public static int[] convertMouseGeometry(int originalX, int originalY, int displayWidth, int displayHeight, int scale, short rotationId) {
        float convertedScale = SkinUtil.convertScale(scale);
        int x = (int)((float)originalX * (1.0f / convertedScale));
        int y = (int)((float)originalY * (1.0f / convertedScale));
        int rotatedX = x;
        int rotatedY = y;
        if (rotationId == 1) {
            rotatedX = displayWidth - y;
            rotatedY = x;
        } else if (rotationId == 2) {
            rotatedX = displayWidth - x;
            rotatedY = displayHeight - y;
        } else if (rotationId == 3) {
            rotatedX = y;
            rotatedY = displayHeight - x;
        }
        return new int[]{rotatedX, rotatedY};
    }

    public static Image createScaledImage(Display display, Image imageOrigin, short rotationId, int scale) {
        if (imageOrigin == null) {
            return null;
        }
        ImageData imageDataSrc = imageOrigin.getImageData();
        ImageData imageDataDst = (ImageData)imageDataSrc.clone();
        float convertedScale = SkinUtil.convertScale(scale);
        int width = (int)((float)imageDataSrc.width * convertedScale);
        int height = (int)((float)imageDataSrc.height * convertedScale);
        imageDataDst = imageDataDst.scaledTo(width, height);
        return new Image((Device)display, imageDataDst);
    }

    public static float convertScale(int scale) {
        return (float)scale / 100.0f;
    }

    public static <T> int openMessage(Shell shell, String title, String message, int style, EmulatorConfig config) {
        MessageBox messageBox = new MessageBox(shell, style);
        if (!StringUtil.isEmpty(title)) {
            messageBox.setText(title);
        } else {
            messageBox.setText(SkinUtil.makeEmulatorName(config));
        }
        messageBox.setMessage(StringUtil.nvl(message));
        return messageBox.open();
    }

    private static Field getOSField(String field) {
        String className = "";
        if (SwtUtil.isLinuxPlatform()) {
            className = GTK_OS_CLASS;
        } else if (SwtUtil.isWindowsPlatform()) {
            className = WIN32_OS_CLASS;
        } else if (SwtUtil.isMacPlatform()) {
            className = COCOA_OS_CLASS;
        }
        Field f = null;
        try {
            f = Class.forName(className).getField(field);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return f;
    }

    private static Method getOSMethod(String method, Class<?> ... parameterTypes) {
        String className = "";
        if (SwtUtil.isLinuxPlatform()) {
            className = GTK_OS_CLASS;
        } else if (SwtUtil.isWindowsPlatform()) {
            className = WIN32_OS_CLASS;
        } else if (SwtUtil.isMacPlatform()) {
            className = COCOA_OS_CLASS;
        }
        Method m = null;
        try {
            m = Class.forName(className).getMethod(method, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return m;
    }

    private static Method getOSMethod(String method) {
        return SkinUtil.getOSMethod(method, new Class[0]);
    }

    private static Object invokeOSMethod(Method method, Object ... args) {
        if (null == method) {
            return null;
        }
        try {
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    private static Object invokeOSMethod(Method method) {
        return SkinUtil.invokeOSMethod(method, new Object[0]);
    }

    private static boolean setTopMost32(Shell shell, boolean isOnTop) {
        if (SwtUtil.isLinuxPlatform()) {
            Boolean gdkWindowingX11 = (Boolean)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GDK_WINDOWING_X11"));
            if (null == gdkWindowingX11) {
                logger.warning("GDK_WINDOWING_X11 returned null. There is no x11 system.");
                return false;
            }
            int eventData0 = isOnTop ? 1 : 0;
            int topHandle = 0;
            Method m = null;
            try {
                m = Shell.class.getDeclaredMethod("topHandle", new Class[0]);
                m.setAccessible(true);
                topHandle = (Integer)m.invoke((Object)shell, new Object[0]);
            }
            catch (SecurityException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (NoSuchMethodException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Integer gtkWidgetWindow = (Integer)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GTK_WIDGET_WINDOW", Integer.TYPE), topHandle);
            if (null == gtkWidgetWindow) {
                logger.warning("GTK_WIDGET_WINDOW returned null");
                return false;
            }
            Integer xWindow = (Integer)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_x11_drawable_get_xid", Integer.TYPE), gtkWidgetWindow);
            if (null == xWindow) {
                logger.warning("gdk_x11_drawable_get_xid returned null");
                return false;
            }
            Integer gdkDisplay = (Integer)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_display_get_default"));
            if (null == gdkDisplay) {
                logger.warning("gdk_display_get_default returned null");
                return false;
            }
            Integer xDisplay = (Integer)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_x11_display_get_xdisplay", Integer.TYPE), gdkDisplay);
            if (null == xDisplay) {
                logger.warning("gdk_x11_display_get_xdisplay returned null");
                xDisplay = (Integer)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GDK_DISPLAY"));
                if (null == xDisplay) {
                    logger.warning("GDK_DISPLAY returned null");
                    return false;
                }
            }
            Method xInternAtom = SkinUtil.getOSMethod("XInternAtom", Integer.TYPE, byte[].class, Boolean.TYPE);
            Class<?> converterClass = null;
            try {
                converterClass = Class.forName("org.eclipse.swt.internal.Converter");
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method wcsToMbcs = null;
            byte[] messageBufferState = null;
            byte[] messageBufferAbove = null;
            try {
                wcsToMbcs = converterClass.getMethod("wcsToMbcs", String.class, String.class, Boolean.TYPE);
            }
            catch (SecurityException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (NoSuchMethodException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            try {
                messageBufferState = (byte[])wcsToMbcs.invoke(null, null, "_NET_WM_STATE", true);
                messageBufferAbove = (byte[])wcsToMbcs.invoke(null, null, "_NET_WM_STATE_ABOVE", true);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Integer xMessageAtomType = (Integer)SkinUtil.invokeOSMethod(xInternAtom, xDisplay, messageBufferState, false);
            if (null == xMessageAtomType) {
                logger.warning("xMessageAtomType is null");
                return false;
            }
            Integer xMessageAtomAbove = (Integer)SkinUtil.invokeOSMethod(xInternAtom, xDisplay, messageBufferAbove, false);
            if (null == xMessageAtomAbove) {
                logger.warning("xMessageAtomAbove is null");
                return false;
            }
            Class<?> eventClazz = null;
            Object event = null;
            try {
                eventClazz = Class.forName("org.eclipse.swt.internal.gtk.XClientMessageEvent");
                event = eventClazz.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (null == eventClazz || null == event) {
                return false;
            }
            Integer malloc = null;
            try {
                Field type = eventClazz.getField("type");
                Field clientMessageField = SkinUtil.getOSField("ClientMessage");
                if (null == clientMessageField) {
                    logger.warning("clientMessageField is null");
                    return false;
                }
                type.set(event, clientMessageField.get(null));
                Field window = eventClazz.getField("window");
                window.set(event, xWindow);
                Field messageType = eventClazz.getField("message_type");
                messageType.set(event, xMessageAtomType);
                Field format = eventClazz.getField("format");
                format.set(event, 32);
                Object data = Array.newInstance(Integer.TYPE, 5);
                Array.setInt(data, 0, eventData0);
                Array.setInt(data, 1, xMessageAtomAbove);
                Array.setInt(data, 2, 0);
                Array.setInt(data, 3, 0);
                Array.setInt(data, 4, 0);
                Field dataField = eventClazz.getField("data");
                dataField.set(event, data);
                Field sizeofField = eventClazz.getField("sizeof");
                Integer sizeof = (Integer)sizeofField.get(null);
                Method gMalloc = SkinUtil.getOSMethod("g_malloc", Integer.TYPE);
                malloc = (Integer)SkinUtil.invokeOSMethod(gMalloc, sizeof);
                Method memmove = SkinUtil.getOSMethod("memmove", Integer.TYPE, eventClazz, Integer.TYPE);
                SkinUtil.invokeOSMethod(memmove, malloc, event, sizeof);
            }
            catch (NoSuchFieldException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method xDefaultRootWindow = SkinUtil.getOSMethod("XDefaultRootWindow", Integer.TYPE);
            Integer rootWin = (Integer)SkinUtil.invokeOSMethod(xDefaultRootWindow, xDisplay);
            Method xSendEvent = SkinUtil.getOSMethod("XSendEvent", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            Method xFlush = SkinUtil.getOSMethod("XFlush", Integer.TYPE);
            SkinUtil.invokeOSMethod(xSendEvent, xDisplay, rootWin, false, 0x180000, malloc);
            SkinUtil.invokeOSMethod(xFlush, xDisplay);
            SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("g_free", Integer.TYPE), malloc);
        } else if (SwtUtil.isWindowsPlatform()) {
            Point location = shell.getLocation();
            int hWndInsertAfter = 0;
            int noSize = 0;
            try {
                if (isOnTop) {
                    Field topMost = SkinUtil.getOSField("HWND_TOPMOST");
                    if (null == topMost) {
                        logger.warning("topMost is null");
                        return false;
                    }
                    hWndInsertAfter = topMost.getInt(null);
                } else {
                    Field noTopMost = SkinUtil.getOSField("HWND_NOTOPMOST");
                    if (null == noTopMost) {
                        logger.warning("HWND_NOTOPMOST is null");
                        return false;
                    }
                    hWndInsertAfter = noTopMost.getInt(null);
                }
                Field noSizeField = SkinUtil.getOSField("SWP_NOSIZE");
                if (null == noSizeField) {
                    logger.warning("SWP_NOSIZE is null");
                    return false;
                }
                noSize = noSizeField.getInt(null);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method m = SkinUtil.getOSMethod("SetWindowPos", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            int shellHandle = 0;
            try {
                Field field = shell.getClass().getField("handle");
                shellHandle = field.getInt(shell);
                logger.info("shell.handle:" + shellHandle);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (SecurityException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            SkinUtil.invokeOSMethod(m, shellHandle, hWndInsertAfter, location.x, location.y, 0, 0, noSize);
        } else if (SwtUtil.isMacPlatform()) {
            logger.warning("not supported yet");
            return false;
        }
        return true;
    }

    private static boolean setTopMost64(Shell shell, boolean isOnTop) {
        if (SwtUtil.isLinuxPlatform()) {
            Boolean gdkWindowingX11 = (Boolean)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GDK_WINDOWING_X11"));
            if (null == gdkWindowingX11) {
                logger.warning("GDK_WINDOWING_X11 returned null. There is no x11 system.");
                return false;
            }
            int eventData0 = isOnTop ? 1 : 0;
            long topHandle = 0L;
            Method m = null;
            try {
                m = Shell.class.getDeclaredMethod("topHandle", new Class[0]);
                m.setAccessible(true);
                topHandle = (Long)m.invoke((Object)shell, new Object[0]);
            }
            catch (SecurityException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (NoSuchMethodException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Long gtkWidgetWindow = (Long)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GTK_WIDGET_WINDOW", Long.TYPE), topHandle);
            if (null == gtkWidgetWindow) {
                logger.warning("GTK_WIDGET_WINDOW returned null");
                return false;
            }
            Long xWindow = (Long)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_x11_drawable_get_xid", Long.TYPE), gtkWidgetWindow);
            if (null == xWindow) {
                logger.warning("gdk_x11_drawable_get_xid returned null");
                return false;
            }
            Long gdkDisplay = (Long)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_display_get_default"));
            if (null == gdkDisplay) {
                logger.warning("gdk_display_get_default returned null");
                return false;
            }
            Long xDisplay = (Long)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("gdk_x11_display_get_xdisplay", Long.TYPE), gdkDisplay);
            if (null == xDisplay) {
                logger.warning("gdk_x11_display_get_xdisplay returned null");
                xDisplay = (Long)SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("GDK_DISPLAY"));
                if (null == xDisplay) {
                    logger.warning("GDK_DISPLAY returned null");
                    return false;
                }
            }
            Method xInternAtom = SkinUtil.getOSMethod("XInternAtom", Long.TYPE, byte[].class, Boolean.TYPE);
            Class<?> converterClass = null;
            try {
                converterClass = Class.forName("org.eclipse.swt.internal.Converter");
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method wcsToMbcs = null;
            byte[] messageBufferState = null;
            byte[] messageBufferAbove = null;
            try {
                wcsToMbcs = converterClass.getMethod("wcsToMbcs", String.class, String.class, Boolean.TYPE);
            }
            catch (SecurityException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (NoSuchMethodException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            try {
                messageBufferState = (byte[])wcsToMbcs.invoke(null, null, "_NET_WM_STATE", true);
                messageBufferAbove = (byte[])wcsToMbcs.invoke(null, null, "_NET_WM_STATE_ABOVE", true);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Long xMessageAtomType = (Long)SkinUtil.invokeOSMethod(xInternAtom, xDisplay, messageBufferState, false);
            if (null == xMessageAtomType) {
                logger.warning("xMessageAtomType is null");
                return false;
            }
            Long xMessageAtomAbove = (Long)SkinUtil.invokeOSMethod(xInternAtom, xDisplay, messageBufferAbove, false);
            if (null == xMessageAtomAbove) {
                logger.warning("xMessageAtomAbove is null");
                return false;
            }
            Class<?> eventClazz = null;
            Object event = null;
            try {
                eventClazz = Class.forName("org.eclipse.swt.internal.gtk.XClientMessageEvent");
                event = eventClazz.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (ClassNotFoundException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (null == eventClazz || null == event) {
                return false;
            }
            Long malloc = null;
            try {
                Field type = eventClazz.getField("type");
                Field clientMessageField = SkinUtil.getOSField("ClientMessage");
                if (null == clientMessageField) {
                    logger.warning("clientMessageField is null");
                    return false;
                }
                type.set(event, clientMessageField.get(null));
                Field window = eventClazz.getField("window");
                window.set(event, xWindow);
                Field messageType = eventClazz.getField("message_type");
                messageType.set(event, xMessageAtomType);
                Field format = eventClazz.getField("format");
                format.set(event, 32);
                Object data = Array.newInstance(Long.TYPE, 5);
                Array.setLong(data, 0, eventData0);
                Array.setLong(data, 1, xMessageAtomAbove);
                Array.setLong(data, 2, 0L);
                Array.setLong(data, 3, 0L);
                Array.setLong(data, 4, 0L);
                Field dataField = eventClazz.getField("data");
                dataField.set(event, data);
                Field sizeofField = eventClazz.getField("sizeof");
                Integer sizeof = (Integer)sizeofField.get(null);
                Method gMalloc = SkinUtil.getOSMethod("g_malloc", Long.TYPE);
                malloc = (Long)SkinUtil.invokeOSMethod(gMalloc, sizeof.longValue());
                Method memmove = SkinUtil.getOSMethod("memmove", Long.TYPE, eventClazz, Long.TYPE);
                SkinUtil.invokeOSMethod(memmove, malloc, event, sizeof.longValue());
            }
            catch (NoSuchFieldException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method xDefaultRootWindow = SkinUtil.getOSMethod("XDefaultRootWindow", Long.TYPE);
            Long rootWin = (Long)SkinUtil.invokeOSMethod(xDefaultRootWindow, xDisplay);
            Method xSendEvent = SkinUtil.getOSMethod("XSendEvent", Long.TYPE, Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE);
            Method xFlush = SkinUtil.getOSMethod("XFlush", Long.TYPE);
            SkinUtil.invokeOSMethod(xSendEvent, xDisplay, rootWin, false, 0x180000L, malloc);
            SkinUtil.invokeOSMethod(xFlush, xDisplay);
            SkinUtil.invokeOSMethod(SkinUtil.getOSMethod("g_free", Long.TYPE), malloc);
        } else if (SwtUtil.isWindowsPlatform()) {
            Point location = shell.getLocation();
            long hWndInsertAfter = 0L;
            int noSize = 0;
            try {
                if (isOnTop) {
                    Field topMost = SkinUtil.getOSField("HWND_TOPMOST");
                    if (null == topMost) {
                        logger.warning("topMost is null");
                        return false;
                    }
                    hWndInsertAfter = topMost.getLong(null);
                } else {
                    Field noTopMost = SkinUtil.getOSField("HWND_NOTOPMOST");
                    if (null == noTopMost) {
                        logger.warning("noTopMost is null");
                        return false;
                    }
                    hWndInsertAfter = noTopMost.getLong(null);
                }
                Field noSizeField = SkinUtil.getOSField("SWP_NOSIZE");
                if (null == noSizeField) {
                    logger.warning("SWP_NOSIZE is null");
                    return false;
                }
                noSize = noSizeField.getInt(null);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
            Method m = SkinUtil.getOSMethod("SetWindowPos", Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            long shellHandle = 0L;
            try {
                Field field = shell.getClass().getField("handle");
                shellHandle = field.getLong(shell);
                logger.info("shell.handle:" + shellHandle);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (SecurityException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
            SkinUtil.invokeOSMethod(m, shellHandle, hWndInsertAfter, location.x, location.y, 0, 0, noSize);
        } else if (SwtUtil.isMacPlatform()) {
            logger.warning("not supported yet");
            return false;
        }
        return true;
    }

    public static boolean setTopMost(Shell shell, boolean isOnTop) {
        if (shell == null) {
            return false;
        }
        logger.info("set Always on Top : " + isOnTop);
        if (SwtUtil.is64bitPlatform()) {
            logger.info("64bit architecture : " + System.getProperty("os.arch"));
            return SkinUtil.setTopMost64(shell, isOnTop);
        }
        logger.info("32bit architecture : " + System.getProperty("os.arch"));
        return SkinUtil.setTopMost32(shell, isOnTop);
    }

    public static int getAngleFromVector(Control con, int x, int y) {
        return (int)Math.toDegrees(Math.atan2(y - con.getSize().y / 2, x - con.getSize().x / 2));
    }

    static {
        File executable = null;
        try {
            executable = new File(SkinUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        binaryPath = executable != null ? executable.getParent() + File.separator : "";
    }
}

