/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Region;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.info.EmulatorSkinState;
import org.tizen.emulator.skin.log.SkinLogger;

public class EmulatorFingers {
    private static final int MAX_FINGER_CNT = 10;
    private static final int FINGER_POINT_SIZE = 32;
    private static final int FINGER_POINT_ALPHA = 126;
    private Logger logger = SkinLogger.getSkinLogger(EmulatorFingers.class).getLogger();
    private EmulatorSkin skin;
    protected SocketCommunicator communicator;
    private EmulatorSkinState currentState;
    private int multiTouchEnable;
    private int maxTouchPoint;
    protected int fingerCnt;
    private int grabFingerID = 0;
    private ArrayList<FingerPoint> FingerPointList;
    protected int fingerPointSize;
    protected int fingerPointSizeHalf;
    protected Image fingerPointImage;

    EmulatorFingers(EmulatorSkin skin, PaletteData palette, int maximum) {
        this.skin = skin;
        this.currentState = skin.currentState;
        this.communicator = skin.communicator;
        this.fingerPointImage = null;
        this.initMultiTouchState(maximum, palette);
    }

    public int removeFingerPointFromSlot(int index) {
        this.grabFingerID = 0;
        FingerPoint finger = this.getFingerPointFromSlot(index);
        if (finger != null) {
            this.logger.info("id " + finger.id + " finger releasing");
            if (finger.id > 0) {
                MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), 0, 0, finger.x, finger.y, finger.id - 1);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            }
            finger.id = 0;
            finger.originX = (finger.originY = (finger.x = (finger.y = -1)));
            --this.fingerCnt;
        }
        return this.fingerCnt;
    }

    public FingerPoint getFingerPointFromSlot(int index) {
        if (index < 0 || index >= this.getMaxTouchPoint()) {
            return null;
        }
        return this.FingerPointList.get(index);
    }

    public FingerPoint getFingerPointSearch(int x, int y) {
        FingerPoint finger = null;
        int fingerArea = this.fingerPointSizeHalf + 2 + (100 - this.skin.currentState.getCurrentScale()) * 4 / 100;
        for (int i = this.fingerCnt - 1; i >= 0; --i) {
            finger = this.getFingerPointFromSlot(i);
            if (finger == null || x < finger.x - fingerArea || x >= finger.x + fingerArea || y < finger.y - fingerArea || y >= finger.y + fingerArea) continue;
            return finger;
        }
        return null;
    }

    private void initMultiTouchState(int maximum, PaletteData palette) {
        this.multiTouchEnable = 0;
        int fingerCntMax = maximum;
        if (fingerCntMax > 10) {
            fingerCntMax = 10;
        }
        this.setMaxTouchPoint(fingerCntMax);
        this.logger.info("maxTouchPoint : " + this.getMaxTouchPoint());
        this.fingerCnt = 0;
        this.FingerPointList = new ArrayList();
        for (int i = 0; i < this.getMaxTouchPoint(); ++i) {
            this.FingerPointList.add(new FingerPoint(-1, -1, -1, -1));
        }
        this.fingerPointSize = 32;
        this.fingerPointSizeHalf = this.fingerPointSize / 2;
        if (palette != null) {
            Color pointOutlineColor = new Color((Device)this.skin.getShell().getDisplay(), 221, 221, 221);
            Color pointColor = new Color((Device)this.skin.getShell().getDisplay(), 15, 15, 15);
            ImageData imageData = new ImageData(this.fingerPointSize + 4, this.fingerPointSize + 4, 32, palette);
            imageData.transparentPixel = 0;
            this.fingerPointImage = new Image((Device)this.skin.getShell().getDisplay(), imageData);
            GC gc = new GC((Drawable)this.fingerPointImage);
            gc.setBackground(pointColor);
            gc.fillOval(2, 2, this.fingerPointSize, this.fingerPointSize);
            gc.setForeground(pointOutlineColor);
            gc.drawOval(0, 0, this.fingerPointSize + 2, this.fingerPointSize + 2);
            gc.dispose();
            pointOutlineColor.dispose();
            pointColor.dispose();
        }
    }

    public void setMultiTouchEnable(int mode) {
        this.multiTouchEnable = mode;
    }

    public int getMultiTouchEnable() {
        return this.multiTouchEnable;
    }

    public int getFingerCnt() {
        return this.fingerCnt;
    }

    protected int addFingerPoint(int originX, int originY, int x, int y) {
        if (this.fingerCnt == this.getMaxTouchPoint()) {
            this.logger.warning("support multi-touch up to " + this.getMaxTouchPoint() + " fingers");
            return -1;
        }
        ++this.fingerCnt;
        this.FingerPointList.get(this.fingerCnt - 1).id = this.fingerCnt;
        this.FingerPointList.get(this.fingerCnt - 1).originX = originX;
        this.FingerPointList.get(this.fingerCnt - 1).originY = originY;
        this.FingerPointList.get(this.fingerCnt - 1).x = x;
        this.FingerPointList.get(this.fingerCnt - 1).y = y;
        this.logger.info("id " + this.fingerCnt + " finger touching");
        return this.fingerCnt;
    }

    protected void drawFingerPoints(GC gc) {
        int alpha = gc.getAlpha();
        gc.setAlpha(126);
        FingerPoint fingerSlot = null;
        for (int i = 0; i < this.fingerCnt; ++i) {
            fingerSlot = this.getFingerPointFromSlot(i);
            if (fingerSlot == null) continue;
            gc.drawImage(this.fingerPointImage, fingerSlot.originX - this.fingerPointSizeHalf - 2, fingerSlot.originY - this.fingerPointSizeHalf - 2);
        }
        gc.setAlpha(alpha);
    }

    public void maruFingerProcessing1(int touchType, int originX, int originY, int x, int y) {
        FingerPoint finger = null;
        MouseEventData mouseEventData = null;
        if (touchType == ICommunicator.MouseEventType.PRESS.value() || touchType == ICommunicator.MouseEventType.DRAG.value()) {
            if (this.grabFingerID > 0) {
                finger = this.getFingerPointFromSlot(this.grabFingerID - 1);
                if (finger != null) {
                    finger.originX = originX;
                    finger.originY = originY;
                    finger.x = x;
                    finger.y = y;
                    if (finger.id != 0) {
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.grabFingerID - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                    }
                }
                return;
            }
            if (this.fingerCnt == 0) {
                this.logger.info("multi-touch mode 1 processing");
                if (this.addFingerPoint(originX, originY, x, y) == -1) {
                    return;
                }
                mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 0);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            } else {
                finger = this.getFingerPointSearch(x, y);
                if (finger != null) {
                    this.grabFingerID = finger.id;
                    this.logger.info("id " + this.grabFingerID + " finger is grabbed");
                } else if (this.fingerCnt == this.getMaxTouchPoint()) {
                    finger = this.getFingerPointFromSlot(this.fingerCnt - 1);
                    if (finger != null) {
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), originX, originY, finger.x, finger.y, this.fingerCnt - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        finger.originX = originX;
                        finger.originY = originY;
                        finger.x = x;
                        finger.y = y;
                        if (finger.id != 0) {
                            this.logger.info("id " + finger.id + " finger touching");
                            mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        }
                    }
                } else {
                    if (this.addFingerPoint(originX, originY, x, y) == -1) {
                        return;
                    }
                    mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                    this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                }
            }
        } else if (touchType == ICommunicator.MouseEventType.RELEASE.value()) {
            this.grabFingerID = 0;
        }
    }

    public void maruFingerProcessing2(int touchType, int originX, int originY, int x, int y) {
        block20: {
            block16: {
                MouseEventData mouseEventData;
                FingerPoint finger;
                block17: {
                    block18: {
                        finger = null;
                        mouseEventData = null;
                        if (touchType != ICommunicator.MouseEventType.PRESS.value() && touchType != ICommunicator.MouseEventType.DRAG.value()) break block16;
                        if (this.grabFingerID <= 0) break block17;
                        finger = this.getFingerPointFromSlot(this.grabFingerID - 1);
                        if (finger == null) break block18;
                        int originDistanceX = originX - finger.originX;
                        int originDistanceY = originY - finger.originY;
                        int distanceX = x - finger.x;
                        int distanceY = y - finger.y;
                        int i = 0;
                        Region maskRegion = this.skin.getDisplayCanvas().getRegion();
                        if (maskRegion == null) {
                            int currrntScreenW = this.currentState.getCurrentResolutionWidth();
                            int currrntScreenH = this.currentState.getCurrentResolutionHeight();
                            for (i = 0; i < this.fingerCnt; ++i) {
                                finger = this.getFingerPointFromSlot(i);
                                if (finger == null || finger.x + distanceX < currrntScreenW && finger.x + distanceX >= 0 && finger.y + distanceY < currrntScreenH && finger.y + distanceY >= 0) continue;
                                this.logger.info("id " + (i + 1) + " finger is out of bounds : (" + (finger.x + distanceX) + ", " + (finger.y + distanceY) + ")");
                                return;
                            }
                        } else {
                            for (i = 0; i < this.fingerCnt; ++i) {
                                finger = this.getFingerPointFromSlot(i);
                                if (finger == null || maskRegion.contains(finger.originX + originDistanceX, finger.originY + originDistanceY)) continue;
                                this.logger.info("id " + (i + 1) + " finger is out of bounds : (" + (finger.originX + originDistanceX) + ", " + (finger.originY + originDistanceY) + ")");
                                return;
                            }
                        }
                        for (i = 0; i < this.fingerCnt; ++i) {
                            finger = this.getFingerPointFromSlot(i);
                            if (finger == null) continue;
                            FingerPoint currrntScreenW = finger;
                            currrntScreenW.originX = currrntScreenW.originX + originDistanceX;
                            currrntScreenW = finger;
                            currrntScreenW.originY = currrntScreenW.originY + originDistanceY;
                            currrntScreenW = finger;
                            currrntScreenW.x = currrntScreenW.x + distanceX;
                            currrntScreenW = finger;
                            currrntScreenW.y = currrntScreenW.y + distanceY;
                            if (finger.id != 0) {
                                mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), finger.originX, finger.originY, finger.x, finger.y, i);
                                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                            }
                            try {
                                Thread.sleep(1L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return;
                }
                if (this.fingerCnt == 0) {
                    this.logger.info("multi-touch mode 2 processing");
                    if (this.addFingerPoint(originX, originY, x, y) == -1) {
                        return;
                    }
                    mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 0);
                    this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                } else {
                    finger = this.getFingerPointSearch(x, y);
                    if (finger != null) {
                        this.grabFingerID = finger.id;
                        this.logger.info("id " + this.grabFingerID + " finger is grabbed");
                    } else {
                        if (this.fingerCnt == this.getMaxTouchPoint()) {
                            return;
                        }
                        if (this.addFingerPoint(originX, originY, x, y) == -1) {
                            return;
                        }
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                    }
                }
                break block20;
            }
            if (touchType == ICommunicator.MouseEventType.RELEASE.value()) {
                this.grabFingerID = 0;
            }
        }
    }

    public void maruFingerProcessing3(int touchType, int originX, int originY, int x, int y) {
        FingerPoint finger = null;
        MouseEventData mouseEventData = null;
        if (touchType == ICommunicator.MouseEventType.PRESS.value() || touchType == ICommunicator.MouseEventType.DRAG.value()) {
            if (this.grabFingerID > 0) {
                finger = this.getFingerPointFromSlot(this.grabFingerID - 1);
                if (finger != null) {
                    FingerPoint coFinger;
                    int originDistanceX = originX - finger.originX;
                    int originDistanceY = originY - finger.originY;
                    int distanceX = x - finger.x;
                    int distanceY = y - finger.y;
                    FingerPoint fingerPoint = finger;
                    fingerPoint.originX = fingerPoint.originX + originDistanceX;
                    fingerPoint = finger;
                    fingerPoint.originY = fingerPoint.originY + originDistanceY;
                    fingerPoint = finger;
                    fingerPoint.x = fingerPoint.x + distanceX;
                    fingerPoint = finger;
                    fingerPoint.y = fingerPoint.y + distanceY;
                    if (finger.id != 0) {
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), finger.originX, finger.originY, finger.x, finger.y, finger.id - 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                    }
                    if (this.fingerCnt > 1 && (coFinger = this.getFingerPointFromSlot(this.grabFingerID == 2 ? 0 : 1)) != null) {
                        Region maskRegion = this.skin.getDisplayCanvas().getRegion();
                        if (maskRegion == null) {
                            int currrntScreenW = this.currentState.getCurrentResolutionWidth();
                            int currrntScreenH = this.currentState.getCurrentResolutionHeight();
                            if (coFinger.x - distanceX >= currrntScreenW || coFinger.x - distanceX < 0 || coFinger.y - distanceY >= currrntScreenH || coFinger.y - distanceY < 0) {
                                this.logger.info("id " + coFinger.id + " finger is out of bounds : (" + (coFinger.x - distanceX) + ", " + (coFinger.y - distanceY) + ")");
                                return;
                            }
                        } else if (!maskRegion.contains(coFinger.originX - originDistanceX, coFinger.originY - originDistanceY)) {
                            this.logger.info("id " + coFinger.id + " finger is out of bounds : (" + (coFinger.originX - originDistanceX) + ", " + (coFinger.originY - originDistanceY) + ")");
                            return;
                        }
                        FingerPoint fingerPoint2 = coFinger;
                        fingerPoint2.originX = fingerPoint2.originX - originDistanceX;
                        fingerPoint2 = coFinger;
                        fingerPoint2.originY = fingerPoint2.originY - originDistanceY;
                        fingerPoint2 = coFinger;
                        fingerPoint2.x = fingerPoint2.x - distanceX;
                        fingerPoint2 = coFinger;
                        fingerPoint2.y = fingerPoint2.y - distanceY;
                        if (coFinger.id != 0) {
                            mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), coFinger.originX, coFinger.originY, coFinger.x, coFinger.y, coFinger.id - 1);
                            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        }
                    }
                }
                return;
            }
            if (this.fingerCnt == 0) {
                this.logger.info("multi-touch mode 3 processing");
                if (this.addFingerPoint(originX, originY, x, y) == -1) {
                    return;
                }
                mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 0);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            } else {
                finger = this.getFingerPointSearch(x, y);
                if (finger != null) {
                    this.grabFingerID = finger.id;
                    this.logger.info("id " + this.grabFingerID + " finger is grabbed");
                } else if (this.fingerCnt >= 2) {
                    finger = this.getFingerPointFromSlot(1);
                    if (finger != null) {
                        mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), originX, originY, finger.x, finger.y, 1);
                        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        finger.originX = originX;
                        finger.originY = originY;
                        finger.x = x;
                        finger.y = y;
                        if (finger.id != 0) {
                            this.logger.info("id " + finger.id + " finger touching");
                            mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, 1);
                            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        }
                    }
                } else {
                    if (this.addFingerPoint(originX, originY, x, y) == -1) {
                        return;
                    }
                    mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), originX, originY, x, y, this.fingerCnt - 1);
                    this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                }
            }
        } else if (touchType == ICommunicator.MouseEventType.RELEASE.value()) {
            if (this.grabFingerID != 0) {
                this.logger.info("id " + this.grabFingerID + " finger releasing");
            }
            this.grabFingerID = 0;
        }
    }

    private Boolean calculateOriginCoordinates(int scaledDisplayWitdh, int scaledDisplayHeight, double scaleFactor, short rotationId, FingerPoint finger) {
        int pointX = 0;
        int pointY = 0;
        int rotatedPointX = 0;
        int rotatedPointY = 0;
        boolean flag = false;
        rotatedPointX = pointX = (int)((double)finger.x * scaleFactor);
        rotatedPointY = pointY = (int)((double)finger.y * scaleFactor);
        if (rotationId == 1) {
            rotatedPointX = pointY;
            rotatedPointY = scaledDisplayWitdh - pointX;
        } else if (rotationId == 2) {
            rotatedPointX = scaledDisplayWitdh - pointX;
            rotatedPointY = scaledDisplayHeight - pointY;
        } else if (rotationId == 3) {
            rotatedPointX = scaledDisplayHeight - pointY;
            rotatedPointY = pointX;
        }
        if (finger.originX != rotatedPointX) {
            this.logger.info("finger.originX: " + finger.originX);
            finger.originX = rotatedPointX;
            flag = true;
        }
        if (finger.originY != rotatedPointY) {
            this.logger.info("finger.originY: " + finger.originY);
            finger.originY = rotatedPointY;
            flag = true;
        }
        if (flag) {
            return true;
        }
        return false;
    }

    public int rearrangeFingerPoints(int displayWidth, int displayHeight, double scaleFactor, short rotationId) {
        if (this.multiTouchEnable == 0) {
            return 0;
        }
        int count = 0;
        FingerPoint finger = null;
        displayWidth = (int)((double)displayWidth * (scaleFactor /= 100.0));
        displayHeight = (int)((double)displayHeight * scaleFactor);
        for (int i = 0; i < this.fingerCnt; ++i) {
            finger = this.getFingerPointFromSlot(i);
            if (finger == null || finger.id == 0 || !this.calculateOriginCoordinates(displayWidth, displayHeight, scaleFactor, rotationId, finger).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public void clearFingerSlot(boolean keepEnable) {
        int i = 0;
        FingerPoint finger = null;
        if (!keepEnable) {
            this.setMultiTouchEnable(0);
        }
        this.logger.info("clear multi-touch : " + this.getMultiTouchEnable());
        for (i = 0; i < this.fingerCnt; ++i) {
            finger = this.getFingerPointFromSlot(i);
            if (finger == null) continue;
            if (finger.id > 0) {
                MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), 0, 0, finger.x, finger.y, finger.id - 1);
                this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            }
            finger.id = 0;
            finger.originX = (finger.originY = (finger.x = (finger.y = -1)));
        }
        this.grabFingerID = 0;
        this.fingerCnt = 0;
    }

    public void cleanupMultiTouchState() {
        this.clearFingerSlot(false);
        this.fingerPointImage.dispose();
    }

    public int getMaxTouchPoint() {
        if (this.maxTouchPoint <= 0) {
            this.setMaxTouchPoint(1);
        }
        return this.maxTouchPoint;
    }

    public void setMaxTouchPoint(int cnt) {
        if (cnt <= 0) {
            cnt = 1;
        }
        this.maxTouchPoint = cnt;
    }

    static class FingerPoint {
        private int id;
        private int originX;
        private int originY;
        private int x;
        private int y;

        FingerPoint(int originX, int originY, int x, int y) {
            this.originX = originX;
            this.originY = originY;
            this.x = x;
            this.y = y;
        }

        FingerPoint(int id, int originX, int originY, int x, int y) {
            this.id = id;
            this.originX = originX;
            this.originY = originY;
            this.x = x;
            this.y = y;
        }
    }
}

