/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.DisplayCanvas;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.BooleanData;
import org.tizen.emulator.skin.comm.sock.data.DisplayStateData;
import org.tizen.emulator.skin.comm.sock.data.KeyEventData;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.custom.CustomProgressBar;
import org.tizen.emulator.skin.custom.SkinWindow;
import org.tizen.emulator.skin.dbi.HoverType;
import org.tizen.emulator.skin.dbi.RgbType;
import org.tizen.emulator.skin.dbi.RotationType;
import org.tizen.emulator.skin.dialog.AboutDialog;
import org.tizen.emulator.skin.dialog.DetailInfoDialog;
import org.tizen.emulator.skin.dialog.RamdumpDialog;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.EmulatorSkinState;
import org.tizen.emulator.skin.info.SkinInformation;
import org.tizen.emulator.skin.layout.GeneralPurposeSkinComposer;
import org.tizen.emulator.skin.layout.ISkinComposer;
import org.tizen.emulator.skin.layout.ProfileRotarySkinComposer;
import org.tizen.emulator.skin.layout.ProfileSpecificSkinComposer;
import org.tizen.emulator.skin.layout.rotation.Rotation;
import org.tizen.emulator.skin.layout.rotation.SkinRotations;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.menu.KeyWindowKeeper;
import org.tizen.emulator.skin.menu.PopupMenu;
import org.tizen.emulator.skin.screenshot.ScreenShotDialog;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.StringUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class EmulatorSkin {
    private static Logger logger = SkinLogger.getSkinLogger(EmulatorSkin.class).getLogger();
    public EmulatorConfig config;
    protected Shell shell;
    protected ImageRegistry imageRegistry;
    protected DisplayCanvas displayCanvas;
    private int displayCanvasStyle;
    public Transform displayTransform;
    public SkinInformation skinInfo;
    protected ISkinComposer skinComposer;
    protected EmulatorSkinState currentState;
    protected boolean isDisplayDragging;
    protected Point shellGrabPosition;
    protected boolean isShutdownRequested;
    public boolean isOnTop;
    public boolean isOnInterpolation;
    public boolean isKeyWindow;
    public boolean isOnKbd;
    private PopupMenu popupMenu;
    private Timer closeTimer;
    public Color colorVM;
    private KeyWindowKeeper keyWindowKeeper;
    public CustomProgressBar bootingProgress;
    public ScreenShotDialog screenShotDialog;
    public SocketCommunicator communicator;
    private AtomicBoolean demanderFlag = new AtomicBoolean(false);
    private ShellListener shellListener;
    private MenuDetectListener shellMenuDetectListener;
    protected boolean isDisplayOn;
    private int prev_x;
    private int prev_y;
    private MouseMoveListener canvasMouseMoveListener;
    private MouseListener canvasMouseListener;
    private MouseWheelListener canvasMouseWheelListener;
    private KeyListener canvasKeyListener;
    private MenuDetectListener canvasMenuDetectListener;
    private FocusListener canvasFocusListener;
    private LinkedList<KeyEventData> pressedKeyEventList;

    protected EmulatorSkin(EmulatorConfig config, SkinInformation skinInfo, int displayCanvasStyle, boolean isOnTop) {
        this.config = config;
        this.skinInfo = skinInfo;
        this.screenShotDialog = null;
        this.pressedKeyEventList = new LinkedList();
        this.isOnTop = isOnTop;
        this.isOnInterpolation = true;
        this.isOnKbd = false;
        this.isKeyWindow = false;
        this.closeTimer = new Timer();
        int style = 0x20000008;
        this.shell = new Shell(Display.getDefault(), style);
        if (isOnTop && !SkinUtil.setTopMost(this.shell, true)) {
            logger.info("failed to set top most");
            this.isOnTop = false;
        }
        this.displayCanvasStyle = displayCanvasStyle;
        this.shellGrabPosition = new Point(-1, -1);
        this.currentState = new EmulatorSkinState();
        this.setColorVM();
        this.keyWindowKeeper = new KeyWindowKeeper(this);
        if (SwtUtil.isMacPlatform()) {
            this.shell.getDisplay().addListener(21, new Listener(){

                public void handleEvent(Event e) {
                    if (EmulatorSkin.this.pressedKeyEventList.size() == 1) {
                        KeyEventData data = (KeyEventData)EmulatorSkin.this.pressedKeyEventList.get(0);
                        if (data.keycode == 0x400000 && data.stateMask == 0) {
                            logger.info("COMMAND terminated!");
                            EmulatorSkinMain.terminateImmediately(-1);
                        }
                    }
                }
            });
        }
    }

    public void setCommunicator(SocketCommunicator communicator) {
        this.communicator = communicator;
    }

    private void setColorVM() {
        int portNumber = this.config.getArgInt("vm.baseport");
        if (portNumber >= 26200 || portNumber <= 0) {
            Random rand = new Random();
            int red = rand.nextInt(255);
            int green = rand.nextInt(255);
            int blue = rand.nextInt(255);
            this.colorVM = new Color((Device)this.shell.getDisplay(), new RGB(red, green, blue));
        } else {
            int vmIndex = portNumber % 100 / 10;
            SkinBasicColor[] colors = SkinBasicColor.values();
            this.colorVM = new Color((Device)this.shell.getDisplay(), colors[vmIndex].color());
        }
    }

    public StartData initSkin() {
        return null;
    }

    protected long initLayout() {
        logger.info("initialize the skin layout");
        this.imageRegistry = ImageRegistry.getInstance();
        this.currentState.setCurrentResolutionWidth(this.config.getValidResolutionWidth());
        this.currentState.setCurrentResolutionHeight(this.config.getValidResolutionHeight());
        this.currentState.setCurrentScale(this.config.getValidScale());
        this.currentState.setCurrentRotationId();
        this.popupMenu = new PopupMenu(this.config, this);
        if (!this.skinInfo.isGeneralPurposeSkin()) {
            if (StringUtil.nvl(this.config.getDbiContents().getLayer()).compareToIgnoreCase("rotary") == 0) {
                logger.info("profile rotary skin");
                this.skinComposer = new ProfileRotarySkinComposer(this.config, this);
            } else {
                this.skinComposer = new ProfileSpecificSkinComposer(this.config, this);
            }
        } else {
            this.skinComposer = new GeneralPurposeSkinComposer(this.config, this);
        }
        this.displayCanvas = this.skinComposer.compose(this.displayCanvasStyle);
        if (this.config.getArgBoolean("input.mouse", false)) {
            this.prev_x = this.displayCanvas.getSize().x / 2;
            this.prev_y = this.displayCanvas.getSize().y / 2;
            logger.info("prev_x : " + this.prev_x + " prev_y : " + this.prev_y);
            this.isDisplayOn = false;
        }
        this.currentState.setHoverColor(this.loadHoverColor());
        this.addMainWindowListeners();
        this.addCanvasListeners();
        this.displayCanvas.setFocus();
        return 0L;
    }

    private Color loadHoverColor() {
        RgbType hoverRgb;
        HoverType hover = this.config.getDbiContents().getHover();
        if (null != hover && null != (hoverRgb = hover.getColor())) {
            Long r = hoverRgb.getR();
            Long g = hoverRgb.getG();
            Long b = hoverRgb.getB();
            if (null != r && null != g && null != b) {
                Color hoverColor = new Color((Device)this.shell.getDisplay(), new RGB(r.intValue(), g.intValue(), b.intValue()));
                return hoverColor;
            }
        }
        return new Color((Device)this.shell.getDisplay(), new RGB(255, 255, 255));
    }

    public Shell getShell() {
        return this.shell;
    }

    public DisplayCanvas getDisplayCanvas() {
        return this.displayCanvas;
    }

    public EmulatorSkinState getEmulatorSkinState() {
        return this.currentState;
    }

    public ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    public Color getColorVM() {
        return this.colorVM;
    }

    public PopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public KeyWindowKeeper getKeyWindowKeeper() {
        return this.keyWindowKeeper;
    }

    public void open() {
        if (null == this.communicator) {
            logger.severe("communicator is null.");
            return;
        }
        Display display = this.shell.getDisplay();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void skinFinalize() {
        logger.info("skinFinalize");
        this.skinComposer.composerFinalize();
    }

    public void grabShell(int x, int y) {
        this.shellGrabPosition.x = x;
        this.shellGrabPosition.y = y;
        if (SwtUtil.isWindowsPlatform()) {
            BooleanData dataGrabbing = new BooleanData(true, ICommunicator.SendCommand.SEND_SKIN_GRABBED.toString());
            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_SKIN_GRABBED, dataGrabbing, false);
        }
    }

    public void ungrabShell() {
        this.shellGrabPosition.x = -1;
        this.shellGrabPosition.y = -1;
        if (SwtUtil.isWindowsPlatform()) {
            BooleanData dataGrabbing = new BooleanData(false, ICommunicator.SendCommand.SEND_SKIN_GRABBED.toString());
            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_SKIN_GRABBED, dataGrabbing, false);
        }
    }

    public boolean isShellGrabbing() {
        return this.shellGrabPosition.x >= 0 && this.shellGrabPosition.y >= 0;
    }

    public Point getGrabPosition() {
        if (!this.isShellGrabbing()) {
            return null;
        }
        return this.shellGrabPosition;
    }

    private void addMainWindowListeners() {
        this.shellListener = new ShellListener(){

            public void shellClosed(ShellEvent event) {
                logger.info("Main Window is closed");
                if (EmulatorSkin.this.isShutdownRequested) {
                    EmulatorSkin.this.closeTimer.cancel();
                    EmulatorSkin.this.removeShellListeners();
                    EmulatorSkin.this.removeCanvasListeners();
                    if (null != EmulatorSkin.this.screenShotDialog) {
                        Shell scShell = EmulatorSkin.this.screenShotDialog.getShell();
                        if (!scShell.isDisposed()) {
                            scShell.close();
                        }
                        EmulatorSkin.this.screenShotDialog = null;
                    }
                    EmulatorSkin.this.config.setSkinProperty("window.x", EmulatorSkin.this.shell.getLocation().x);
                    EmulatorSkin.this.config.setSkinProperty("window.y", EmulatorSkin.this.shell.getLocation().y);
                    EmulatorSkin.this.config.setSkinProperty("window.scale", EmulatorSkin.this.currentState.getCurrentScale());
                    EmulatorSkin.this.config.setSkinProperty("window.rotate", EmulatorSkin.this.currentState.getCurrentRotationId());
                    EmulatorSkin.this.config.setSkinProperty("window.ontop", Boolean.toString(EmulatorSkin.this.isOnTop));
                    EmulatorSkin.this.config.setSkinProperty("window.interpolation", Boolean.toString(EmulatorSkin.this.isOnInterpolation));
                    int dockValue = 0;
                    SkinWindow keyWindow = EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow();
                    if (keyWindow != null && keyWindow.getShell().isVisible()) {
                        dockValue = EmulatorSkin.this.getKeyWindowKeeper().getDockPosition();
                    }
                    EmulatorSkin.this.config.setSkinProperty("window.keywindow.position", dockValue);
                    EmulatorSkin.this.config.saveSkinProperties();
                    if (EmulatorSkin.this.getKeyWindowKeeper() != null) {
                        EmulatorSkin.this.getKeyWindowKeeper().dispose();
                    }
                    if (EmulatorSkin.this.currentState.getCurrentImage() != null) {
                        EmulatorSkin.this.currentState.getCurrentImage().dispose();
                        EmulatorSkin.this.currentState.setCurrentImage(null);
                    }
                    if (EmulatorSkin.this.currentState.getCurrentKeyPressedImage() != null) {
                        EmulatorSkin.this.currentState.getCurrentKeyPressedImage().dispose();
                        EmulatorSkin.this.currentState.setCurrentKeyPressedImage(null);
                    }
                    if (EmulatorSkin.this.colorVM != null) {
                        EmulatorSkin.this.colorVM.dispose();
                    }
                    if (EmulatorSkin.this.currentState.getHoverColor() != null) {
                        EmulatorSkin.this.currentState.getHoverColor().dispose();
                    }
                    EmulatorSkin.this.skinFinalize();
                } else {
                    event.doit = false;
                    if (EmulatorSkin.this.pressedKeyEventList.isEmpty() && EmulatorSkin.this.demanderFlag.compareAndSet(false, true)) {
                        if (null != EmulatorSkin.this.communicator) {
                            EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_CLOSE_REQ, null, false);
                        }
                        try {
                            EmulatorSkin.this.closeTimer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    EmulatorSkin.this.demanderFlag.set(false);
                                }
                            }, 1500L);
                        }
                        catch (IllegalArgumentException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    } else {
                        logger.info("skip close request");
                    }
                }
            }

            public void shellActivated(ShellEvent event) {
                logger.info("activate");
                if (EmulatorSkin.this.isKeyWindow && EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow() != null) {
                    if (!EmulatorSkin.this.isOnTop) {
                        EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell().moveAbove((Control)EmulatorSkin.this.shell);
                        if (EmulatorSkin.this.getKeyWindowKeeper().getDockPosition() != 0) {
                            EmulatorSkin.this.shell.moveAbove((Control)EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell());
                        }
                    } else if (EmulatorSkin.this.getKeyWindowKeeper().getDockPosition() == 0) {
                        EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell().moveAbove((Control)EmulatorSkin.this.shell);
                    }
                }
            }

            public void shellDeactivated(ShellEvent event) {
            }

            public void shellIconified(ShellEvent event) {
                logger.info("iconified");
                EmulatorSkin.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell keyWindowShell;
                        if (EmulatorSkin.this.isKeyWindow && EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow() != null && !(keyWindowShell = EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell()).getMinimized()) {
                            keyWindowShell.setVisible(false);
                            keyWindowShell.setMinimized(true);
                        }
                    }
                });
            }

            public void shellDeiconified(ShellEvent event) {
                Shell keyWindowShell;
                logger.info("deiconified");
                if (EmulatorSkin.this.isKeyWindow && EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow() != null && (keyWindowShell = EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell()).getMinimized()) {
                    keyWindowShell.setMinimized(false);
                    keyWindowShell.setVisible(true);
                }
                DisplayStateData stateData = new DisplayStateData(EmulatorSkin.this.currentState.getCurrentScale(), EmulatorSkin.this.currentState.getCurrentRotationId());
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_DISPLAY_STATE, stateData, false);
            }
        };
        this.shell.addShellListener(this.shellListener);
        this.shellMenuDetectListener = new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (EmulatorSkin.this.isDisplayDragging || EmulatorSkin.this.isShellGrabbing() || EmulatorSkin.this.isShutdownRequested) {
                    logger.info("menu is blocked");
                    e.doit = false;
                    return;
                }
                Menu menu = EmulatorSkin.this.popupMenu.getMenuRoot();
                if (menu != null) {
                    EmulatorSkin.this.keyForceRelease(false);
                    EmulatorSkin.this.shell.setMenu(menu);
                    menu.setVisible(true);
                    e.doit = false;
                } else {
                    EmulatorSkin.this.shell.setMenu(null);
                }
            }
        };
        this.shell.addMenuDetectListener(this.shellMenuDetectListener);
        if (!SwtUtil.isWindowsPlatform()) {
            this.shell.getDisplay().addListener(39, new Listener(){

                public void handleEvent(Event e) {
                    logger.info("operating system property has been changed");
                    EmulatorSkin.this.rearrangeSkin();
                }
            });
        }
    }

    private void removeShellListeners() {
        if (null != this.shellListener) {
            this.shell.removeShellListener(this.shellListener);
        }
        if (null != this.shellMenuDetectListener) {
            this.shell.removeMenuDetectListener(this.shellMenuDetectListener);
        }
    }

    private MouseMoveListener makeDisplayTouchMoveListener() {
        MouseMoveListener listener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (EmulatorSkin.this.isDisplayDragging) {
                    short eventType = ICommunicator.MouseEventType.DRAG.value();
                    Point canvasSize = EmulatorSkin.this.displayCanvas.getSize();
                    if (e.x < 0) {
                        e.x = 0;
                        eventType = ICommunicator.MouseEventType.RELEASE.value();
                        EmulatorSkin.this.isDisplayDragging = false;
                    } else if (e.x >= canvasSize.x) {
                        e.x = canvasSize.x - 1;
                        eventType = ICommunicator.MouseEventType.RELEASE.value();
                        EmulatorSkin.this.isDisplayDragging = false;
                    }
                    if (e.y < 0) {
                        e.y = 0;
                        eventType = ICommunicator.MouseEventType.RELEASE.value();
                        EmulatorSkin.this.isDisplayDragging = false;
                    } else if (e.y >= canvasSize.y) {
                        e.y = canvasSize.y - 1;
                        eventType = ICommunicator.MouseEventType.RELEASE.value();
                        EmulatorSkin.this.isDisplayDragging = false;
                    }
                    Region displayRegion = EmulatorSkin.this.displayCanvas.getRegion();
                    if (displayRegion != null && !displayRegion.contains(e.x, e.y)) {
                        logger.info("out of range touch event : " + e.x + ", " + e.y);
                        int angle = SkinUtil.getAngleFromVector((Control)EmulatorSkin.this.displayCanvas, e.x, e.y);
                        if (angle < 0) {
                            angle += 360;
                        }
                        int displayCenterX = EmulatorSkin.this.displayCanvas.getSize().x / 2;
                        int displayCenterY = EmulatorSkin.this.displayCanvas.getSize().y / 2;
                        if (angle >= 45 && angle < 135) {
                            do {
                                --e.y;
                            } while (!displayRegion.contains(e.x, e.y) && displayCenterY < e.y);
                        } else if (angle >= 135 && angle < 225) {
                            do {
                                ++e.x;
                            } while (!displayRegion.contains(e.x, e.y) && displayCenterX > e.x);
                        } else if (angle >= 225 && angle < 315) {
                            do {
                                ++e.y;
                            } while (!displayRegion.contains(e.x, e.y) && displayCenterY > e.y);
                        } else {
                            do {
                                --e.x;
                            } while (!displayRegion.contains(e.x, e.y) && displayCenterX < e.x);
                        }
                        logger.info("auto release : touch=" + e.x + ", " + e.y + " (" + angle + ")");
                        eventType = ICommunicator.MouseEventType.RELEASE.value();
                        EmulatorSkin.this.isDisplayDragging = false;
                    }
                    EmulatorSkin.this.mouseMoveDelivery(e, eventType);
                }
            }
        };
        return listener;
    }

    private void getRelativePoint(MouseEvent e) {
        int diff_x = e.x - this.prev_x;
        int diff_y = e.y - this.prev_y;
        int final_x = e.x;
        int final_y = e.y;
        Point canvasSize = this.displayCanvas.getSize();
        if (final_x >= canvasSize.x) {
            e.x = canvasSize.x - this.prev_x - 1;
            this.prev_x = canvasSize.x - 1;
        } else if (final_x <= 0) {
            e.x = -this.prev_x;
            this.prev_x = 0;
        } else {
            this.prev_x = e.x;
            e.x = diff_x;
        }
        if (final_y >= canvasSize.y) {
            e.y = canvasSize.y - this.prev_y - 1;
            this.prev_y = canvasSize.y - 1;
        } else if (final_y <= 0) {
            e.y = -this.prev_y;
            this.prev_y = 0;
        } else {
            this.prev_y = e.y;
            e.y = diff_y;
        }
    }

    private MouseMoveListener makeDisplayMouseMoveListener() {
        MouseMoveListener listener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (EmulatorSkin.this.isDisplayOn) {
                    short eventType = ICommunicator.MouseEventType.MOVE.value();
                    if (EmulatorSkin.this.isDisplayDragging) {
                        Point canvasSize = EmulatorSkin.this.displayCanvas.getSize();
                        eventType = ICommunicator.MouseEventType.DRAG.value();
                        if (e.x < 0) {
                            e.x = 0;
                            eventType = ICommunicator.MouseEventType.RELEASE.value();
                            EmulatorSkin.this.isDisplayDragging = false;
                        } else if (e.x >= canvasSize.x) {
                            e.x = canvasSize.x - 1;
                            eventType = ICommunicator.MouseEventType.RELEASE.value();
                            EmulatorSkin.this.isDisplayDragging = false;
                        }
                        if (e.y < 0) {
                            e.y = 0;
                            eventType = ICommunicator.MouseEventType.RELEASE.value();
                            EmulatorSkin.this.isDisplayDragging = false;
                        } else if (e.y >= canvasSize.y) {
                            e.y = canvasSize.y - 1;
                            eventType = ICommunicator.MouseEventType.RELEASE.value();
                            EmulatorSkin.this.isDisplayDragging = false;
                        }
                    }
                    EmulatorSkin.this.getRelativePoint(e);
                    if (e.x != 0 || e.y != 0) {
                        EmulatorSkin.this.mouseMoveDelivery(e, eventType);
                    }
                }
            }
        };
        return listener;
    }

    private MouseListener makeDisplayTouchClickListener() {
        MouseListener listener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                EmulatorSkin.this.getKeyWindowKeeper().redock(false, false);
                if (1 == e.button) {
                    if (EmulatorSkin.this.isDisplayDragging) {
                        EmulatorSkin.this.isDisplayDragging = false;
                    }
                    EmulatorSkin.this.mouseUpDelivery(e);
                } else if (2 == e.button) {
                    logger.info("wheelUp in display");
                }
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    if (!EmulatorSkin.this.isDisplayDragging) {
                        EmulatorSkin.this.isDisplayDragging = true;
                    }
                    EmulatorSkin.this.mouseDownDelivery(e);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        return listener;
    }

    private MouseListener makeDisplayMouseClickListener() {
        MouseListener listener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (EmulatorSkin.this.isDisplayOn) {
                    logger.info("mouse up : " + e);
                    if (1 == e.button) {
                        if (EmulatorSkin.this.isDisplayDragging) {
                            EmulatorSkin.this.isDisplayDragging = false;
                        }
                        EmulatorSkin.this.getRelativePoint(e);
                        EmulatorSkin.this.mouseUpDelivery(e);
                    } else if (2 == e.button) {
                        logger.info("wheelUp in display");
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (EmulatorSkin.this.isDisplayOn) {
                    logger.info("mouse down : " + e);
                    if (1 == e.button) {
                        if (!EmulatorSkin.this.isDisplayDragging) {
                            EmulatorSkin.this.isDisplayDragging = true;
                        }
                        EmulatorSkin.this.getRelativePoint(e);
                        EmulatorSkin.this.mouseDownDelivery(e);
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                logger.info("mouse double click : " + e);
            }
        };
        return listener;
    }

    private MouseWheelListener makeDisplayMouseWheelListener() {
        MouseWheelListener listener = new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                EmulatorSkin.this.getRelativePoint(e);
                int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, EmulatorSkin.this.currentState.getCurrentResolutionWidth(), EmulatorSkin.this.currentState.getCurrentResolutionHeight(), EmulatorSkin.this.currentState.getCurrentScale(), EmulatorSkin.this.currentState.getCurrentRotationId());
                logger.info("mouseWheel in display x:" + geometry[0] + " y:" + geometry[1] + " value:" + e.count);
                short eventType = e.count < 0 ? ICommunicator.MouseEventType.WHEELDOWN.value() : ICommunicator.MouseEventType.WHEELUP.value();
                MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.WHEEL.value(), eventType, e.x, e.y, geometry[0], geometry[1], e.count);
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
            }
        };
        return listener;
    }

    private void addCanvasListeners() {
        this.canvasMenuDetectListener = new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (EmulatorSkin.this.isDisplayDragging || EmulatorSkin.this.isShellGrabbing() || EmulatorSkin.this.isShutdownRequested) {
                    logger.info("menu is blocked");
                    e.doit = false;
                    return;
                }
                Menu menu = EmulatorSkin.this.popupMenu.getMenuRoot();
                if (menu != null) {
                    EmulatorSkin.this.keyForceRelease(false);
                    EmulatorSkin.this.displayCanvas.setMenu(menu);
                    menu.setVisible(true);
                    e.doit = false;
                } else {
                    EmulatorSkin.this.displayCanvas.setMenu(null);
                }
            }
        };
        this.displayCanvas.addMenuDetectListener(this.canvasMenuDetectListener);
        this.canvasFocusListener = new FocusListener(){

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent event) {
                logger.info("lost focus");
                EmulatorSkin.this.keyForceRelease(false);
            }
        };
        this.displayCanvas.addFocusListener(this.canvasFocusListener);
        if (this.config.getArgBoolean("input.mouse", false)) {
            this.canvasMouseMoveListener = this.makeDisplayMouseMoveListener();
            this.canvasMouseListener = this.makeDisplayMouseClickListener();
            this.canvasMouseWheelListener = this.makeDisplayMouseWheelListener();
            this.displayCanvas.addMouseWheelListener(this.canvasMouseWheelListener);
        } else {
            this.canvasMouseMoveListener = this.makeDisplayTouchMoveListener();
            this.canvasMouseListener = this.makeDisplayTouchClickListener();
        }
        this.displayCanvas.addMouseMoveListener(this.canvasMouseMoveListener);
        this.displayCanvas.addMouseListener(this.canvasMouseListener);
        this.canvasKeyListener = new KeyListener(){
            private KeyEvent previous;
            private boolean disappearEvent = false;
            private int disappearKeycode = 0;
            private int disappearStateMask = 0;
            private int disappearKeyLocation = 0;

            public void keyReleased(KeyEvent e) {
                if (logger.isLoggable(Level.INFO)) {
                    String character = e.character == '\u0000' ? "\\0" : (e.character == '\n' ? "\\n" : (e.character == '\r' ? "\\r" : "" + e.character));
                    logger.info("'" + character + "':" + e.keyCode + ":" + e.stateMask + ":" + e.keyLocation);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine(e.toString());
                }
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                if (SwtUtil.isWindowsPlatform()) {
                    KeyEventData keyEventData;
                    if (this.disappearEvent) {
                        this.disappearEvent = false;
                        if (EmulatorSkin.this.isMetaKey(keyCode) && e.character != '\u0000') {
                            logger.info("send disappear release : keycode=" + this.disappearKeycode + ", stateMask=" + this.disappearStateMask + ", keyLocation=" + this.disappearKeyLocation);
                            keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), this.disappearKeycode, this.disappearStateMask, this.disappearKeyLocation);
                            EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
                            EmulatorSkin.this.removePressedKeyFromList(keyEventData);
                            this.disappearKeycode = 0;
                            this.disappearStateMask = 0;
                            this.disappearKeyLocation = 0;
                        }
                    }
                    if (this.previous != null) {
                        keyEventData = null;
                        if (this.previous.keyCode == 13 && (keyCode & 0x1000000) != 0 && e.character == '\r') {
                            logger.info("send upon release : keycode=13");
                            keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), 13, 0, 0);
                        } else if (this.previous.keyCode == 32 && (keyCode & 0x1000000) != 0 && e.character == ' ') {
                            logger.info("send upon release : keycode=32");
                            keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), 32, 0, 0);
                        } else if (this.previous.keyCode == 9 && (keyCode & 0x1000000) != 0 && e.character == '\t') {
                            logger.info("send upon release : keycode=9");
                            keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), 9, 0, 0);
                        } else if (this.previous.keyCode == 0x1000050 && (keyCode & 0x1000000) != 0 && e.character == '\r' && keyCode != 0x1000050) {
                            logger.info("send upon release : keycode=16777296");
                            keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), 0x1000050, 0, 2);
                        }
                        if (keyEventData != null) {
                            EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
                            EmulatorSkin.this.removePressedKeyFromList(keyEventData);
                        }
                    }
                }
                this.previous = null;
                EmulatorSkin.this.keyReleasedDelivery(keyCode, stateMask, e.keyLocation, true);
            }

            public void keyPressed(KeyEvent e) {
                int keyCode = e.keyCode;
                int stateMask = e.stateMask;
                if (SwtUtil.isWindowsPlatform() && null != this.previous && this.previous.keyCode != keyCode) {
                    if (EmulatorSkin.this.isMetaKey(this.previous.keyCode)) {
                        this.disappearEvent = true;
                        this.disappearKeycode = keyCode;
                        this.disappearStateMask = stateMask;
                        this.disappearKeyLocation = e.keyLocation;
                    } else {
                        if (this.disappearEvent) {
                            logger.info("replace the disappearEvent : " + this.disappearKeycode + "->" + keyCode);
                            this.disappearKeycode = keyCode;
                            this.disappearStateMask = stateMask;
                            this.disappearKeyLocation = e.keyLocation;
                        }
                        int previousKeyCode = this.previous.keyCode;
                        int previousStateMask = this.previous.stateMask;
                        if (logger.isLoggable(Level.INFO)) {
                            String character = this.previous.character == '\u0000' ? "\\0" : (this.previous.character == '\n' ? "\\n" : (this.previous.character == '\r' ? "\\r" : "" + this.previous.character));
                            logger.info("send previous release : '" + character + "':" + this.previous.keyCode + ":" + this.previous.stateMask + ":" + this.previous.keyLocation);
                        } else if (logger.isLoggable(Level.FINE)) {
                            logger.fine("send previous release :" + this.previous.toString());
                        }
                        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), previousKeyCode, previousStateMask, this.previous.keyLocation);
                        EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
                        EmulatorSkin.this.removePressedKeyFromList(keyEventData);
                    }
                }
                if (logger.isLoggable(Level.INFO)) {
                    String character = e.character == '\u0000' ? "\\0" : (e.character == '\n' ? "\\n" : (e.character == '\r' ? "\\r" : "" + e.character));
                    logger.info("'" + character + "':" + e.keyCode + ":" + e.stateMask + ":" + e.keyLocation);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine(e.toString());
                }
                EmulatorSkin.this.keyPressedDelivery(keyCode, stateMask, e.keyLocation, true);
                this.previous = e;
            }
        };
        this.displayCanvas.addKeyListener(this.canvasKeyListener);
    }

    protected void mouseMoveDelivery(MouseEvent e, int eventType) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), eventType, e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    protected void mouseUpDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseUp in display x:" + geometry[0] + " y:" + geometry[1]);
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    protected void mouseDownDelivery(MouseEvent e) {
        int[] geometry = SkinUtil.convertMouseGeometry(e.x, e.y, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
        logger.info("mouseDown in display x:" + geometry[0] + " y:" + geometry[1]);
        MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, geometry[0], geometry[1], 0);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
    }

    protected void keyReleasedDelivery(int keyCode, int stateMask, int keyLocation, boolean remove) {
        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), keyCode, stateMask, keyLocation);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
        if (remove) {
            this.removePressedKeyFromList(keyEventData);
        }
    }

    protected void keyPressedDelivery(int keyCode, int stateMask, int keyLocation, boolean add) {
        KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.PRESSED.value(), keyCode, stateMask, keyLocation);
        this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_KEYBOARD_KEY_EVENT, keyEventData, false);
        if (add) {
            this.addPressedKeyToList(keyEventData);
        }
    }

    private boolean isMetaKey(int keyCode) {
        return 262144 == keyCode || 65536 == keyCode || 131072 == keyCode || 0x400000 == keyCode;
    }

    protected synchronized boolean addPressedKeyToList(KeyEventData pressData) {
        for (KeyEventData data : this.pressedKeyEventList) {
            if (data.keycode != pressData.keycode || data.keyLocation != pressData.keyLocation) continue;
            return false;
        }
        this.pressedKeyEventList.add(pressData);
        return true;
    }

    protected synchronized boolean removePressedKeyFromList(KeyEventData releaseData) {
        for (KeyEventData data : this.pressedKeyEventList) {
            if (data.keycode != releaseData.keycode || data.keyLocation != releaseData.keyLocation) continue;
            this.pressedKeyEventList.remove(data);
            return true;
        }
        return false;
    }

    private void removeCanvasListeners() {
        if (null != this.canvasMouseMoveListener) {
            this.displayCanvas.removeMouseMoveListener(this.canvasMouseMoveListener);
        }
        if (null != this.canvasMouseListener) {
            this.displayCanvas.removeMouseListener(this.canvasMouseListener);
        }
        if (null != this.canvasKeyListener) {
            this.displayCanvas.removeKeyListener(this.canvasKeyListener);
        }
        if (null != this.canvasMenuDetectListener) {
            this.displayCanvas.removeMenuDetectListener(this.canvasMenuDetectListener);
        }
        if (null != this.canvasFocusListener) {
            this.displayCanvas.removeFocusListener(this.canvasFocusListener);
        }
        if (null != this.canvasMouseWheelListener) {
            this.displayCanvas.removeMouseWheelListener(this.canvasMouseWheelListener);
        }
    }

    protected void rearrangeSkin() {
        this.skinComposer.arrangeSkin(this.currentState.getCurrentScale(), this.currentState.getCurrentRotationId());
    }

    public void updateSkin() {
        this.skinComposer.updateSkin();
    }

    public void updateDisplay() {
    }

    public void setSuitableTransform() {
        if (this.displayTransform != null) {
            this.displayTransform.dispose();
        }
        this.displayTransform = new Transform((Device)this.displayCanvas.getDisplay());
        short rotationId = this.currentState.getCurrentRotationId();
        this.displayTransform.rotate((float)SkinRotations.getAngle(rotationId));
        if (rotationId == 1) {
            this.displayTransform.translate((float)(this.displayCanvas.getSize().y * -1), 0.0f);
        } else if (rotationId == 2) {
            this.displayTransform.translate((float)(this.displayCanvas.getSize().x * -1), (float)(this.displayCanvas.getSize().y * -1));
        } else if (rotationId == 3) {
            this.displayTransform.translate(0.0f, (float)(this.displayCanvas.getSize().x * -1));
        }
    }

    public void setCoverImage(Image image) {
    }

    protected void openScreenShotWindow() {
    }

    public void updateProgressBar(final int idxLayer, final int progress) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (EmulatorSkin.this.bootingProgress != null) {
                    EmulatorSkin.this.bootingProgress.setSelection(idxLayer, progress);
                }
            }
        });
    }

    public void updateDisplayPower(final boolean on) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (on) {
                    EmulatorSkin.this.displayOn();
                } else {
                    EmulatorSkin.this.displayOff();
                }
            }
        });
    }

    public void updateHostKbdMenu(boolean on) {
        this.isOnKbd = on;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MenuItem item = EmulatorSkin.this.getPopupMenu().hostKbdOnItem;
                if (item != null) {
                    item.setSelection(EmulatorSkin.this.isOnKbd);
                }
                if ((item = EmulatorSkin.this.getPopupMenu().hostKbdOffItem) != null) {
                    item.setSelection(!EmulatorSkin.this.isOnKbd);
                }
            }
        });
    }

    protected void displayOn() {
        logger.info("display on");
        if (this.config.getArgBoolean("input.mouse", false)) {
            this.isDisplayOn = true;
        }
    }

    protected void displayOff() {
        logger.info("display off");
        if (this.config.getArgBoolean("input.mouse", false)) {
            this.isDisplayOn = false;
        }
        if (this.isDisplayDragging) {
            logger.info("auto release : mouseEvent");
            MouseEventData mouseEventData = new MouseEventData(0, ICommunicator.MouseEventType.RELEASE.value(), 0, 0, 0, 0, 0);
            this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
        }
    }

    public SelectionAdapter createDetailInfoMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Open detail info");
                }
                DetailInfoDialog detailInfoDialog = new DetailInfoDialog(EmulatorSkin.this.shell, EmulatorSkin.this.communicator, EmulatorSkin.this.config, EmulatorSkin.this.skinInfo);
                detailInfoDialog.open();
            }
        };
        return listener;
    }

    public SelectionAdapter createTopMostMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorSkin.this.isOnTop = ((EmulatorSkin)EmulatorSkin.this).popupMenu.onTopItem.getSelection();
                logger.info("Select top most : " + EmulatorSkin.this.isOnTop);
                if (!SkinUtil.setTopMost(EmulatorSkin.this.shell, EmulatorSkin.this.isOnTop)) {
                    logger.info("failed to top most");
                    EmulatorSkin.this.isOnTop = false;
                    ((EmulatorSkin)EmulatorSkin.this).popupMenu.onTopItem.setSelection(false);
                } else if (EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow() != null) {
                    SkinUtil.setTopMost(EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow().getShell(), EmulatorSkin.this.isOnTop);
                }
            }
        };
        return listener;
    }

    public Menu createRotateMenu() {
        Menu menu = new Menu((Decorations)this.shell, 4);
        ArrayList<MenuItem> rotationList = new ArrayList<MenuItem>();
        Iterator<Map.Entry<Short, Rotation>> iterator = SkinRotations.getRotationIterator();
        while (iterator.hasNext()) {
            Map.Entry<Short, Rotation> entry = iterator.next();
            Short rotationId = entry.getKey();
            RotationType section = entry.getValue();
            MenuItem menuItem = new MenuItem(menu, 16);
            menuItem.setText(section.getName().value());
            menuItem.setData((Object)rotationId);
            if (this.currentState.getCurrentRotationId() == rotationId.shortValue()) {
                menuItem.setSelection(true);
            }
            rotationList.add(menuItem);
        }
        if (this.currentState.getCurrentResolutionWidth() > this.currentState.getCurrentResolutionHeight()) {
            for (MenuItem m : rotationList) {
                short rotationId = (Short)m.getData();
                if (rotationId == 0) {
                    String landscape = SkinRotations.getRotation((short)1).getName().value();
                    m.setText(landscape);
                    continue;
                }
                if (rotationId == 1) {
                    String portrait = SkinRotations.getRotation((short)0).getName().value();
                    m.setText(portrait);
                    continue;
                }
                if (rotationId == 2) {
                    String landscapeReverse = SkinRotations.getRotation((short)3).getName().value();
                    m.setText(landscapeReverse);
                    continue;
                }
                if (rotationId != 3) continue;
                String portraitReverse = SkinRotations.getRotation((short)2).getName().value();
                m.setText(portraitReverse);
            }
        }
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Rotate menu is selected");
                MenuItem item = (MenuItem)e.getSource();
                boolean selection = item.getSelection();
                if (!selection) {
                    return;
                }
                final short rotationId = (Short)item.getData();
                EmulatorSkin.this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EmulatorSkin.this.skinComposer.arrangeSkin(EmulatorSkin.this.currentState.getCurrentScale(), rotationId);
                        Rectangle monitorBounds = Display.getDefault().getBounds();
                        Rectangle emulatorBounds = EmulatorSkin.this.shell.getBounds();
                        EmulatorSkin.this.shell.setLocation(Math.max(emulatorBounds.x, monitorBounds.x), Math.max(emulatorBounds.y, monitorBounds.y));
                    }
                });
                DisplayStateData stateData = new DisplayStateData(EmulatorSkin.this.currentState.getCurrentScale(), rotationId);
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_DISPLAY_STATE, stateData, false);
                EmulatorSkin.this.updateDisplay();
            }
        };
        for (MenuItem menuItem : rotationList) {
            menuItem.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return menu;
    }

    public SelectionAdapter createScaleMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Scale menu is selected");
                MenuItem item = (MenuItem)e.getSource();
                boolean selection = item.getSelection();
                if (!selection) {
                    return;
                }
                final int scale = (Integer)item.getData();
                EmulatorSkin.this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EmulatorSkin.this.skinComposer.arrangeSkin(scale, EmulatorSkin.this.currentState.getCurrentRotationId());
                        Rectangle monitorBounds = Display.getDefault().getBounds();
                        Rectangle emulatorBounds = EmulatorSkin.this.shell.getBounds();
                        EmulatorSkin.this.shell.setLocation(Math.max(emulatorBounds.x, monitorBounds.x), Math.max(emulatorBounds.y, monitorBounds.y));
                    }
                });
                DisplayStateData stateData = new DisplayStateData(scale, EmulatorSkin.this.currentState.getCurrentRotationId());
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_DISPLAY_STATE, stateData, false);
                EmulatorSkin.this.updateDisplay();
            }
        };
        return listener;
    }

    public SelectionAdapter createInterpolationMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.getSource();
                if (item.getSelection()) {
                    boolean on;
                    EmulatorSkin.this.isOnInterpolation = on = item.equals(((EmulatorSkin)EmulatorSkin.this).popupMenu.interpolationHighItem);
                    logger.info("Select scale interpolation : " + EmulatorSkin.this.isOnInterpolation);
                    EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_INTERPOLATION_STATE, new BooleanData(on, ICommunicator.SendCommand.SEND_INTERPOLATION_STATE.toString()), false);
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createKeyWindowMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem layoutSelected;
                logger.info("Key Window menu is selected");
                if (!EmulatorSkin.this.getKeyWindowKeeper().isGeneralKeyWindow() && (layoutSelected = (MenuItem)e.widget).getSelection()) {
                    for (MenuItem layout : layoutSelected.getParent().getItems()) {
                        if (layout != layoutSelected) {
                            layout.setSelection(false);
                            continue;
                        }
                        int layoutIndex = EmulatorSkin.this.getKeyWindowKeeper().getLayoutIndex();
                        if (EmulatorSkin.this.getKeyWindowKeeper().determineLayout() == layoutIndex) continue;
                        EmulatorSkin.this.getKeyWindowKeeper().closeKeyWindow();
                        layoutSelected.setSelection(true);
                    }
                }
                if (EmulatorSkin.this.getKeyWindowKeeper().isSelectKeyWindowMenu()) {
                    if (EmulatorSkin.this.getKeyWindowKeeper().getKeyWindow() == null) {
                        if (EmulatorSkin.this.getKeyWindowKeeper().getRecentlyDocked() != 0) {
                            EmulatorSkin.this.getKeyWindowKeeper().openKeyWindow(EmulatorSkin.this.getKeyWindowKeeper().getRecentlyDocked(), false);
                            EmulatorSkin.this.getKeyWindowKeeper().setRecentlyDocked(0);
                        } else {
                            EmulatorSkin.this.getKeyWindowKeeper().openKeyWindow(0x1020000, false);
                        }
                    } else {
                        EmulatorSkin.this.getKeyWindowKeeper().openKeyWindow(EmulatorSkin.this.getKeyWindowKeeper().getDockPosition(), false);
                    }
                } else if (EmulatorSkin.this.getKeyWindowKeeper().getDockPosition() != 0) {
                    EmulatorSkin.this.getKeyWindowKeeper().setRecentlyDocked(EmulatorSkin.this.getKeyWindowKeeper().getDockPosition());
                    EmulatorSkin.this.getKeyWindowKeeper().closeKeyWindow();
                } else {
                    EmulatorSkin.this.getKeyWindowKeeper().hideKeyWindow();
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createRamdumpMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Ram dump menu is selected");
                EmulatorSkin.this.communicator.setRamdumpFlag(true);
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_RAM_DUMP, null, false);
                try {
                    RamdumpDialog ramdumpDialog = new RamdumpDialog(EmulatorSkin.this.shell, EmulatorSkin.this.communicator, EmulatorSkin.this.config);
                    ramdumpDialog.open();
                }
                catch (IOException ee) {
                    logger.log(Level.SEVERE, ee.getMessage(), ee);
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createScreenshotMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("ScreenShot Menu is selected");
                EmulatorSkin.this.openScreenShotWindow();
            }
        };
        return listener;
    }

    public SelectionAdapter createHostKbdMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.getSource();
                if (item.getSelection()) {
                    boolean on;
                    EmulatorSkin.this.isOnKbd = on = item.equals(((EmulatorSkin)EmulatorSkin.this).popupMenu.hostKbdOnItem);
                    logger.info("Select host keyboard : " + EmulatorSkin.this.isOnKbd);
                    EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HOST_KBD_STATE, new BooleanData(on, ICommunicator.SendCommand.SEND_HOST_KBD_STATE.toString()), false);
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createAboutMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Open the about dialog");
                AboutDialog dialog = new AboutDialog(EmulatorSkin.this.shell, EmulatorSkin.this.config, EmulatorSkin.this.imageRegistry);
                dialog.open();
            }
        };
        return listener;
    }

    public SelectionAdapter createForceCloseMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Force close menu is selected");
                int answer = SkinUtil.openMessage(EmulatorSkin.this.shell, null, "If you force stop an emulator, it may cause some problems.\nAre you sure you want to continue?", 292, EmulatorSkin.this.config);
                if (answer == 32) {
                    logger.info("force close!!!");
                    if (EmulatorSkin.this.communicator != null) {
                        EmulatorSkin.this.communicator.terminate();
                    }
                    EmulatorSkin.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            EmulatorSkinMain.terminateImmediately(-1);
                        }
                    });
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createShellMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Shell menu is selected");
                if (!EmulatorSkin.this.communicator.isSdbDaemonStarted()) {
                    logger.warning("SDB is not ready.");
                    SkinUtil.openMessage(EmulatorSkin.this.shell, null, "SDB is not ready.\nPlease wait until the emulator is completely boot up.", 8, EmulatorSkin.this.config);
                    return;
                }
                String sdbPath = SkinUtil.getSdbPath();
                File sdbFile = new File(sdbPath);
                if (!sdbFile.exists()) {
                    logger.info("SDB file does not exist : " + sdbFile.getAbsolutePath());
                    try {
                        SkinUtil.openMessage(EmulatorSkin.this.shell, null, "SDB file does not exist in the following path.\n" + sdbFile.getCanonicalPath(), 1, EmulatorSkin.this.config);
                    }
                    catch (IOException ee) {
                        logger.log(Level.SEVERE, ee.getMessage(), ee);
                    }
                    return;
                }
                int portSdb = EmulatorSkin.this.config.getArgInt("vm.baseport") + 1;
                ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
                if (SwtUtil.isWindowsPlatform()) {
                    procSdb.command("cmd.exe", "/c", "start", sdbPath, "sdb", "-s", "emulator-" + portSdb, "shell");
                } else if (SwtUtil.isMacPlatform()) {
                    procSdb.command("./sdbscript", sdbPath, "emulator-" + portSdb);
                } else {
                    String sdbCmd = "\"" + sdbPath + "\" -s emulator-" + portSdb + " shell";
                    procSdb.command("/usr/bin/gnome-terminal", "--disable-factory", "--title=" + SkinUtil.makeEmulatorName(EmulatorSkin.this.config), "-x", "bash", "-c", sdbCmd + "; kill -9 `ps -p $$ -o ppid=`");
                }
                logger.info(procSdb.command().toString());
                try {
                    procSdb.start();
                }
                catch (Exception ee) {
                    logger.log(Level.SEVERE, ee.getMessage(), ee);
                    SkinUtil.openMessage(EmulatorSkin.this.shell, null, "Fail to open Shell : \n" + ee.getMessage(), 1, EmulatorSkin.this.config);
                }
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_OPEN_SHELL, null, false);
            }
        };
        return listener;
    }

    public SelectionAdapter createEcpMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Control Panel menu is selected");
                String ecpPath = SkinUtil.getEcpPath();
                File ecpFile = new File(ecpPath);
                if (!ecpFile.exists()) {
                    logger.info("Control Panel file does not exist : " + ecpFile.getAbsolutePath());
                    try {
                        SkinUtil.openMessage(EmulatorSkin.this.shell, null, "Control Panel file does not exist in the following path.\n" + ecpFile.getCanonicalPath(), 1, EmulatorSkin.this.config);
                    }
                    catch (IOException ee) {
                        logger.log(Level.SEVERE, ee.getMessage(), ee);
                    }
                    return;
                }
                String emulName = SkinUtil.getVmName(EmulatorSkin.this.config);
                int basePort = EmulatorSkin.this.config.getArgInt("vm.baseport");
                String proxyAddr = EmulatorSkin.this.config.getArg("proxy.addr");
                String proxyPort = EmulatorSkin.this.config.getArg("proxy.port");
                ProcessBuilder procEcp = new ProcessBuilder(new String[0]);
                procEcp.redirectErrorStream(true);
                if (SwtUtil.isWindowsPlatform()) {
                    if (proxyAddr != null && proxyPort != null) {
                        procEcp.command("java.exe", "-Dhttp.proxyHost=" + proxyAddr, "-Dhttp.proxyPort=" + proxyPort, "-jar", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                    } else {
                        procEcp.command("java.exe", "-jar", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                    }
                } else if (SwtUtil.isMacPlatform()) {
                    if (proxyAddr != null && proxyPort != null) {
                        procEcp.command("java", "-Dhttp.proxyHost=" + proxyAddr, "-Dhttp.proxyPort=" + proxyPort, "-jar", "-XstartOnFirstThread", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                    } else {
                        procEcp.command("java", "-jar", "-XstartOnFirstThread", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                    }
                } else if (proxyAddr != null && proxyPort != null) {
                    procEcp.command("java", "-Dhttp.proxyHost=" + proxyAddr, "-Dhttp.proxyPort=" + proxyPort, "-jar", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                } else {
                    procEcp.command("java", "-jar", ecpPath, "vmname=" + emulName, "base.port=" + basePort);
                }
                logger.info(procEcp.command().toString());
                Process proc = null;
                try {
                    proc = procEcp.start();
                }
                catch (Exception ee) {
                    logger.log(Level.SEVERE, ee.getMessage(), ee);
                    SkinUtil.openMessage(EmulatorSkin.this.shell, null, "Fail to open control panel : \n" + ee.getMessage(), 1, EmulatorSkin.this.config);
                }
                if (proc != null) {
                    final InputStream in = proc.getInputStream();
                    final BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                while (br.readLine() != null) {
                                }
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                            finally {
                                IOUtil.close(in);
                            }
                        }
                    }).start();
                }
            }
        };
        return listener;
    }

    public SelectionAdapter createCloseMenuListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                logger.info("Close menu is selected");
                EmulatorSkin.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_CLOSE_REQ, null, false);
            }
        };
        return listener;
    }

    public void shutdown() {
        logger.info("shutdown the skin process");
        this.isShutdownRequested = true;
        if (!this.shell.isDisposed()) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!EmulatorSkin.this.shell.isDisposed()) {
                        EmulatorSkin.this.shell.close();
                    }
                }
            });
        }
    }

    public void keyForceRelease(boolean isMetaFilter) {
        if (this.isShutdownRequested) {
            return;
        }
        if (!this.pressedKeyEventList.isEmpty()) {
            for (KeyEventData data : this.pressedKeyEventList) {
                if (isMetaFilter && this.isMetaKey(data.keycode)) continue;
                this.keyReleasedDelivery(data.keycode, data.stateMask, data.keyLocation, false);
                logger.info("auto release : keycode=" + data.keycode + ", stateMask=" + data.stateMask + ", keyLocation=" + data.keyLocation);
            }
        }
        this.pressedKeyEventList.clear();
    }

    public static enum SkinBasicColor {
        BLUE(0, 174, 239),
        YELLOW(246, 226, 0),
        LIME(0, 246, 12),
        VIOLET(168, 43, 255),
        ORANGE(246, 110, 0),
        MAGENTA(245, 48, 233),
        PURPLE(94, 73, 255),
        GREEN(179, 246, 0),
        RED(245, 48, 48),
        CYON(29, 223, 221);

        private int channelRed;
        private int channelGreen;
        private int channelBlue;

        private SkinBasicColor(int r, int g, int b) {
            this.channelRed = r;
            this.channelGreen = g;
            this.channelBlue = b;
        }

        public RGB color() {
            return new RGB(this.channelRed, this.channelGreen, this.channelBlue);
        }
    }
}

