/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.comm;

import org.tizen.emulator.skin.comm.sock.data.ISendData;

public interface ICommunicator
extends Runnable {
    public static final short RECV_HEART_BEAT = 1;
    public static final short RECV_SCREENSHOT_DATA = 2;
    public static final short RECV_DETAIL_INFO_DATA = 3;
    public static final short RECV_RAMDUMP_COMPLETED = 4;
    public static final short RECV_BOOTING_PROGRESS = 5;
    public static final short RECV_DISPLAY_POWER = 6;
    public static final short RECV_HOST_KBD_STATE = 8;
    public static final short RECV_MULTI_TOUCH_STATE = 9;
    public static final short RECV_SDBD_STARTED = 801;
    public static final short RECV_DRAW_FRAME = 900;
    public static final short RECV_DRAW_BLANK_GUIDE = 901;
    public static final short RECV_EMUL_RESET = 998;
    public static final short RECV_EMUL_SHUTDOWN = 999;

    public void sendToQEMU(SendCommand var1, ISendData var2, boolean var3);

    public void terminate();

    public static enum SendCommand {
        SEND_SKIN_OPENED(1),
        SEND_SKIN_GRABBED(2),
        SEND_MOUSE_EVENT(10),
        SEND_KEYBOARD_KEY_EVENT(11),
        SEND_HW_KEY_EVENT(12),
        SEND_DISPLAY_STATE(13),
        SEND_OPEN_SHELL(14),
        SEND_HOST_KBD_STATE(15),
        SEND_SCREENSHOT_REQ(16),
        SEND_DETAIL_INFO_REQ(17),
        SEND_RAM_DUMP(18),
        SEND_GUEST_DUMP(19),
        SEND_INTERPOLATION_STATE(21),
        SEND_ROTARY_EVENT(30),
        RESPONSE_HEART_BEAT(900),
        RESPONSE_DRAW_FRAME(901),
        SEND_CLOSE_REQ(998),
        RESPONSE_SHUTDOWN(999);

        private short value;

        private SendCommand(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public static SendCommand getValue(String val) {
            SendCommand[] values = SendCommand.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != Short.parseShort(val)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(val);
        }

        public static SendCommand getValue(short val) {
            SendCommand[] values = SendCommand.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != val) continue;
                return values[i];
            }
            throw new IllegalArgumentException(Integer.toString(val));
        }
    }

    public static enum KeyEventType {
        PRESSED(1),
        RELEASED(2);

        private short value;

        private KeyEventType(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public static KeyEventType getValue(String val) {
            KeyEventType[] values = KeyEventType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != Integer.parseInt(val)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(val);
        }

        public static KeyEventType getValue(short val) {
            KeyEventType[] values = KeyEventType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != val) continue;
                return values[i];
            }
            throw new IllegalArgumentException(Integer.toString(val));
        }
    }

    public static enum MouseEventType {
        PRESS(1),
        RELEASE(2),
        DRAG(3),
        WHEELUP(4),
        WHEELDOWN(5),
        MOVE(6);

        private short value;

        private MouseEventType(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public static MouseEventType getValue(String val) {
            MouseEventType[] values = MouseEventType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != Integer.parseInt(val)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(val);
        }

        public static MouseEventType getValue(short val) {
            MouseEventType[] values = MouseEventType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != val) continue;
                return values[i];
            }
            throw new IllegalArgumentException(Integer.toString(val));
        }
    }

    public static enum MouseButtonType {
        LEFT(1),
        WHEEL(2),
        RIGHT(3);

        private short value;

        private MouseButtonType(short value) {
            this.value = value;
        }

        public short value() {
            return this.value;
        }

        public static MouseButtonType getValue(String val) {
            MouseButtonType[] values = MouseButtonType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != Integer.parseInt(val)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(val);
        }

        public static MouseButtonType getValue(short val) {
            MouseButtonType[] values = MouseButtonType.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != val) continue;
                return values[i];
            }
            throw new IllegalArgumentException(Integer.toString(val));
        }
    }
}

