/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.comm.sock;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SkinSendData;
import org.tizen.emulator.skin.comm.sock.data.BooleanData;
import org.tizen.emulator.skin.comm.sock.data.ISendData;
import org.tizen.emulator.skin.comm.sock.data.StartData;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class SocketCommunicator
implements ICommunicator {
    public static final int HEART_BEAT_INTERVAL = 1;
    public static final int HEART_BEAT_EXPIRE = 15;
    public static final int LONG_WAIT_INTERVAL = 3;
    public static final int LONG_WAIT_LIMIT = 3000;
    public static final int SHORT_WAIT_INTERVAL = 1;
    public static final int SHORT_WAIT_LIMIT = 2000;
    public static final int MAX_SEND_QUEUE_SIZE = 100000;
    private static int reqId;
    private Logger logger = SkinLogger.getSkinLogger(SocketCommunicator.class).getLogger();
    private EmulatorConfig config;
    private int uId;
    private StartData startData;
    private EmulatorSkin skin;
    private Socket socket;
    private DataInputStream sockInputStream;
    private DataOutputStream sockOutputStream;
    private AtomicInteger heartbeatCount;
    private boolean isTerminated;
    private boolean isSdbDaemonStarted;
    private boolean isRamdump;
    private TimerTask heartbeatExecutor;
    private Timer heartbeatTimer;
    private DataTranfer screenShotDataTransfer;
    private DataTranfer detailInfoTransfer;
    private DataTranfer miscDataTransfer;
    private Thread sendThread;
    private LinkedList<SkinSendData> sendQueue;
    private ByteArrayOutputStream bao;
    private DataOutputStream dataOutputStream;

    public SocketCommunicator(EmulatorConfig config, int uId, EmulatorSkin skin) {
        this.config = config;
        this.uId = uId;
        this.skin = skin;
        this.screenShotDataTransfer = new DataTranfer();
        this.screenShotDataTransfer.sleep = 3L;
        this.screenShotDataTransfer.maxWaitTime = 3000L;
        this.detailInfoTransfer = new DataTranfer();
        this.detailInfoTransfer.sleep = 1L;
        this.detailInfoTransfer.maxWaitTime = 2000L;
        this.miscDataTransfer = new DataTranfer();
        this.miscDataTransfer.sleep = 1L;
        this.miscDataTransfer.maxWaitTime = 2000L;
        this.heartbeatCount = new AtomicInteger(0);
        this.heartbeatTimer = new Timer();
        try {
            int port = config.getArgInt("vm.skinport");
            this.socket = new Socket("127.0.0.1", port);
            this.logger.info("socket.isConnected() : " + this.socket.isConnected());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            StringBuilder message = new StringBuilder("Error message: " + e.getMessage());
            if (SwtUtil.isMacPlatform()) {
                message.append(System.getProperty("line.separator")).append("Make sure that SOCKS proxy setting is correct.");
            }
            SkinUtil.openMessage(skin.getShell(), null, "Emulator UI fails to connect." + System.getProperty("line.separator") + message.toString(), 1, config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.bao = new ByteArrayOutputStream();
        this.dataOutputStream = new DataOutputStream(this.bao);
    }

    public void setInitialData(StartData data) {
        this.startData = data;
    }

    private void sendInitialData() {
        this.logger.info("send startData");
        this.sendToQEMU(ICommunicator.SendCommand.SEND_SKIN_OPENED, this.startData, false);
        this.skin.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BooleanData dataInterpolation = new BooleanData(((SocketCommunicator)SocketCommunicator.this).skin.isOnInterpolation, ICommunicator.SendCommand.SEND_INTERPOLATION_STATE.toString());
                SocketCommunicator.this.sendToQEMU(ICommunicator.SendCommand.SEND_INTERPOLATION_STATE, dataInterpolation, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.sendQueue = new LinkedList();
        this.sendThread = new Thread("sendThread"){
            List<SkinSendData> list;
            SkinSendData sendData;
            {
                this.list = new ArrayList<SkinSendData>();
                this.sendData = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    LinkedList linkedList = SocketCommunicator.this.sendQueue;
                    synchronized (linkedList) {
                        if (SocketCommunicator.this.sendQueue.isEmpty()) {
                            try {
                                SocketCommunicator.this.sendQueue.wait();
                            }
                            catch (InterruptedException e) {
                                SocketCommunicator.this.logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                        while (true) {
                            this.sendData = (SkinSendData)SocketCommunicator.this.sendQueue.poll();
                            if (null == this.sendData) break;
                            this.list.add(this.sendData);
                        }
                    }
                    if (SocketCommunicator.this.isTerminated) break;
                    for (SkinSendData data : this.list) {
                        SocketCommunicator.this.sendToQEMUInternal(data);
                    }
                    this.list.clear();
                }
                this.list.clear();
            }
        };
        try {
            this.sockInputStream = new DataInputStream(this.socket.getInputStream());
            this.sockOutputStream = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.terminate();
            return;
        }
        this.sendThread.setDaemon(true);
        this.sendThread.start();
        this.sendInitialData();
        boolean ignoreHeartbeat = this.config.getArgBoolean("hb.ignore");
        if (ignoreHeartbeat) {
            this.logger.info("Ignore Skin heartbeat.");
        } else {
            this.heartbeatExecutor = new TimerTask(){

                @Override
                public void run() {
                    SocketCommunicator.this.increaseHeartbeatCount();
                    if (SocketCommunicator.this.isHeartbeatExpired()) {
                        SocketCommunicator.this.logger.info("heartbeat was expired!");
                        SocketCommunicator.this.terminate();
                    }
                }
            };
            this.heartbeatTimer.schedule(this.heartbeatExecutor, 1L, 1000L);
        }
        PacketHeader header = new PacketHeader();
        block33: while (!this.isTerminated) {
            try {
                header.reqId = this.sockInputStream.readInt();
                header.cmd = this.sockInputStream.readShort();
                header.length = this.sockInputStream.readInt();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("[Socket] read - reqId:" + header.reqId + ", command:" + header.cmd + ", dataLength:" + header.length);
                }
                switch (header.cmd) {
                    case 1: {
                        this.resetHeartbeatCount();
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("received HEART_BEAT from QEMU");
                        }
                        this.sendToQEMU(ICommunicator.SendCommand.RESPONSE_HEART_BEAT, null, true);
                        break;
                    }
                    case 2: {
                        this.logger.info("received SCREENSHOT_DATA from QEMU");
                        this.receiveData(this.sockInputStream, this.screenShotDataTransfer, header.length);
                        break;
                    }
                    case 3: {
                        this.logger.info("received DETAIL_INFO_DATA from QEMU");
                        this.receiveData(this.sockInputStream, this.detailInfoTransfer, header.length);
                        break;
                    }
                    case 4: {
                        this.logger.info("received RAMDUMP_COMPLETED from QEMU");
                        this.setRamdumpFlag(false);
                        break;
                    }
                    case 5: {
                        this.resetDataTransfer(this.miscDataTransfer);
                        this.receiveData(this.sockInputStream, this.miscDataTransfer, header.length);
                        Object receivedData = this.getReceivedData(this.miscDataTransfer);
                        if (null == receivedData) continue block33;
                        String strLayer = new String((byte[])receivedData, 0, 1, "UTF-8");
                        String strValue = new String((byte[])receivedData, 1, header.length - 2, "UTF-8");
                        int layer = 0;
                        int value = 0;
                        try {
                            layer = Integer.parseInt(strLayer);
                            value = Integer.parseInt(strValue);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        this.skin.updateProgressBar(layer, value);
                        break;
                    }
                    case 6: {
                        this.resetDataTransfer(this.miscDataTransfer);
                        this.receiveData(this.sockInputStream, this.miscDataTransfer, header.length);
                        Object receivedData = this.getReceivedData(this.miscDataTransfer);
                        if (null == receivedData) continue block33;
                        String strValue = new String((byte[])receivedData, 0, header.length - 1, "UTF-8");
                        int value = 1;
                        try {
                            value = Integer.parseInt(strValue);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        if (value == 0) {
                            this.skin.updateDisplayPower(false);
                            break;
                        }
                        this.skin.updateDisplayPower(true);
                        break;
                    }
                    case 8: {
                        this.logger.info("received HOST_KBD_STATE from QEMU");
                        this.resetDataTransfer(this.miscDataTransfer);
                        this.receiveData(this.sockInputStream, this.miscDataTransfer, header.length);
                        Object receivedData = this.getReceivedData(this.miscDataTransfer);
                        if (null == receivedData) continue block33;
                        String strValue = new String((byte[])receivedData, 0, header.length - 1, "UTF-8");
                        int value = 1;
                        try {
                            value = Integer.parseInt(strValue);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        if (value == 0) {
                            this.skin.updateHostKbdMenu(false);
                            break;
                        }
                        this.skin.updateHostKbdMenu(true);
                        break;
                    }
                    case 9: {
                        this.logger.info("received MULTI_TOUCH_STATE from QEMU");
                        this.resetDataTransfer(this.miscDataTransfer);
                        this.receiveData(this.sockInputStream, this.miscDataTransfer, header.length);
                        Object receivedData = this.getReceivedData(this.miscDataTransfer);
                        if (null == receivedData) continue block33;
                        String strValue = new String((byte[])receivedData, 0, header.length - 1, "UTF-8");
                        int value = 1;
                        try {
                            value = Integer.parseInt(strValue);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                        if (value != 0) continue block33;
                    }
                    case 801: {
                        this.logger.info("received SDBD_STARTED from QEMU");
                        Object receivedData = this;
                        synchronized (receivedData) {
                            this.isSdbDaemonStarted = true;
                            break;
                        }
                    }
                    case 900: {
                        this.skin.updateDisplay();
                        break;
                    }
                    case 901: {
                        this.logger.info("received DRAW_BLANK_GUIDE from QEMU.");
                        SocketCommunicator imageGuide = this.skin.getImageRegistry().getResourceImage(ImageRegistry.ResourceImageName.RESOURCE_BLANK_GUIDE);
                        if (imageGuide == null) continue block33;
                        this.skin.setCoverImage((Image)imageGuide);
                        break;
                    }
                    case 998: {
                        this.logger.info("received EMUL_RESET from QEMU");
                        SocketCommunicator imageGuide = this;
                        synchronized (imageGuide) {
                            this.isSdbDaemonStarted = false;
                            break;
                        }
                    }
                    case 999: {
                        this.logger.info("received EMUL_SHUTDOWN from QEMU");
                        this.sendToQEMU(ICommunicator.SendCommand.RESPONSE_SHUTDOWN, null, false);
                        this.terminate();
                        break;
                    }
                    default: {
                        this.logger.severe("Unknown command from QEMU. command : " + header.cmd);
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                break;
            }
        }
        this.logger.info("communicatorThread is stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveData(DataInputStream is, DataTranfer dataTransfer, int length) throws IOException {
        DataTranfer dataTranfer = dataTransfer;
        synchronized (dataTranfer) {
            byte[] data;
            if (null != dataTransfer.timer) {
                dataTransfer.timer.cancel();
            }
            if (null != (data = this.readData(is, length))) {
                this.logger.info("finished receiving data from QEMU.");
            } else {
                this.logger.severe("Fail to receiving data from QEMU.");
            }
            dataTransfer.isTransferState = false;
            dataTransfer.timer = null;
            dataTransfer.setData(data);
            dataTransfer.notifyAll();
        }
    }

    private byte[] readData(DataInputStream is, int length) throws IOException {
        if (0 >= length) {
            return null;
        }
        byte[] data = new byte[length];
        is.readFully(data, 0, length);
        this.logger.info("finished reading stream. read : " + length);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTranfer resetDataTransfer(final DataTranfer dataTransfer) {
        DataTranfer dataTranfer = dataTransfer;
        synchronized (dataTranfer) {
            if (dataTransfer.isTransferState) {
                this.logger.severe("Already transter state for getting data.");
                return null;
            }
            dataTransfer.isTransferState = true;
            Timer timer = new Timer();
            dataTransfer.timer = timer;
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataTranfer dataTranfer = dataTransfer;
                    synchronized (dataTranfer) {
                        dataTransfer.isTransferState = false;
                        dataTransfer.timer = null;
                        DataTranfer.access$1402(dataTransfer, null);
                    }
                }
            };
            timer.schedule(timerTask, dataTransfer.maxWaitTime + 1000L);
            return dataTransfer;
        }
    }

    public synchronized DataTranfer sendDataToQEMU(ICommunicator.SendCommand command, ISendData data, boolean useDataTransfer) {
        DataTranfer dataTranfer = null;
        if (useDataTransfer) {
            if (ICommunicator.SendCommand.SEND_SCREENSHOT_REQ.equals((Object)command)) {
                dataTranfer = this.resetDataTransfer(this.screenShotDataTransfer);
            } else if (ICommunicator.SendCommand.SEND_DETAIL_INFO_REQ.equals((Object)command)) {
                dataTranfer = this.resetDataTransfer(this.detailInfoTransfer);
            }
        }
        this.sendToQEMU(command, data, false);
        return dataTranfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToQEMU(ICommunicator.SendCommand command, ISendData data, boolean urgent) {
        LinkedList<SkinSendData> linkedList = this.sendQueue;
        synchronized (linkedList) {
            if (100000 < this.sendQueue.size()) {
                this.logger.warning("Send queue size exceeded max value, do not push data into send queue.");
            } else {
                if (urgent) {
                    this.sendQueue.addFirst(new SkinSendData(command, data));
                } else {
                    this.sendQueue.add(new SkinSendData(command, data));
                }
                this.sendQueue.notifyAll();
            }
        }
    }

    private void sendToQEMUInternal(SkinSendData sendData) {
        if (null == sendData) {
            return;
        }
        ICommunicator.SendCommand command = sendData.getCommand();
        ISendData data = sendData.getSendData();
        reqId = Integer.MAX_VALUE == reqId ? 0 : (reqId = reqId + 1);
        try {
            this.dataOutputStream.writeInt(this.uId);
            this.dataOutputStream.writeInt(reqId);
            this.dataOutputStream.writeShort(command.value());
            int length = 0;
            if (null == data) {
                length = 0;
                this.dataOutputStream.writeShort(length);
            } else {
                byte[] byteData = data.serialize();
                length = (short)byteData.length;
                this.dataOutputStream.writeShort(length);
                this.dataOutputStream.write(byteData);
            }
            this.dataOutputStream.flush();
            this.sockOutputStream.write(this.bao.toByteArray());
            this.sockOutputStream.flush();
            this.bao.reset();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("[Socket] write - uid:" + this.uId + ", reqId:" + reqId + ", command:" + command.value() + " - " + command.toString() + ", length:" + length);
            }
            if (0 < length && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("[Socket] data  - " + data.toString());
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getReceivedData(DataTranfer dataTranfer) {
        if (null == dataTranfer) {
            return null;
        }
        DataTranfer dataTranfer2 = dataTranfer;
        synchronized (dataTranfer2) {
            int count = 0;
            byte[] receivedData = null;
            long sleep = dataTranfer.sleep;
            long maxWaitTime = dataTranfer.maxWaitTime;
            int limitCount = (int)(maxWaitTime / sleep);
            while (dataTranfer.isTransferState) {
                if (limitCount < count) {
                    this.logger.severe("time out for receiving data from skin server.");
                    DataTranfer.access$1402(dataTranfer, null);
                    break;
                }
                try {
                    dataTranfer.wait(sleep);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
                this.logger.info("wait data... count : " + ++count);
            }
            receivedData = dataTranfer.receivedData;
            DataTranfer.access$1402(dataTranfer, null);
            return receivedData;
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized boolean isSdbDaemonStarted() {
        return this.isSdbDaemonStarted;
    }

    public synchronized void setRamdumpFlag(boolean flag) {
        this.isRamdump = flag;
    }

    public synchronized boolean getRamdumpFlag() {
        return this.isRamdump;
    }

    private void increaseHeartbeatCount() {
        int count = this.heartbeatCount.incrementAndGet();
        if (count > 1) {
            this.logger.info("HB count : " + count);
        }
    }

    private boolean isHeartbeatExpired() {
        return 15 < this.heartbeatCount.get();
    }

    private void resetHeartbeatCount() {
        this.heartbeatCount.set(0);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.info("HB count reset");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        if (this.isTerminated) {
            this.logger.info("has been terminated");
            return;
        }
        this.logger.info("terminated");
        this.isTerminated = true;
        Object object = this.sendQueue;
        synchronized (object) {
            this.sendQueue.notifyAll();
        }
        if (null != this.heartbeatTimer) {
            this.heartbeatTimer.cancel();
            this.heartbeatTimer = null;
        }
        IOUtil.closeSocket(this.socket);
        IOUtil.close(this.sockInputStream);
        IOUtil.close(this.sockOutputStream);
        IOUtil.close(this.bao);
        IOUtil.close(this.dataOutputStream);
        object = this;
        synchronized (object) {
            this.skin.shutdown();
        }
    }

    public static class DataTranfer {
        private boolean isTransferState;
        private byte[] receivedData;
        private long sleep;
        private long maxWaitTime;
        private Timer timer;

        private DataTranfer() {
        }

        private void setData(byte[] data) {
            this.receivedData = data;
            this.isTransferState = false;
        }

        static /* synthetic */ byte[] access$1402(DataTranfer x0, byte[] x1) {
            x0.receivedData = x1;
            return x1;
        }
    }

    private static class PacketHeader {
        int reqId;
        short cmd;
        int length;

        private PacketHeader() {
        }
    }
}

