/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.dialog;

import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.StringUtil;

public abstract class SkinDialog
extends Dialog {
    public static final String OK = "        OK        ";
    private Logger logger = SkinLogger.getSkinLogger(SkinDialog.class).getLogger();
    protected Shell shell;
    protected Composite buttonComposite;
    private Shell parent;
    private int style;
    private String title;
    private boolean hasButton;

    public SkinDialog(Shell parent, int style, String title) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.title = title;
        this.hasButton = true;
    }

    public SkinDialog(Shell parent, int style, String title, boolean hasButton) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.title = title;
        this.hasButton = hasButton;
    }

    protected void createComposite() {
        Composite parent = new Composite((Composite)this.shell, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 20;
        parent.setLayout((Layout)gridLayout);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout(512));
        Composite area = this.createArea(composite);
        if (null == area) {
            return;
        }
        if (this.hasButton) {
            this.buttonComposite = new Composite(parent, 0);
            this.buttonComposite.setLayoutData((Object)new GridData(131072, 1024, true, true));
            this.buttonComposite.setLayout((Layout)new GridLayout(1, false));
            this.createButtons(this.buttonComposite);
        }
    }

    public void open() {
        this.shell = new Shell(this.parent, this.style);
        this.shell.setText(this.title);
        this.shell.setImage(this.parent.getImage());
        this.shell.setLayout((Layout)new GridLayout(1, true));
        this.createComposite();
        this.shell.pack();
        this.setShellSize();
        if (this.parent != null) {
            Point central = new Point(this.parent.getLocation().x + this.parent.getSize().x / 2, this.parent.getLocation().y + this.parent.getSize().y / 2);
            int width = this.shell.getSize().x;
            int height = this.shell.getSize().y;
            int x = central.x - width / 2;
            int y = central.y - height / 2;
            Rectangle monitorBounds = Display.getDefault().getBounds();
            if (x < monitorBounds.x) {
                x = monitorBounds.x;
            } else if (x + width > monitorBounds.x + monitorBounds.width) {
                x = monitorBounds.x + monitorBounds.width - width;
            }
            if (y < monitorBounds.y) {
                y = monitorBounds.y;
            } else if (y + height > monitorBounds.y + monitorBounds.height) {
                y = monitorBounds.y + monitorBounds.height - height;
            }
            this.shell.setLocation(x, y);
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.close();
    }

    protected void close() {
        this.logger.info("closed");
    }

    protected void setShellSize() {
    }

    protected abstract Composite createArea(Composite var1);

    protected void createButtons(Composite parent) {
        if (null == parent) {
            throw new IllegalArgumentException("button composite is null");
        }
    }

    protected Button createButton(Composite parent, String text) {
        if (null == parent) {
            throw new IllegalArgumentException("button composite is null");
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 8);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
        button.setText(StringUtil.nvl(text));
        return button;
    }

    protected Button createOKButton(Composite parent, boolean setFocus) {
        this.logger.info("create OK button");
        Button okButton = this.createButton(parent, OK);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SkinDialog.this.shell.close();
            }
        });
        if (setFocus) {
            okButton.setFocus();
        }
        return okButton;
    }
}

