/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.DisplayCanvas;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.EmulatorSkinMain;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.custom.ColorTag;
import org.tizen.emulator.skin.custom.CustomButton;
import org.tizen.emulator.skin.custom.SkinWindow;
import org.tizen.emulator.skin.dbi.KeyMapType;
import org.tizen.emulator.skin.image.GeneralSkinImageRegistry;
import org.tizen.emulator.skin.image.ImageRegistry;
import org.tizen.emulator.skin.info.EmulatorSkinState;
import org.tizen.emulator.skin.layout.ISkinComposer;
import org.tizen.emulator.skin.layout.SkinPatches;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.menu.PopupMenu;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class GeneralPurposeSkinComposer
implements ISkinComposer {
    private static final int PAIR_TAG_POSITION_X = 26;
    private static final int PAIR_TAG_POSITION_Y = 13;
    private Logger logger = SkinLogger.getSkinLogger(GeneralPurposeSkinComposer.class).getLogger();
    private EmulatorConfig config;
    private EmulatorSkin skin;
    private Shell shell;
    private DisplayCanvas displayCanvas;
    private Color backgroundColor;
    private CustomButton toggleButton;
    private ColorTag pairTag;
    private EmulatorSkinState currentState;
    private SkinPatches frameMaker;
    private PaintListener shellPaintListener;
    private MouseMoveListener shellMouseMoveListener;
    private MouseListener shellMouseListener;
    private GeneralSkinImageRegistry imageRegistry;

    public GeneralPurposeSkinComposer(EmulatorConfig config, EmulatorSkin skin) {
        this.config = config;
        this.skin = skin;
        this.shell = skin.getShell();
        this.currentState = skin.getEmulatorSkinState();
        this.imageRegistry = new GeneralSkinImageRegistry(this.shell.getDisplay());
        this.frameMaker = new SkinPatches(this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_LT), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_T), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_RT), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_L), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_R), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_LB), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_B), this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.SKIN_PATCH_RB));
        this.backgroundColor = new Color((Device)this.shell.getDisplay(), new RGB(38, 38, 38));
    }

    @Override
    public DisplayCanvas compose(int style) {
        this.shell.setBackground(this.backgroundColor);
        this.displayCanvas = new DisplayCanvas(this.shell, style);
        int x = this.config.getValidWindowX();
        int y = this.config.getValidWindowY();
        int scale = this.currentState.getCurrentScale();
        short rotationId = this.currentState.getCurrentRotationId();
        this.composeInternal(this.displayCanvas, x, y, scale, rotationId);
        this.logger.info("resolution : " + this.currentState.getCurrentResolution() + ", scale : " + scale);
        return this.displayCanvas;
    }

    @Override
    public void composeInternal(DisplayCanvas displayCanvas, int x, int y, int scale, short rotationId) {
        this.shell.setLocation(x, y);
        String emulatorName = SkinUtil.makeEmulatorName(this.config);
        this.shell.setText("Emulator - " + emulatorName);
        displayCanvas.setBackground(this.shell.getDisplay().getSystemColor(2));
        this.shell.setImage(this.skin.getImageRegistry().getIcon(ImageRegistry.IconName.EMULATOR_ICON));
        List<KeyMapType> keyMapList = SkinUtil.getHWKeyMapList(this.skin.getEmulatorSkinState().getCurrentRotationId());
        if (keyMapList != null && !keyMapList.isEmpty()) {
            this.toggleButton = this.createToggleButton();
            this.toggleButton.setBackground(this.backgroundColor);
        }
        this.pairTag = new ColorTag(this.shell, 524288, this.skin.getColorVM());
        this.pairTag.setVisible(false);
        this.arrangeSkin(scale, rotationId);
        if (this.currentState.getCurrentImage() == null) {
            this.logger.severe("Failed to load initial skin image. Kill this skin process.");
            SkinUtil.openMessage(this.shell, null, "Failed to load Skin image file.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.addListeners();
        PopupMenu popupMenu = this.skin.getPopupMenu();
        if (popupMenu != null && popupMenu.keyWindowItem != null) {
            final int dockValue = this.config.getSkinPropertyInt("window.keywindow.position", 0);
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (dockValue == 0) {
                        GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().openKeyWindow(0x1020000, false);
                    } else {
                        GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().openKeyWindow(dockValue, false);
                    }
                }
            });
        }
    }

    @Override
    public void arrangeSkin(int scale, short rotationId) {
        Rectangle displayBounds = this.adjustDisplayGeometry(this.displayCanvas, this.currentState.getCurrentResolutionWidth(), this.currentState.getCurrentResolutionHeight(), scale, rotationId);
        if (displayBounds == null) {
            this.logger.severe("Failed to read display information for skin.");
            SkinUtil.openMessage(this.shell, null, "Failed to read display information for skin.\nCheck the contents of skin dbi file.", 1, this.config);
            EmulatorSkinMain.terminateImmediately(-1);
        }
        this.logger.info("display bounds : " + displayBounds);
        Image generalSkin = this.frameMaker.getPatchedImage(displayBounds.width, displayBounds.height);
        Region region = !SwtUtil.isLinuxPlatform() ? GeneralPurposeSkinComposer.getTrimmedRegion(generalSkin) : SkinUtil.getTrimmedRegion(generalSkin);
        this.currentState.setCurrentScale(scale);
        this.currentState.setCurrentRotationId(rotationId);
        this.currentState.setDisplayBounds(displayBounds);
        Image tempImage = null;
        if (this.currentState.getCurrentImage() != null) {
            tempImage = this.currentState.getCurrentImage();
        }
        this.currentState.setCurrentImage(generalSkin);
        if (tempImage != null) {
            tempImage.dispose();
        }
        this.displayCanvas.setBounds(displayBounds);
        if (this.toggleButton != null) {
            int centerY = (displayBounds.height - this.toggleButton.getImageSize().y) / 2;
            this.toggleButton.setBounds(displayBounds.x + displayBounds.width + 4, displayBounds.y + centerY, this.toggleButton.getImageSize().x, this.toggleButton.getImageSize().y);
        }
        if (this.currentState.getCurrentImage() != null) {
            ImageData imageData = this.currentState.getCurrentImage().getImageData();
            this.shell.setSize(imageData.width, imageData.height);
        }
        if (rotationId == 0) {
            this.pairTag.setBounds(26, 13, this.pairTag.getWidth(), this.pairTag.getHeight());
        } else if (rotationId == 1) {
            this.pairTag.setBounds(13, this.shell.getSize().y - 26 - this.pairTag.getHeight(), this.pairTag.getWidth(), this.pairTag.getHeight());
        } else if (rotationId == 2) {
            this.pairTag.setBounds(this.shell.getSize().x - 26 - this.pairTag.getWidth(), this.shell.getSize().y - 13 - this.pairTag.getHeight(), this.pairTag.getWidth(), this.pairTag.getHeight());
        } else if (rotationId == 3) {
            this.pairTag.setBounds(this.shell.getSize().x - 13 - this.pairTag.getWidth(), 26, this.pairTag.getWidth(), this.pairTag.getHeight());
        }
        if (region != null) {
            this.shell.setRegion(region);
        }
        this.currentState.setNeedToUpdateDisplay(true);
        this.shell.redraw();
    }

    @Override
    public Rectangle adjustDisplayGeometry(Canvas displayCanvas, int resolutionW, int resolutionH, int scale, short rotationId) {
        Rectangle displayBounds = new Rectangle(this.frameMaker.getPatchWidth(), this.frameMaker.getPatchHeight(), 0, 0);
        float convertedScale = SkinUtil.convertScale(scale);
        if (1 == rotationId || 3 == rotationId) {
            displayBounds.width = (int)((float)resolutionH * convertedScale);
            displayBounds.height = (int)((float)resolutionW * convertedScale);
        } else {
            displayBounds.width = (int)((float)resolutionW * convertedScale);
            displayBounds.height = (int)((float)resolutionH * convertedScale);
        }
        return displayBounds;
    }

    private static Region getTrimmedRegion(Image image) {
        if (null == image) {
            return null;
        }
        ImageData imageData = image.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        Region region = new Region();
        region.add(new Rectangle(0, 0, width, height));
        Display display = Display.getDefault();
        int r = display.getSystemColor(11).getRed();
        int g = display.getSystemColor(11).getGreen();
        int b = display.getSystemColor(11).getBlue();
        int colorKey = 0;
        colorKey = SwtUtil.isWindowsPlatform() ? r << 24 | g << 16 | b << 8 : r << 16 | g << 8 | b;
        int j = 0;
        for (int i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                int colorPixel = imageData.getPixel(i, j);
                if (colorPixel != colorKey) continue;
                region.subtract(i, j, 1, 1);
            }
        }
        return region;
    }

    @Override
    public void updateSkin() {
        this.logger.info("update skin");
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GeneralPurposeSkinComposer.this.pairTag != null && !GeneralPurposeSkinComposer.this.pairTag.isDisposed()) {
                    SkinWindow keyWindow = GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().getKeyWindow();
                    if (keyWindow != null && keyWindow.getShell().isVisible()) {
                        GeneralPurposeSkinComposer.this.pairTag.setVisible(true);
                    } else {
                        GeneralPurposeSkinComposer.this.pairTag.setVisible(false);
                    }
                }
            }
        });
    }

    private CustomButton createToggleButton() {
        Image imageNormal = this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.TOGGLE_BUTTON_NORMAL);
        Image imageHover = this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.TOGGLE_BUTTON_HOVER);
        Image imagePushed = this.imageRegistry.getSkinImage(GeneralSkinImageRegistry.GeneralSkinImageName.TOGGLE_BUTTON_PUSHED);
        CustomButton toggle = new CustomButton((Composite)this.shell, 524289, imageNormal, imageHover, imagePushed);
        toggle.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).skin.isKeyWindow) {
                    GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().closeKeyWindow();
                    GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().setRecentlyDocked(0x1020000);
                } else {
                    GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().openKeyWindow(0x1020000, true);
                }
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return toggle;
    }

    private void addListeners() {
        this.shellPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (GeneralPurposeSkinComposer.this.currentState.isNeedToUpdateDisplay()) {
                    GeneralPurposeSkinComposer.this.currentState.setNeedToUpdateDisplay(false);
                    GeneralPurposeSkinComposer.this.logger.info("shell transform was changed");
                    GeneralPurposeSkinComposer.this.skin.setSuitableTransform();
                }
                if (GeneralPurposeSkinComposer.this.currentState.getCurrentImage() != null) {
                    ImageData imageData = GeneralPurposeSkinComposer.this.currentState.getCurrentImage().getImageData();
                    if (((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getSize().x != imageData.width || ((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getSize().y != imageData.height) {
                        GeneralPurposeSkinComposer.this.shell.setSize(imageData.width, imageData.height);
                    }
                }
                if (SwtUtil.isLinuxPlatform() && GeneralPurposeSkinComposer.this.shell.getRegion() != null && ((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getRegion().getBounds().x == e.x && ((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getRegion().getBounds().y == e.y && ((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getRegion().getBounds().width == e.width && ((GeneralPurposeSkinComposer)GeneralPurposeSkinComposer.this).shell.getRegion().getBounds().height == e.height) {
                    GeneralPurposeSkinComposer.this.logger.info("shell re-painting is required");
                    GeneralPurposeSkinComposer.this.skin.updateDisplay();
                }
                if (GeneralPurposeSkinComposer.this.currentState.getCurrentImage() != null) {
                    e.gc.drawImage(GeneralPurposeSkinComposer.this.currentState.getCurrentImage(), 0, 0);
                }
                GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().redock(false, false);
            }
        };
        this.shell.addPaintListener(this.shellPaintListener);
        this.shellMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (GeneralPurposeSkinComposer.this.skin.isShellGrabbing() && e.button == 0) {
                    Point previousLocation = GeneralPurposeSkinComposer.this.shell.getLocation();
                    Point grabLocation = GeneralPurposeSkinComposer.this.skin.getGrabPosition();
                    if (grabLocation != null) {
                        int x = previousLocation.x + (e.x - grabLocation.x);
                        int y = previousLocation.y + (e.y - grabLocation.y);
                        GeneralPurposeSkinComposer.this.shell.setLocation(x, y);
                    }
                    GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().redock(false, false);
                }
            }
        };
        this.shell.addMouseMoveListener(this.shellMouseMoveListener);
        this.shellMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    GeneralPurposeSkinComposer.this.logger.info("mouseUp in Skin");
                    GeneralPurposeSkinComposer.this.skin.ungrabShell();
                    GeneralPurposeSkinComposer.this.skin.getKeyWindowKeeper().redock(false, true);
                }
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    GeneralPurposeSkinComposer.this.logger.info("mouseDown in Skin");
                    GeneralPurposeSkinComposer.this.skin.grabShell(e.x, e.y);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.shell.addMouseListener(this.shellMouseListener);
    }

    @Override
    public void composerFinalize() {
        if (null != this.shellPaintListener) {
            this.shell.removePaintListener(this.shellPaintListener);
        }
        if (null != this.shellMouseMoveListener) {
            this.shell.removeMouseMoveListener(this.shellMouseMoveListener);
        }
        if (null != this.shellMouseListener) {
            this.shell.removeMouseListener(this.shellMouseListener);
        }
        if (this.toggleButton != null) {
            this.toggleButton.dispose();
        }
        if (this.pairTag != null) {
            this.pairTag.dispose();
            this.pairTag = null;
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        this.imageRegistry.dispose();
    }
}

