/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.layout;

import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.config.EmulatorConfig;
import org.tizen.emulator.skin.layout.ProfileSpecificSkinComposer;
import org.tizen.emulator.skin.layout.Rotary;
import org.tizen.emulator.skin.log.SkinLogger;
import org.tizen.emulator.skin.util.SkinUtil;

public class ProfileRotarySkinComposer
extends ProfileSpecificSkinComposer {
    private Logger logger = SkinLogger.getSkinLogger(ProfileRotarySkinComposer.class).getLogger();
    protected Rotary rotary = new Rotary(this.shell, 0x20000000, this.imageRegistry, this.communicator);

    public ProfileRotarySkinComposer(EmulatorConfig config, EmulatorSkin skin) {
        super(config, skin);
    }

    @Override
    public void arrangeSkin(final int scale, final short rotationId) {
        super.arrangeSkin(scale, rotationId);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ProfileRotarySkinComposer.this.logger.info("arrange a rotary");
                ProfileRotarySkinComposer.this.rotary.arrange(scale, rotationId);
                Image rotaryImage = ProfileRotarySkinComposer.this.rotary.getImage();
                if (rotaryImage != null) {
                    int rotaryW = rotaryImage.getImageData().width;
                    int rotaryH = rotaryImage.getImageData().height;
                    Rectangle displayBounds = ProfileRotarySkinComposer.this.currentState.getDisplayBounds();
                    int offsetX = (rotaryW - displayBounds.width) / 2;
                    int offsetY = (rotaryH - displayBounds.height) / 2;
                    ProfileRotarySkinComposer.this.rotary.setBounds(displayBounds.x - offsetX, displayBounds.y - offsetY, rotaryW, rotaryH);
                    Region rotaryRegion = SkinUtil.getTrimmedRegion(rotaryImage);
                    Region displayRegion = ProfileRotarySkinComposer.this.displayCanvas.getRegion();
                    displayRegion.translate(offsetX, offsetY);
                    rotaryRegion.subtract(displayRegion);
                    ProfileRotarySkinComposer.this.rotary.setRegion(rotaryRegion);
                } else {
                    ProfileRotarySkinComposer.this.logger.warning("undefined rotary");
                    ProfileRotarySkinComposer.this.rotary.setBounds(0, 0, 0, 0);
                    ProfileRotarySkinComposer.this.rotary.setRegion(null);
                }
            }
        });
    }
}

