/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.menu;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.emulator.skin.EmulatorSkin;
import org.tizen.emulator.skin.comm.ICommunicator;
import org.tizen.emulator.skin.comm.sock.SocketCommunicator;
import org.tizen.emulator.skin.comm.sock.data.KeyEventData;
import org.tizen.emulator.skin.comm.sock.data.MouseEventData;
import org.tizen.emulator.skin.custom.SkinWindow;
import org.tizen.emulator.skin.exception.JaxbException;
import org.tizen.emulator.skin.image.SpecialKeyWindowImageRegistry;
import org.tizen.emulator.skin.keywindow.dbi.EventInfoType;
import org.tizen.emulator.skin.keywindow.dbi.KeyMapType;
import org.tizen.emulator.skin.keywindow.dbi.KeyWindowUI;
import org.tizen.emulator.skin.keywindow.dbi.RegionType;
import org.tizen.emulator.skin.layout.HWKey;
import org.tizen.emulator.skin.layout.HWKeyRegion;
import org.tizen.emulator.skin.util.IOUtil;
import org.tizen.emulator.skin.util.JaxbUtil;
import org.tizen.emulator.skin.util.SkinUtil;
import org.tizen.emulator.skin.util.SwtUtil;

public class SpecialKeyWindow
extends SkinWindow {
    public static final String KEYWINDOW_LAYOUT_ROOT = "keywindow-layout";
    public static final String DBI_FILE_NAME = "default.dbi";
    private SpecialKeyWindowImageRegistry imageRegistry;
    private SocketCommunicator communicator;
    private KeyWindowUI dbiContents;
    private Image keyWindowImage;
    private Image keyWindowPressedImage;
    private ShellListener shellListener;
    private PaintListener shellPaintListener;
    private MouseMoveListener shellMouseMoveListener;
    private MouseListener shellMouseListener;
    private boolean isGrabbedShell;
    private Point grabPosition;
    private HWKey currentPressedHWKey;
    private boolean isTouch;

    public SpecialKeyWindow(EmulatorSkin skin, String layoutName) {
        super(skin.getShell(), 0x1020000);
        this.parent = skin.getShell();
        this.shell = new Shell(this.parent.getDisplay(), 524316);
        this.communicator = skin.communicator;
        this.isGrabbedShell = false;
        this.grabPosition = new Point(0, 0);
        this.shell.setText(this.parent.getText());
        this.shell.setBackground(this.parent.getBackground());
        this.shell.setImage(this.parent.getImage());
        String skinPath = skin.skinInfo.getSkinPath();
        String specialKeyWindowPath = skinPath + File.separator + KEYWINDOW_LAYOUT_ROOT + File.separator + layoutName;
        this.logger.info("special key window path : " + specialKeyWindowPath);
        this.dbiContents = this.loadXMLForKeyWindow(specialKeyWindowPath);
        this.imageRegistry = new SpecialKeyWindowImageRegistry(this.shell.getDisplay(), this.dbiContents, specialKeyWindowPath);
        this.keyWindowImage = this.imageRegistry.getKeyWindowImage((short)0, SpecialKeyWindowImageRegistry.SpecailKeyWindowImageType.SPECIAL_IMAGE_TYPE_NORMAL);
        this.keyWindowPressedImage = this.imageRegistry.getKeyWindowImage((short)0, SpecialKeyWindowImageRegistry.SpecailKeyWindowImageType.SPECIAL_IMAGE_TYPE_PRESSED);
        if (this.keyWindowImage != null) {
            ImageData imageData = this.keyWindowImage.getImageData();
            this.shell.setSize(imageData.width, imageData.height);
        }
        this.trimWindow();
        this.addKeyWindowListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private KeyWindowUI loadXMLForKeyWindow(String skinPath) {
        String dbiPath = skinPath + File.separator + DBI_FILE_NAME;
        this.logger.info("load dbi file from " + dbiPath);
        FileInputStream fis = null;
        KeyWindowUI keyWindowUI = null;
        try {
            fis = new FileInputStream(dbiPath);
            this.logger.info("============ dbi contents ============");
            byte[] bytes = IOUtil.getBytes(fis);
            this.logger.info(new String(bytes, "UTF-8"));
            this.logger.info("=======================================");
            keyWindowUI = JaxbUtil.unmarshal(bytes, KeyWindowUI.class);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            IOUtil.close(fis);
        }
        catch (JaxbException e2) {
            this.logger.log(Level.SEVERE, e2.getMessage(), e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(fis);
                    throw throwable;
                }
            }
            IOUtil.close(fis);
        }
        IOUtil.close(fis);
        return keyWindowUI;
    }

    private HWKey getHWKey(int currentX, int currentY) {
        List<KeyMapType> keyMapList = this.dbiContents.getKeyMapList().getKeyMap();
        if (keyMapList == null) {
            return null;
        }
        for (KeyMapType keyEntry : keyMapList) {
            int scaledHeight;
            int scaledWidth;
            int scaledY;
            RegionType region = keyEntry.getRegion();
            int scaledX = region.getLeft();
            if (!SkinUtil.isInGeometry(currentX, currentY, scaledX, scaledY = region.getTop().intValue(), scaledWidth = region.getWidth().intValue(), scaledHeight = region.getHeight().intValue())) continue;
            EventInfoType eventInfo = keyEntry.getEventInfo();
            HWKey hwKey = new HWKey(eventInfo.getKeyName(), eventInfo.getKeyCode(), new HWKeyRegion(scaledX, scaledY, scaledWidth, scaledHeight), keyEntry.getTooltip());
            return hwKey;
        }
        return null;
    }

    protected void trimWindow() {
        Region region = SkinUtil.getTrimmedRegion(this.keyWindowImage);
        if (region != null) {
            this.shell.setRegion(region);
        }
    }

    private void addKeyWindowListener() {
        this.shellPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SpecialKeyWindow.this.keyWindowImage != null) {
                    e.gc.drawImage(SpecialKeyWindow.this.keyWindowImage, 0, 0);
                }
            }
        };
        this.shell.addPaintListener(this.shellPaintListener);
        this.shellListener = new ShellListener(){

            public void shellClosed(ShellEvent event) {
                SpecialKeyWindow.this.logger.info("Special Key Window is closed");
                SpecialKeyWindow.this.dispose();
            }

            public void shellActivated(ShellEvent event) {
                SpecialKeyWindow.this.logger.info("activate");
                if (SwtUtil.isMacPlatform()) {
                    if (!SpecialKeyWindow.this.parent.isDisposed()) {
                        SpecialKeyWindow.this.parent.moveAbove((Control)SpecialKeyWindow.this.shell);
                    }
                } else {
                    SpecialKeyWindow.this.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SpecialKeyWindow.this.parent.setActive();
                        }
                    });
                }
            }

            public void shellDeactivated(ShellEvent event) {
                SpecialKeyWindow.this.logger.info("deactivate");
            }

            public void shellIconified(ShellEvent event) {
            }

            public void shellDeiconified(ShellEvent event) {
                SpecialKeyWindow.this.logger.info("deiconified");
                SpecialKeyWindow.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SpecialKeyWindow.this.parent.getMinimized()) {
                            SpecialKeyWindow.this.parent.setMinimized(false);
                        }
                    }
                });
            }
        };
        this.shell.addShellListener(this.shellListener);
        this.shellMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SpecialKeyWindow.this.isTouch) {
                    SpecialKeyWindow.this.logger.info("mouseMove in KeyWindow : " + e.x + ", " + e.y);
                    HWKey pressedHWKey = SpecialKeyWindow.this.currentPressedHWKey;
                    int x = pressedHWKey.getRegion().x;
                    int y = pressedHWKey.getRegion().y;
                    int width = pressedHWKey.getRegion().width;
                    int height = pressedHWKey.getRegion().height;
                    if (!SkinUtil.isInGeometry(e.x, e.y, x, y, width, height)) {
                        SpecialKeyWindow.this.isTouch = false;
                        SpecialKeyWindow.this.shell.redraw(x, y, width, height, false);
                    }
                    MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.DRAG.value(), e.x, e.y, e.x, e.y, 0);
                    SpecialKeyWindow.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                    return;
                }
                if (SpecialKeyWindow.this.isGrabbedShell && e.button == 0) {
                    if (SpecialKeyWindow.this.getDockPosition() != 0) {
                        SpecialKeyWindow.this.dock(0, false, false);
                        SpecialKeyWindow.this.shell.moveAbove((Control)SpecialKeyWindow.this.parent);
                    }
                    Point previousLocation = SpecialKeyWindow.this.shell.getLocation();
                    int x = previousLocation.x + (e.x - ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.x);
                    int y = previousLocation.y + (e.y - ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.y);
                    SpecialKeyWindow.this.shell.setLocation(x, y);
                    return;
                }
            }
        };
        this.shell.addMouseMoveListener(this.shellMouseMoveListener);
        this.shellMouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    SpecialKeyWindow.this.isGrabbedShell = false;
                    ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.y = 0;
                    ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.x = 0;
                    HWKey pressedHWKey = SpecialKeyWindow.this.currentPressedHWKey;
                    if (pressedHWKey == null) {
                        SpecialKeyWindow.this.logger.info("mouseUp in KeyWindow : " + e.x + ", " + e.y);
                        Rectangle parentBounds = SpecialKeyWindow.this.parent.getBounds();
                        Rectangle childBounds = SpecialKeyWindow.this.shell.getBounds();
                        int heightOneThird = parentBounds.height / 3;
                        int widthDockingArea = 30;
                        int widthIntersectRegion = 5;
                        Rectangle attachBoundsRC = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y + heightOneThird, widthDockingArea, heightOneThird);
                        Rectangle attachBoundsRT = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y, widthDockingArea, heightOneThird);
                        Rectangle attachBoundsRB = new Rectangle(parentBounds.x + parentBounds.width - widthIntersectRegion, parentBounds.y + heightOneThird * 2, widthDockingArea, heightOneThird);
                        Rectangle attachBoundsLC = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y + heightOneThird, widthDockingArea, heightOneThird);
                        Rectangle attachBoundsLT = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y, widthDockingArea, heightOneThird);
                        Rectangle attachBoundsLB = new Rectangle(parentBounds.x - (widthDockingArea - widthIntersectRegion), parentBounds.y + heightOneThird * 2, widthDockingArea, heightOneThird);
                        if (childBounds.intersects(attachBoundsRC)) {
                            SpecialKeyWindow.this.dock(0x1020000, false, true);
                        } else if (childBounds.intersects(attachBoundsRT)) {
                            SpecialKeyWindow.this.dock(131200, false, true);
                        } else if (childBounds.intersects(attachBoundsRB)) {
                            SpecialKeyWindow.this.dock(132096, false, true);
                        } else if (childBounds.intersects(attachBoundsLC)) {
                            SpecialKeyWindow.this.dock(0x1004000, false, true);
                        } else if (childBounds.intersects(attachBoundsLT)) {
                            SpecialKeyWindow.this.dock(16512, false, true);
                        } else if (childBounds.intersects(attachBoundsLB)) {
                            SpecialKeyWindow.this.dock(17408, false, true);
                        } else {
                            SpecialKeyWindow.this.dock(0, false, true);
                        }
                        return;
                    }
                    if (pressedHWKey.getKeyCode() != -1) {
                        SpecialKeyWindow.this.logger.info(pressedHWKey.getName() + " key is released");
                        if (SpecialKeyWindow.this.isTouch) {
                            SpecialKeyWindow.this.isTouch = false;
                            MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.RELEASE.value(), e.x, e.y, e.x, e.y, 0);
                            SpecialKeyWindow.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        } else {
                            KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.RELEASED.value(), pressedHWKey.getKeyCode(), 0, 0);
                            SpecialKeyWindow.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                        }
                        SpecialKeyWindow.this.currentPressedHWKey = null;
                        SpecialKeyWindow.this.shell.redraw(pressedHWKey.getRegion().x, pressedHWKey.getRegion().y, pressedHWKey.getRegion().width, pressedHWKey.getRegion().height, false);
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (1 == e.button) {
                    final HWKey hwKey = SpecialKeyWindow.this.getHWKey(e.x, e.y);
                    if (hwKey == null) {
                        SpecialKeyWindow.this.logger.info("mouseDown in KeyWindow : " + e.x + ", " + e.y);
                        SpecialKeyWindow.this.isGrabbedShell = true;
                        ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.x = e.x;
                        ((SpecialKeyWindow)SpecialKeyWindow.this).grabPosition.y = e.y;
                        return;
                    }
                    if (hwKey.getKeyCode() != -1) {
                        SpecialKeyWindow.this.logger.info(hwKey.getName() + " key is pressed");
                        if (hwKey.getTooltip().equalsIgnoreCase("touch")) {
                            SpecialKeyWindow.this.isTouch = true;
                            MouseEventData mouseEventData = new MouseEventData(ICommunicator.MouseButtonType.LEFT.value(), ICommunicator.MouseEventType.PRESS.value(), e.x, e.y, e.x, e.y, 0);
                            SpecialKeyWindow.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_MOUSE_EVENT, mouseEventData, false);
                        } else {
                            KeyEventData keyEventData = new KeyEventData(ICommunicator.KeyEventType.PRESSED.value(), hwKey.getKeyCode(), 0, 0);
                            SpecialKeyWindow.this.communicator.sendToQEMU(ICommunicator.SendCommand.SEND_HW_KEY_EVENT, keyEventData, false);
                        }
                        SpecialKeyWindow.this.currentPressedHWKey = hwKey;
                        SpecialKeyWindow.this.shell.setToolTipText(null);
                        if (hwKey.getRegion() != null && hwKey.getRegion().width != 0 && hwKey.getRegion().height != 0) {
                            SpecialKeyWindow.this.shell.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    GC gc;
                                    if (SpecialKeyWindow.this.keyWindowPressedImage != null && (gc = new GC((Drawable)SpecialKeyWindow.this.shell)) != null) {
                                        gc.drawImage(SpecialKeyWindow.this.keyWindowPressedImage, hwKey.getRegion().x, hwKey.getRegion().y, hwKey.getRegion().width, hwKey.getRegion().height, hwKey.getRegion().x, hwKey.getRegion().y, hwKey.getRegion().width, hwKey.getRegion().height);
                                        gc.dispose();
                                    }
                                }
                            });
                        }
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.shell.addMouseListener(this.shellMouseListener);
        this.shell.getDisplay().addListener(39, new Listener(){

            public void handleEvent(Event e) {
                SpecialKeyWindow.this.trimWindow();
            }
        });
    }

    private void dispose() {
        if (null != this.shellPaintListener) {
            this.shell.removePaintListener(this.shellPaintListener);
        }
        if (null != this.shellListener) {
            this.shell.removeShellListener(this.shellListener);
        }
        if (null != this.shellMouseMoveListener) {
            this.shell.removeMouseMoveListener(this.shellMouseMoveListener);
        }
        if (null != this.shellMouseListener) {
            this.shell.removeMouseListener(this.shellMouseListener);
        }
        this.imageRegistry.dispose();
    }
}

