/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.skin.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.tizen.emulator.skin.exception.JaxbException;

public class JaxbUtil {
    private JaxbUtil() {
    }

    public static <T> T unmarshal(byte[] inputBytes, Class<T> clazz) throws JaxbException {
        return JaxbUtil.unmarshal(new ByteArrayInputStream(inputBytes), clazz);
    }

    public static <T> T unmarshal(InputStream in, Class<T> clazz) throws JaxbException {
        try {
            Unmarshaller u = JaxbUtil.getContext(clazz).createUnmarshaller();
            JAXBElement element = u.unmarshal((Source)new StreamSource(in), clazz);
            return (T)element.getValue();
        }
        catch (JAXBException e) {
            throw new JaxbException(e);
        }
        catch (Throwable e) {
            throw new JaxbException(e);
        }
    }

    public static void marshal(Object object, OutputStream out) throws JaxbException {
        try {
            Marshaller m = JaxbUtil.getContext(object.getClass()).createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(object, out);
        }
        catch (JAXBException e) {
            throw new JaxbException(e);
        }
        catch (Throwable e) {
            throw new JaxbException(e);
        }
    }

    private static JAXBContext getContext(Class<?> clazz) throws JaxbException {
        try {
            String qualifier = clazz.getCanonicalName();
            if (qualifier == null) {
                throw new JAXBException("underlying class does not have a canonical name");
            }
            int index = qualifier.lastIndexOf(46);
            if (-1 != index) {
                qualifier = qualifier.substring(0, index);
            }
            return JAXBContext.newInstance((String)qualifier, (ClassLoader)clazz.getClassLoader());
        }
        catch (JAXBException e) {
            throw new JaxbException(e);
        }
    }
}

