#!/bin/sh -xe

echo $INSTALLED_PATH > "/tmp/tizen_installed_path"
MODIFIED_INSTALLED_PATH=$(sed "s/\//\\\\\//g" "/tmp/tizen_installed_path")
rm -f "/tmp/tizen_installed_path"

echo "==========================================================================="
echo "Set prefix value of EFL pkg config files. INSTALLED_PATH is $INSTALLED_PATH"
echo "==========================================================================="

if [ -d "${INSTALLED_PATH}/platforms/tizen-2.3.2/common/efl-tool/efl-tools/lib/pkgconfig" ]; then
    cd "${INSTALLED_PATH}/platforms/tizen-2.3.2/common/efl-tool/efl-tools/lib/pkgconfig"
    for I in `ls *.pc`
    do
        sed -i /^"prefix="/d $I
        sed -i "s/exec_prefix=/prefix=$MODIFIED_INSTALLED_PATH\/platforms\/tizen-2.3.2\/common\/efl-tool\/efl-tools\nexec_prefix=/" $I
        sed -i /^"prefix ="/d $I
        sed -i "s/exec_prefix =/prefix = $MODIFIED_INSTALLED_PATH\/platforms\/tizen-2.3.2\/common\/efl-tool\/efl-tools\nexec_prefix =/" $I

        if [ ${I} = "freetype2.pc" ]; then
            sed -i /^"exec_prefix="/d $I
            sed -i "s/^libdir=/exec_prefix=\${prefix}\nlibdir=/" $I
            sed -i /^"exec_prefix ="/d $I
            sed -i "s/^libdir =/exec_prefix = \${prefix}\nlibdir =/" $I

            sed -i /^"libdir="/d $I
            sed -i "s/^includedir=/libdir=\${exec_prefix}\/lib\nincludedir=/" $I
            sed -i /^"libdir ="/d $I
            sed -i "s/^includedir =/libdir = \${exec_prefix}\/lib\nincludedir =/" $I

            sed -i /^"includedir="/d $I
            sed -i "s/^libdir=\${exec_prefix}\/lib/libdir=\${exec_prefix}\/lib\nincludedir=\${prefix}\/include\/freetype2/" $I
            sed -i /^"includedir ="/d $I
            sed -i "s/^libdir = \${exec_prefix}\/lib/libdir = \${exec_prefix}\/lib\nincludedir = \${prefix}\/include\/freetype2/" $I
        fi
    done
fi

if [ -d "${HOME}/.elementary" ]; then
    rm -rf "${HOME}/.elementary"
fi
