/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 8;
    static final int ARROW_HEIGHT = 6;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    Rectangle computeTrim(Theme theme, GC gC) {
        long l = theme.buttonHandle;
        long l2 = OS.gtk_widget_get_style(l);
        int n = theme.getWidgetProperty(l, "focus-line-width");
        int n2 = theme.getWidgetProperty(l, "focus-padding");
        int n3 = OS.gtk_style_get_xthickness(l2);
        int n4 = OS.gtk_style_get_ythickness(l2);
        int n5 = n3 + n + n2;
        int n6 = n4 + n + n2;
        int n7 = this.clientArea.x - n5;
        int n8 = this.clientArea.y - n6;
        int n9 = this.clientArea.width + 2 * n5;
        int n10 = this.clientArea.height + 2 * n6;
        if ((this.style & 4) != 0) {
            n9 += 8;
        }
        return new Rectangle(n7, n8, n9, n10);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.state[0];
        long l = gC.getGCData().drawable;
        if ((this.style & 2) != 0) {
            int n6 = this.getStateType(0);
            long l2 = theme.separatorHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "vseparator", true);
            long l3 = OS.gtk_widget_get_style(l2);
            theme.transferClipping(gC, l3);
            if ((this.parent.style & 0x200) != 0) {
                if (OS.GTK3) {
                    long l4 = OS.gdk_cairo_create(l);
                    long l5 = OS.gtk_widget_get_style_context(l2);
                    OS.gtk_render_line(l5, l4, rectangle.x, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
                    Cairo.cairo_destroy(l4);
                } else {
                    OS.gtk_paint_hline(l3, l, n6, null, l2, byArray, rectangle.x, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
                }
            } else if (OS.GTK3) {
                long l6 = OS.gdk_cairo_create(l);
                long l7 = OS.gtk_widget_get_style_context(l2);
                OS.gtk_render_line(l7, l6, rectangle.x + rectangle.width / 2, rectangle.y, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
                Cairo.cairo_destroy(l6);
            } else {
                OS.gtk_paint_vline(l3, l, n6, null, l2, byArray, rectangle.y, rectangle.y + rectangle.height, rectangle.x + rectangle.width / 2);
            }
            return;
        }
        long l8 = theme.buttonHandle;
        long l9 = OS.gtk_widget_get_style(l8);
        theme.transferClipping(gC, l9);
        int n7 = theme.getWidgetProperty(l8, "focus-line-width");
        int n8 = theme.getWidgetProperty(l8, "focus-padding");
        int n9 = OS.gtk_container_get_border_width(l8);
        int n10 = rectangle.x + n9;
        int n11 = rectangle.y + n9;
        int n12 = rectangle.width - n9 * 2;
        int n13 = rectangle.height - n9 * 2;
        byte[] byArray = null;
        if ((this.style & 0xC) != 0) {
            byArray = Converter.wcsToMbcs(null, "button", true);
        } else if ((this.style & 0x30) != 0) {
            byArray = Converter.wcsToMbcs(null, "togglebutton", true);
        }
        int[] nArray = new int[1];
        long l10 = theme.toolbarHandle;
        OS.gtk_widget_style_get(l10, OS.button_relief, nArray, 0L);
        int n14 = 2;
        if ((n5 & 0xA) != 0) {
            n14 = 1;
        }
        int n15 = this.getStateType(0);
        if (nArray[0] != 2 || (n5 & 0x4A) != 0) {
            this.gtk_render_box(l9, l, n15, n14, null, l8, byArray, n10, n11, n12, n13);
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x + n9;
            this.clientArea.y = rectangle.y + n9;
            this.clientArea.width = rectangle.width - 2 * n9;
            this.clientArea.height = rectangle.height - 2 * n9;
        }
        int n16 = OS.gtk_style_get_xthickness(l9);
        int n17 = theme.getWidgetProperty(l8, "interior-focus");
        if ((this.style & 4) != 0) {
            n4 = 8;
            n3 = 6;
            n2 = n10 + n12 - n4 - n16 - n8;
            if (n17 == 0) {
                n2 -= n7;
            }
            n = n11 + (n13 - n3) / 2;
            byte[] byArray2 = Converter.wcsToMbcs(null, "arrow", true);
            this.gtk_render_arrow(l9, l, n15, 0, null, theme.arrowHandle, byArray2, 1, true, n2, n, n4, n3);
            if (this.clientArea != null) {
                this.clientArea.width -= rectangle.x + rectangle.width - n2;
            }
        }
        if ((n5 & 4) != 0) {
            n4 = theme.getWidgetProperty(l8, "child-displacement-y");
            n3 = theme.getWidgetProperty(l8, "child-displacement-x");
            n2 = theme.getWidgetProperty(l8, "displace-focus");
            if (n17 != 0) {
                n = OS.gtk_style_get_ythickness(l9);
                n10 += n16 + n8;
                n11 += n + n8;
                n12 -= 2 * (n16 + n8);
                n13 -= 2 * (n + n8);
            } else {
                n10 -= n7 + n8;
                n11 -= n7 + n8;
                n12 += 2 * (n7 + n8);
                n13 += 2 * (n7 + n8);
            }
            if ((n5 & 0xA) != 0 && n2 != 0) {
                n10 += n3;
                n11 += n4;
            }
            this.gtk_render_focus(l9, l, n15, null, l8, byArray, n10, n11, n12, n13);
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        if ((this.style & 4) != 0) {
            long l = theme.buttonHandle;
            long l2 = OS.gtk_widget_get_style(l);
            int n = OS.gtk_style_get_xthickness(l2);
            int n2 = theme.getWidgetProperty(l, "interior-focus");
            int n3 = theme.getWidgetProperty(l, "focus-line-width");
            int n4 = theme.getWidgetProperty(l, "focus-padding");
            int n5 = 8;
            int n6 = rectangle.x + rectangle.width - n5 - n - n4;
            if (n2 == 0) {
                n6 -= n3;
            }
            if (n6 <= point.x) {
                return 1;
            }
        }
        return 0;
    }
}

