#ifndef _ECORE_POLLER_EO_LEGACY_H_
#define _ECORE_POLLER_EO_LEGACY_H_

#ifndef _ECORE_POLLER_EO_CLASS_TYPE
#define _ECORE_POLLER_EO_CLASS_TYPE

typedef Eo Ecore_Poller;

#endif

#ifndef _ECORE_POLLER_EO_TYPES
#define _ECORE_POLLER_EO_TYPES


#endif

/**
 *
 * @brief Changes the polling interval rate of @p poller.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Ecore_Poller_Group
 *
 * @return Returns true on success, false on failure.
 *
 * @remark This allows the changing of a poller's polling interval. It is useful when
 * you want to alter a poll rate without deleting and re-creating a poller.
 *
 * @param[in] interval The tick interval to set; must be a power of 2 and <= 32768.
 */
EAPI Eina_Bool ecore_poller_poller_interval_set(Ecore_Poller *obj, int interval);

/**
 *
 * @brief Gets the polling interval rate of @p poller.
 * @return Returns the interval, in ticks, that @p poller polls at.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Ecore_Poller_Group
 *
 * @remark This returns a poller's polling interval, or 0 on error.
 *
 */
EAPI int ecore_poller_poller_interval_get(const Ecore_Poller *obj);

#endif
