#ifndef _ECORE_CON_BASE_EO_LEGACY_H_
#define _ECORE_CON_BASE_EO_LEGACY_H_

#ifndef _ECORE_CON_BASE_EO_CLASS_TYPE
#define _ECORE_CON_BASE_EO_CLASS_TYPE

typedef Eo Ecore_Con_Base;

#endif

#ifndef _ECORE_CON_BASE_EO_TYPES
#define _ECORE_CON_BASE_EO_TYPES

typedef struct {
  void *data; /** The data thet got sent. */
  int size; /** The length of the data sent. */
} Ecore_Con_Event_Data_Received;


#endif

/**
 *
 * * Do an asynchronous DNS lookup.
 * *
 * * @param name IP address or server name to translate.
 * * @param done_cb Callback to notify when done.
 * * @param data User data to be given to done_cb.
 * * @return @c EINA_TRUE if the request did not fail to be set up, @c EINA_FALSE
 * * if it failed.
 * *
 * * This function performs a DNS lookup on the hostname specified by @p name,
 * * then calls @p done_cb with the result and the @p data given as parameter.
 * * The result will be given to the @p done_cb as follows:
 * * @li @c canonname - the canonical name of the address
 * * @li @c ip - the resolved ip address
 * * @li @c addr - a pointer to the socket address
 * * @li @c addrlen - the length of the socket address, in bytes
 * * @li @c data - the data pointer given as parameter to ecore_con_lookup()
 * 
 *
 * @param[in] name Hostname to lookup.
 * @param[in] done_cb The callback to be called wehn lookup is done.
 * @param[in] data User data for the callback.
 */
EAPI Eina_Bool ecore_con_lookup(const char *name, Ecore_Con_Dns_Cb done_cb, const void *data) EINA_ARG_NONNULL(2);

#endif
