#ifndef _EFL_GFX_BASE_EO_H_
#define _EFL_GFX_BASE_EO_H_

#ifndef _EFL_GFX_BASE_EO_CLASS_TYPE
#define _EFL_GFX_BASE_EO_CLASS_TYPE

typedef Eo Efl_Gfx_Base;

#endif

#ifndef _EFL_GFX_BASE_EO_TYPES
#define _EFL_GFX_BASE_EO_TYPES


#endif
#define EFL_GFX_BASE_INTERFACE efl_gfx_base_interface_get()

const Eo_Class *efl_gfx_base_interface_get(void) EINA_CONST;

/**
 *
 * Move the given Evas object to the given location inside its canvas' viewport.
 *
 * @param[in] x in
 * @param[in] y in
 *
 */
EOAPI void  efl_gfx_position_set(int x, int y);

/**
 *
 * Retrieves the position of the given Evas object.
 *
 * @param[out] x in
 * @param[out] y in
 *
 */
EOAPI void  efl_gfx_position_get(int *x, int *y);

/**
 *
 * Changes the size of the given Evas object.
 *
 * @param[in] w in
 * @param[in] h in
 *
 */
EOAPI void  efl_gfx_size_set(int w, int h);

/**
 *
 * Retrieves the (rectangular) size of the given Evas object.
 *
 * @param[out] w in
 * @param[out] h in
 *
 */
EOAPI void  efl_gfx_size_get(int *w, int *h);

/**
 *
 * Sets the general/main color of the given Evas object to the given
 * one.
 *
 * @see evas_object_color_get() (for an example)
 * @note These color values are expected to be premultiplied by @p a.
 *
 * @ingroup Evas_Object_Group_Basic
 *
 * @param[in] r The red component of the given color.
 * @param[in] g The green component of the given color.
 * @param[in] b The blue component of the given color.
 * @param[in] a The alpha component of the given color.
 *
 */
EOAPI void  efl_gfx_color_set(int r, int g, int b, int a);

/**
 *
 * Retrieves the general/main color of the given Evas object.
 *
 * Retrieves the “main” color's RGB component (and alpha channel)
 * values, <b>which range from 0 to 255</b>. For the alpha channel,
 * which defines the object's transparency level, 0 means totally
 * transparent, while 255 means opaque. These color values are
 * premultiplied by the alpha value.
 *
 * Usually you’ll use this attribute for text and rectangle objects,
 * where the “main” color is their unique one. If set for objects
 * which themselves have colors, like the images one, those colors get
 * modulated by this one.
 *
 * @note All newly created Evas rectangles get the default color
 * values of <code>255 255 255 255</code> (opaque white).
 *
 * @note Use @c NULL pointers on the components you're not interested
 * in: they'll be ignored by the function.
 *
 * Example:
 * @dontinclude evas-object-manipulation.c
 * @skip int alpha, r, g, b;
 * @until return
 *
 * See the full @ref Example_Evas_Object_Manipulation "example".
 *
 * @ingroup Evas_Object_Group_Basic
 *
 * @param[out] r The red component of the given color.
 * @param[out] g The green component of the given color.
 * @param[out] b The blue component of the given color.
 * @param[out] a The alpha component of the given color.
 *
 */
EOAPI void  efl_gfx_color_get(int *r, int *g, int *b, int *a);

/**
 *
 * Sets a specifc color of the given Efl.Gfx.Base object to the given
 * one.
 *
 * @see evas_object_color_get() (for an example)
 * @note These color values are expected to be premultiplied by @p a.
 *
 * @param[in] part The part you are interested in.
 * @param[in] r The red component of the given color.
 * @param[in] g The green component of the given color.
 * @param[in] b The blue component of the given color.
 * @param[in] a The alpha component of the given color.
 *
 */
EOAPI Eina_Bool  efl_gfx_color_part_set(const char * part, int r, int g, int b, int a);

/**
 *
 * Retrieves a specific color of the given Evas object.
 *
 * Retrieves a specific color's RGB component (and alpha channel)
 * values, <b>which range from 0 to 255</b>. For the alpha channel,
 * which defines the object's transparency level, 0 means totally
 * transparent, while 255 means opaque. These color values are
 * premultiplied by the alpha value.
 *
 * The “main“ color being mapped to @c NULL.
 *
 * Usually you’ll use this attribute for text and rectangle objects,
 * where the “main” color is their unique one. If set for objects
 * which themselves have colors, like the images one, those colors get
 * modulated by this one.
 *
 * @note Use @c NULL pointers on the components you're not interested
 * in: they'll be ignored by the function.
 *
 * @param[in] part The part you are interested in.
 * @param[out] r The red component of the given color.
 * @param[out] g The green component of the given color.
 * @param[out] b The blue component of the given color.
 * @param[out] a The alpha component of the given color.
 *
 */
EOAPI Eina_Bool  efl_gfx_color_part_get(const char * part, int *r, int *g, int *b, int *a);

/**
 *
 * Makes the given Evas object visible or invisible.
 *
 * @param[in] v @c EINA_TRUE if to make the object visible, @c EINA_FALSE otherwise
 *
 */
EOAPI void  efl_gfx_visible_set(Eina_Bool v);

/**
 *
 * Retrieves whether or not the given Evas object is visible.
 *
 *
 */
EOAPI Eina_Bool  efl_gfx_visible_get(void);


#endif
