#ifndef _EFL_PLAYER_EO_H_
#define _EFL_PLAYER_EO_H_

#ifndef _EFL_PLAYER_EO_CLASS_TYPE
#define _EFL_PLAYER_EO_CLASS_TYPE

typedef Eo Efl_Player;

#endif

#ifndef _EFL_PLAYER_EO_TYPES
#define _EFL_PLAYER_EO_TYPES


#endif
#define EFL_PLAYER_INTERFACE efl_player_interface_get()

const Eo_Class *efl_player_interface_get(void) EINA_CONST;

/**
 *
 * * @brief Set play/pause state of the media file.
 * *
 * * This functions sets the currently playing status of the video. Using this
 * * function to play or pause the video doesn't alter it's current position.
 *
 * @param[in] play true if playing, false otherwise.
 *
 */
EOAPI void  efl_player_play_set(Eina_Bool play);

/**
 *
 * * @brief Get play/pause state of the media file.
 *
 *
 */
EOAPI Eina_Bool  efl_player_play_get(void);

/**
 *
 * * @brief Set the position in the media file.
 * *
 * * @param obj The emotion object whose position will be changed.
 * * @param sec The position(in seconds) to which the media file will be set.
 * *
 * * This functions sets the current position of the media file to @p sec, this
 * * only works on seekable streams. Setting the position doesn't change the
 * * playing state of the media file.
 *
 * @param[in] second The position (in seconds).
 *
 */
EOAPI void  efl_player_position_set(double second);

/**
 *
 * * @brief Get the position in the media file.
 * *
 * * @param obj The emotion object from which the position will be retrieved.
 * * @return The position of the media file.
 * *
 * * The position is returned as the number of seconds since the beginning of the
 * * media file.
 *
 *
 */
EOAPI double  efl_player_position_get(void);

/**
 *
 * * @brief Get how much of the file has been played.
 * *
 * * This function gets the progress in playing the file, the return value is in
 * * the [0, 1] range.
 *
 *
 */
EOAPI double  efl_player_progress_get(void);

/**
 *
 * No description supplied.
 *
 * @param[in] speed The play speed in the [0, infinity) range.
 *
 */
EOAPI void  efl_player_play_speed_set(double speed);

/**
 *
 * No description supplied.
 *
 *
 */
EOAPI double  efl_player_play_speed_get(void);

/**
 *
 * No description supplied.
 *
 * @param[in] volume The volume level
 *
 */
EOAPI void  efl_player_audio_volume_set(double volume);

/**
 *
 * No description supplied.
 *
 *
 */
EOAPI double  efl_player_audio_volume_get(void);

/**
 *
 * No description supplied.
 *
 * @param[in] mute The mute state. True or false.
 *
 */
EOAPI void  efl_player_audio_mute_set(Eina_Bool mute);

/**
 *
 * No description supplied.
 *
 *
 */
EOAPI Eina_Bool  efl_player_audio_mute_get(void);


#endif
