#ifndef _EFL_TEXT_EO_H_
#define _EFL_TEXT_EO_H_

#ifndef _EFL_TEXT_EO_CLASS_TYPE
#define _EFL_TEXT_EO_CLASS_TYPE

typedef Eo Efl_Text;

#endif

#ifndef _EFL_TEXT_EO_TYPES
#define _EFL_TEXT_EO_TYPES


#endif
#define EFL_TEXT_INTERFACE efl_text_interface_get()

const Eo_Class *efl_text_interface_get(void) EINA_CONST;

/**
 *
 * Sets the text string to be displayed by the given text object.
 *
 * @see evas_object_text_text_get()
 *
 * @param[in] text Text string to display on it.
 *
 */
EOAPI void  efl_text_set(const char *text);

/**
 *
 * Retrieves the text string currently being displayed by the given
 * text object.
 *
 * @return The text string currently being displayed on it.
 *
 * @note Do not free() the return value.
 *
 * @see evas_object_text_text_set()
 *
 *
 */
EOAPI const char * efl_text_get(void);


#endif
