#ifndef _ELM_BG_EO_H_
#define _ELM_BG_EO_H_

#ifndef _ELM_BG_EO_CLASS_TYPE
#define _ELM_BG_EO_CLASS_TYPE

typedef Eo Elm_Bg;

#endif

#ifndef _ELM_BG_EO_TYPES
#define _ELM_BG_EO_TYPES


#endif
#define ELM_BG_CLASS elm_bg_class_get()

const Eo_Class *elm_bg_class_get(void) EINA_CONST;

/**
 *
 * @brief Set the mode of display for a given background widget's image
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets how the background widget will display its image. This
 * will only work if the elm_bg_file_set() was previously called with
 * an image file on @a obj. The image can be display tiled, scaled,
 * centered or stretched. #ELM_BG_OPTION_SCALE by default.
 *
 * @see elm_bg_option_get()
 *
 * @ingroup Bg
 *
 * @param[in] option The desired background option (see #Elm_Bg_Option)
 *
 */
EOAPI void  elm_obj_bg_option_set(Elm_Bg_Option option);

/**
 *
 * @brief Get the mode of display for a given background widget's image
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The image displaying mode in use for @a obj or #ELM_BG_OPTION_LAST,
 * on errors.
 *
 * @see elm_bg_option_set() for more details
 *
 * @ingroup Bg
 *
 *
 */
EOAPI Elm_Bg_Option  elm_obj_bg_option_get(void);

/**
 *
 * @brief Set the color on a given background widget
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets the color used for the background rectangle, in RGB
 * format. Each color component's range is from 0 to 255.
 *
 * @remark You probably only want to use this function if you haven't
 * previously called elm_bg_file_set(), so that you just want a solid
 * color background.
 *
 * @remark You can reset the color by setting @p r, @p g, @p b as -1, -1, -1.
 *
 * @see elm_bg_color_get()
 *
 * @ingroup Bg
 *
 * @param[in] r The red color component's value
 * @param[in] g The green color component's value
 * @param[in] b The blue color component's value
 * @param[in] a The blue color component's value
 *
 */
EOAPI void  elm_obj_bg_color_set(int r, int g, int b, int a);

/**
 *
 * @brief Get the color set on a given background widget
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark Use @c NULL pointers on the file components you're not
 * interested in: they'll be ignored by the function.
 *
 * @see elm_bg_color_get() for more details
 *
 * @ingroup Bg
 *
 * @param[out] r The red color component's value
 * @param[out] g The green color component's value
 * @param[out] b The blue color component's value
 * @param[out] a The blue color component's value
 *
 */
EOAPI void  elm_obj_bg_color_get(int *r, int *g, int *b, int *a);

/**
 *
 * @brief Set the size of the pixmap representation of the image set on a
 * given background widget.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @warning This function just makes sense if an image file was set on
 * @p obj, with elm_bg_file_set().
 *
 * @remark This function sets a new size for pixmap representation of the
 * given bg image. It allows for the image to be loaded already in the
 * specified size, reducing the memory usage and load time (for
 * example, when loading a big image file with its load size set to a
 * smaller size)
 *
 * @remark This is just a hint for the underlying system. The real size
 * of the pixmap may differ depending on the type of image being
 * loaded, being bigger than requested.
 *
 * @ingroup Bg
 *
 * @param[in] w The new width of the image pixmap representation.
 * @param[in] h The new height of the image pixmap representation.
 *
 */
EOAPI void  elm_obj_bg_load_size_set(Evas_Coord w, Evas_Coord h);


#endif
