#ifndef _ELM_BG_EO_LEGACY_H_
#define _ELM_BG_EO_LEGACY_H_

#ifndef _ELM_BG_EO_CLASS_TYPE
#define _ELM_BG_EO_CLASS_TYPE

typedef Eo Elm_Bg;

#endif

#ifndef _ELM_BG_EO_TYPES
#define _ELM_BG_EO_TYPES


#endif

/**
 *
 * @brief Set the mode of display for a given background widget's image
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets how the background widget will display its image. This
 * will only work if the elm_bg_file_set() was previously called with
 * an image file on @a obj. The image can be display tiled, scaled,
 * centered or stretched. #ELM_BG_OPTION_SCALE by default.
 *
 * @see elm_bg_option_get()
 *
 * @ingroup Bg
 *
 * @param[in] option The desired background option (see #Elm_Bg_Option)
 */
EAPI void elm_bg_option_set(Elm_Bg *obj, Elm_Bg_Option option);

/**
 *
 * @brief Get the mode of display for a given background widget's image
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The image displaying mode in use for @a obj or #ELM_BG_OPTION_LAST,
 * on errors.
 *
 * @see elm_bg_option_set() for more details
 *
 * @ingroup Bg
 *
 */
EAPI Elm_Bg_Option elm_bg_option_get(const Elm_Bg *obj);

/**
 *
 * @brief Set the size of the pixmap representation of the image set on a
 * given background widget.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @warning This function just makes sense if an image file was set on
 * @p obj, with elm_bg_file_set().
 *
 * @remark This function sets a new size for pixmap representation of the
 * given bg image. It allows for the image to be loaded already in the
 * specified size, reducing the memory usage and load time (for
 * example, when loading a big image file with its load size set to a
 * smaller size)
 *
 * @remark This is just a hint for the underlying system. The real size
 * of the pixmap may differ depending on the type of image being
 * loaded, being bigger than requested.
 *
 * @ingroup Bg
 *
 * @param[in] w The new width of the image pixmap representation.
 * @param[in] h The new height of the image pixmap representation.
 */
EAPI void elm_bg_load_size_set(Elm_Bg *obj, Evas_Coord w, Evas_Coord h);

#endif
