#ifndef _ELM_CALENDAR_EO_LEGACY_H_
#define _ELM_CALENDAR_EO_LEGACY_H_

#ifndef _ELM_CALENDAR_EO_CLASS_TYPE
#define _ELM_CALENDAR_EO_CLASS_TYPE

typedef Eo Elm_Calendar;

#endif

#ifndef _ELM_CALENDAR_EO_TYPES
#define _ELM_CALENDAR_EO_TYPES


#endif

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set the first day of week to use on calendar widgets'.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] day An int which correspond to the first day of the week (Sunday = 0, Monday = 1,
..., Saturday = 6)
 */
EAPI void elm_calendar_first_day_of_week_set(Elm_Calendar *obj, Elm_Calendar_Weekday day);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the first day of week, who are used on calendar widgets'.
 *
 * @return An int which correspond to the first day of the week (Sunday = 0, Monday = 1,
 * ..., Saturday = 6)
 *
 * @see elm_calendar_first_day_of_week_set() for more details
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 */
EAPI Elm_Calendar_Weekday elm_calendar_first_day_of_week_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Define which fields of a @b tm struct will be taken into account, when
 * elm_calendar_selected_time_set() is invoked.
 *
 * @remark By Default the bitmask is set to use all fields of a @b tm struct (year,
 * month and day of the month).
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * @see elm_calendar_selected_time_set
 * @since 1.8
 *
 * @param[in] selectable A bitmask of Elm_Calendar_Selectable
 */
EAPI void elm_calendar_selectable_set(Elm_Calendar *obj, Elm_Calendar_Selectable selectable);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get how elm_calendar_selected_time_set manage a date
 *
 * @return The flag used to manage a date with a elm_calendar_selected_time_set
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * @see elm_calendar_selectable_set
 * @see elm_calendar_selected_time_set
 * @since 1.8
 *
 */
EAPI Elm_Calendar_Selectable elm_calendar_selectable_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set the interval on time updates for an user mouse button hold
 * on calendar widgets' month/year selection.
 *
 * @remark This interval value is @b decreased while the user holds the
 * mouse pointer either selecting next or previous month/year.
 *
 * @remark This helps the user to get to a given month distant from the
 * current one easier/faster, as it will start to change quicker and
 * quicker on mouse button holds.
 *
 * @remark The calculation for the next change interval value, starting from
 * the one set with this call, is the previous interval divided by
 * 1.05, so it decreases a little bit.
 *
 * @remark The default starting interval value for automatic changes is
 * @b 0.85 seconds.
 *
 * @see elm_calendar_interval_get()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] interval The (first) interval value in seconds
 */
EAPI void elm_calendar_interval_set(Elm_Calendar *obj, double interval);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the interval on time updates for an user mouse button hold
 * on calendar widgets' month/year selection.
 *
 * @return The (first) interval value, in seconds, set on it
 *
 * @see elm_calendar_interval_set() for more details
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 */
EAPI double elm_calendar_interval_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set weekdays names to be displayed by the calendar.
 *
 * @remark By default, weekdays abbreviations get from system are displayed:
 * E.g. for an en_US locale: "Sun, Mon, Tue, Wed, Thu, Fri, Sat"
 *
 * @remark The first string should be related to Sunday, the second to Monday...
 *
 * The usage should be like this:
 * @code
 * const char *weekdays[] =
 * {
 * "Sunday", "Monday", "Tuesday", "Wednesday",
 * "Thursday", "Friday", "Saturday"
 * };
 * elm_calendar_weekdays_names_set(calendar, weekdays);
 * @endcode
 *
 * @see elm_calendar_weekdays_name_get()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] weekdays Array of seven strings to be used as weekday names.
@warning It must have 7 elements, or it will access invalid memory.
@warning The strings must be NULL terminated ('@\0').
 */
EAPI void elm_calendar_weekdays_names_set(Elm_Calendar *obj, const char **weekdays);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get weekdays names displayed by the calendar.
 *
 * @return Array of seven strings to be used as weekday names.
 *
 * @remark By default, weekdays abbreviations get from system are displayed:
 * E.g. for an en_US locale: "Sun, Mon, Tue, Wed, Thu, Fri, Sat"
 * The first string is related to Sunday, the second to Monday...
 *
 * @see elm_calendar_weekdays_name_set()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 */
EAPI const char **elm_calendar_weekdays_names_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set select day mode to use.
 *
 * @remark Set the day selection mode used.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] mode The select mode to use.
 */
EAPI void elm_calendar_select_mode_set(Elm_Calendar *obj, Elm_Calendar_Select_Mode mode);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the select day mode used.
 *
 * @return the selected mode
 *
 * @remark Get the day selection mode used.
 *
 * @see elm_calendar_select_mode_set() for more details
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 */
EAPI Elm_Calendar_Select_Mode elm_calendar_select_mode_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set the minimum and maximum values for the year
 *
 * @remark Maximum must be greater than minimum, except if you don't want to set
 * maximum year.
 * @remark Default values are 1902 and -1.
 *
 * @remark If the maximum year is a negative value, it will be limited depending
 * on the platform architecture (year 2037 for 32 bits);
 *
 * @see elm_calendar_min_max_year_get()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] min The minimum year, greater than 1901;
 * @param[in] max The maximum year;
 */
EAPI void elm_calendar_min_max_year_set(Elm_Calendar *obj, int min, int max);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the minimum and maximum values for the year
 *
 * @remark Default values are 1902 and -1.
 *
 * @see elm_calendar_min_max_year_set() for more details.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[out] min The minimum year, greater than 1901;
 * @param[out] max The maximum year;
 */
EAPI void elm_calendar_min_max_year_get(const Elm_Calendar *obj, int *min, int *max);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set a function to format the string that will be used to display
 * month and year;
 *
 * @remark By default it uses strftime with "%B %Y" format string.
 * It should allocate the memory that will be used by the string,
 * that will be freed by the widget after usage.
 * A pointer to the string and a pointer to the time struct will be provided.
 *
 * Example:
 * @code
 * static char
 * _format_month_year(struct tm *selected_time)
 * {
 * char buf[32];
 * if (!strftime(buf, sizeof(buf), "%B %Y", selected_time)) return NULL;
 * return strdup(buf);
 * }
 *
 * elm_calendar_format_function_set(calendar, _format_month_year);
 * @endcode
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 * @param[in] format_function Function to set the month-year string given
the selected date
 */
EAPI void elm_calendar_format_function_set(Elm_Calendar *obj, Elm_Calendar_Format_Cb format_function);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get a list of all the calendar marks.
 *
 * @return A @c list of calendar marks objects, or @c NULL on failure.
 *
 * @see elm_calendar_mark_add()
 * @see elm_calendar_mark_del()
 * @see elm_calendar_marks_clear()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 *
 */
EAPI const Eina_List *elm_calendar_marks_get(const Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set selected date to be highlighted on calendar.
 *
 * @remark Set the selected date, changing the displayed month if needed.
 * Selected date changes when the user goes to next/previous month or
 * select a day pressing over it on calendar.
 *
 * @see elm_calendar_selected_time_get()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * 
 *
 * @param[in] selected_time A @b tm struct to represent the selected date.
 */
EAPI void elm_calendar_selected_time_set(Elm_Calendar *obj, struct tm *selected_time);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get selected date.
 *
 * @return EINA_FALSE means an error occurred and returned time shouldn't
 * be considered.
 *
 * @remark Get date selected by the user or set by function
 * elm_calendar_selected_time_set().
 * Selected date changes when the user goes to next/previous month or
 * select a day pressing over it on calendar.
 *
 * @see elm_calendar_selected_time_get()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * 
 *
 * @param[in,out] selected_time A @b tm struct to point to selected date
 */
EAPI Eina_Bool elm_calendar_selected_time_get(const Elm_Calendar *obj, struct tm *selected_time);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Add a new mark to the calendar
 *
 * @return The created mark or @p NULL upon failure.
 *
 * @remark Add a mark that will be drawn in the calendar respecting the insertion
 * time and periodicity. It will emit the type as signal to the widget theme.
 * Default theme supports "holiday", but it can be extended.
 *
 * @remark It won't immediately update the calendar, drawing the marks.
 * For this, call elm_calendar_marks_draw(). However, when user selects
 * next or previous month calendar forces marks drawn.
 *
 * @remark Marks created with this method can be deleted with
 * elm_calendar_mark_del().
 *
 * Example
 * @code
 * struct tm selected_time;
 * time_t current_time;
 *
 * current_time = time(NULL) + 5 * (24 * 60 * 60);
 * localtime_r(&current_time, &selected_time);
 * elm_calendar_mark_add(cal, "holiday", selected_time,
 * ELM_CALENDAR_ANNUALLY);
 *
 * elm_calendar_marks_draw(cal);
 * @endcode
 *
 * @see elm_calendar_marks_draw()
 * @see elm_calendar_mark_del()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * 
 *
 * @param[in] mark_type A string used to define the type of mark. It will be
emitted to the theme, that should display a related modification on these
days representation.
 * @param[in] mark_time A time struct to represent the date of inclusion of the
mark. For marks that repeats it will just be displayed after the inclusion
date in the calendar.
 * @param[in] repeat Repeat the event following this periodicity. Can be a unique
mark (that don't repeat), daily, weekly, monthly or annually.
 */
EAPI Elm_Calendar_Mark *elm_calendar_mark_add(Elm_Calendar *obj, const char *mark_type, struct tm *mark_time, Elm_Calendar_Mark_Repeat_Type repeat);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Remove all calendar's marks
 *
 * @see elm_calendar_mark_add()
 * @see elm_calendar_mark_del()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * 
 *
 */
EAPI void elm_calendar_marks_clear(Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Draw calendar marks.
 *
 * @remark Should be used after adding, removing or clearing marks.
 * It will go through the entire marks list updating the calendar.
 * If lots of marks will be added, add all the marks and then call
 * this function.
 *
 * @remark When the month is changed, i.e. user selects next or previous month,
 * marks will be drawn.
 *
 * @see elm_calendar_mark_add()
 * @see elm_calendar_mark_del()
 * @see elm_calendar_marks_clear()
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * 
 *
 */
EAPI void elm_calendar_marks_draw(Elm_Calendar *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get the current time displayed in the widget
 *
 * @return EINA_FALSE means an error occurred. If it's an error the returned
 * time is zero filled.
 *
 * @if MOBILE @since_tizen 2.4
 * @endif
 *
 * @ingroup Calendar
 * @since 1.8
 * 
 *
 * @param[in,out] displayed_time A @b tm struct to point to displayed date
 */
EAPI Eina_Bool elm_calendar_displayed_time_get(const Elm_Calendar *obj, struct tm *displayed_time);

#endif
