#ifndef _ELM_CHECK_EO_LEGACY_H_
#define _ELM_CHECK_EO_LEGACY_H_

#ifndef _ELM_CHECK_EO_CLASS_TYPE
#define _ELM_CHECK_EO_CLASS_TYPE

typedef Eo Elm_Check;

#endif

#ifndef _ELM_CHECK_EO_TYPES
#define _ELM_CHECK_EO_TYPES


#endif

/**
 *
 * @brief Set the on/off state of the check object
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets the state of the check. If set with elm_check_state_pointer_set()
 * the state of that variable is also changed. Calling this @b doesn't cause
 * the "changed" signal to be emitted.
 *
 * @ingroup Check
 *
 * @param[in] state The state to use (1 == on, 0 == off)
 */
EAPI void elm_check_state_set(Elm_Check *obj, Eina_Bool state);

/**
 *
 * @brief Get the state of the check object
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @return The boolean state
 *
 * @ingroup Check
 *
 */
EAPI Eina_Bool elm_check_state_get(const Elm_Check *obj);

/**
 *
 * @brief Set a convenience pointer to a boolean to change
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @remark This sets a pointer to a boolean, that, in addition to the check objects
 * state will also be modified directly. To stop setting the object pointed
 * to simply use NULL as the @p statep parameter. If @p statep is not NULL,
 * then when this is called, the check objects state will also be modified to
 * reflect the value of the boolean @p statep points to, just like calling
 * elm_check_state_set().
 *
 * @ingroup Check
 *
 * @param[in] statep Pointer to the boolean to modify
 */
EAPI void elm_check_state_pointer_set(Elm_Check *obj, Eina_Bool *statep);

#endif
