#ifndef _ELM_COLORSELECTOR_EO_LEGACY_H_
#define _ELM_COLORSELECTOR_EO_LEGACY_H_

#ifndef _ELM_COLORSELECTOR_EO_CLASS_TYPE
#define _ELM_COLORSELECTOR_EO_CLASS_TYPE

typedef Eo Elm_Colorselector;

#endif

#ifndef _ELM_COLORSELECTOR_EO_TYPES
#define _ELM_COLORSELECTOR_EO_TYPES


#endif

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set color to colorselector
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @ingroup Colorselector
 *
 * @param[in] r r-value of color
 * @param[in] g g-value of color
 * @param[in] b b-value of color
 * @param[in] a a-value of color
 */
EAPI void elm_colorselector_color_set(Elm_Colorselector *obj, int r, int g, int b, int a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get current color from colorselector
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @ingroup Colorselector
 *
 * @param[out] r r-value of color
 * @param[out] g g-value of color
 * @param[out] b b-value of color
 * @param[out] a a-value of color
 */
EAPI void elm_colorselector_color_get(const Elm_Colorselector *obj, int *r, int *g, int *b, int *a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set current palette's name
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @remark When colorpalette name is set, colors will be loaded from and saved to config
 * using the set name. If no name is set then colors will be loaded from or
 * saved to "default" config.
 *
 * @ingroup Colorselector
 *
 * @param[in] palette_name Name of palette
 */
EAPI void elm_colorselector_palette_name_set(Elm_Colorselector *obj, const char *palette_name);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get current palette's name
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return Name of palette
 *
 * @remark Returns the currently set palette name using which colors will be
 * saved/loaded in to config.
 *
 * @ingroup Colorselector
 *
 */
EAPI const char *elm_colorselector_palette_name_get(const Elm_Colorselector *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Set Colorselector's mode.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @remark Colorselector supports three modes palette only, selector only and both.
 *
 * @ingroup Colorselector
 *
 * @param[in] mode Elm_Colorselector_Mode
 */
EAPI void elm_colorselector_mode_set(Elm_Colorselector *obj, Elm_Colorselector_Mode mode);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get Colorselector's mode.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return mode The current mode of colorselector
 *
 * @ingroup Colorselector
 *
 */
EAPI Elm_Colorselector_Mode elm_colorselector_mode_get(const Elm_Colorselector *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Get list of palette items.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return The list of color palette items.
 *
 * @remark Note That palette item list is internally managed by colorselector widget and
 * it should not be freed/modified by application.
 *
 * @since 1.9
 *
 * @ingroup Colorselector
 *
 */
EAPI const Eina_List *elm_colorselector_palette_items_get(const Elm_Colorselector *obj);

/**
 *
 * @internal
 *
 * Get the selected item in colorselector palette.
 *
 * @return The selected item, or NULL if none is selected.
 *
 * @since 1.9
 * @ingroup Colorselector
 *
 */
EAPI Elm_Object_Item *elm_colorselector_palette_selected_item_get(const Elm_Colorselector *obj);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Add a new color item to palette.
 *
 * @if MOBILE @since_tizen 2.3
 * @endif
 *
 * @return A new color palette Item.
 *
 * @ingroup Colorselector
 * 
 *
 * @param[in] r r-value of color
 * @param[in] g g-value of color
 * @param[in] b b-value of color
 * @param[in] a a-value of color
 */
EAPI Elm_Object_Item *elm_colorselector_palette_color_add(Elm_Colorselector *obj, int r, int g, int b, int a);

/**
 *
 * @MOBILE_ONLY
 *
 * @brief Clear the palette items.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @ingroup Colorselector
 * 
 *
 */
EAPI void elm_colorselector_palette_clear(Elm_Colorselector *obj);

#endif
