#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_LEGACY_H_
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_LEGACY_H_

#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_CLASS_TYPE
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_CLASS_TYPE

typedef Eo Elm_Interface_Atspi_Accessible;

#endif

#ifndef _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_TYPES
#define _ELM_INTERFACE_ATSPI_ACCESSIBLE_EO_TYPES


#endif

/**
 *
 * @brief Defines the relationship between two accessible objects.
 *
 * Adds unique relation between source object and relation_object of a
 * given type.
 *
 * Relationships can be queried by Assistive Technology clients to
 * provide customized feedback, improving overall user experience.
 *
 * @remark relationship_append API is asymmetric, which means that
 * appending, for example, relation ELM_ATSPI_RELATION_FLOWS_TO from object A to B,
 * do NOT append relation ELM_ATSPI_RELATION_FLOWS_FROM from object B to
 * object A.
 *
 * @return EINA_TRUE is relationship was successfully appended, EINA_FALSE
 * otherwise
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 * 
 *
 * @param[in] type No description supplied.
 * @param[in] relation_object No description supplied.
 */
EAPI Eina_Bool elm_atspi_accessible_relationship_append(Elm_Interface_Atspi_Accessible *obj, Elm_Atspi_Relation_Type type, const Elm_Interface_Atspi_Accessible *relation_object);

/**
 *
 * @brief Removes the relationship between two accessible objects.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 * 
 *
 * @param[in] type No description supplied.
 * @param[in] relation_object No description supplied.
 */
EAPI void elm_atspi_accessible_relationship_remove(Elm_Interface_Atspi_Accessible *obj, Elm_Atspi_Relation_Type type, const Elm_Interface_Atspi_Accessible *relation_object);

/**
 *
 * @brief Gets the translation domain of "name" and "description"
 * properties.
 *
 * @since_tizen 2.4
 *
 * @return Translation domain of "name" and "description"
 *
 * @ingroup Accessibility
 *
 */
EAPI const char *elm_atspi_accessible_translation_domain_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * @brief Sets the translation domain of "name" and "description"
 * properties.
 *
 * Translation domain should be set if application wants to support i18n
 * for accessibily "name" and "descriptions" properties.
 *
 * When translation domain is set values of "name" and "description"
 * properties will be translated with dgettext function using
 * current translation domain as "domainname" and values of properties as
 * "msgid" parameter.
 *
 * @remark It is up to application developer to ensure that
 * translation files are properly binded to translation domain with
 * bindtextdomain function when accessibility is enabled.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] domain No description supplied.
 */
EAPI void elm_atspi_accessible_translation_domain_set(Elm_Interface_Atspi_Accessible *obj, const char *domain);

/**
 *
 * Gets an localized string describing accessible object role name.
 *
 */
EAPI const char *elm_atspi_accessible_localized_role_name_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * @brief Sets an accessible name of the object. This string should be short,
 * human-readable name identyfing gui element.
 * @since_tizen 2.4
 *
 * Example of good accessible name for icon-only button closing the
 * application might be: "exit" or "quit".
 *
 * @remark Function parameter will not be modified or referenced afterwards.
 *
 * @ingroup Accessibility
 *
 * @param[in] name accessible name
 */
EAPI void elm_atspi_accessible_name_set(Elm_Interface_Atspi_Accessible *obj, char *name);

/**
 *
 * @brief Gets an accessible name of the object.
 * @since_tizen 2.4
 *
 * @return Newly allocated string with object accessible name
 * Should be free by a user
 *
 * @ingroup Accessibility
 *
 */
EAPI char *elm_atspi_accessible_name_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets an all relations between accessible object and other accessible
 * * objects.
 * elements Should be free by a user.
 *
 */
EAPI Elm_Atspi_Relation_Set elm_atspi_accessible_relation_set_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * @brief Sets role of the object in accessibility domain. Role describes
 * a class of gui elements that provides same functionality. Role list is
 * predefined.
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] role No description supplied.
 */
EAPI void elm_atspi_accessible_role_set(Elm_Interface_Atspi_Accessible *obj, Elm_Atspi_Role role);

/**
 *
 * @brief Gets the role of the object in accessibility domain.
 *
 * @since_tizen 2.4
 *
 * @return Acccessible role of the object in accessibility domain
 *
 * @ingroup Accessibility
 *
 */
EAPI Elm_Atspi_Role elm_atspi_accessible_role_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets object's accessible children.
 *
 */
EAPI Eina_List *elm_atspi_accessible_children_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets human-readable string indentifying object accessibility
 * role.
 *
 */
EAPI const char *elm_atspi_accessible_role_name_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets key-value pairs indentifying object extra
 * attributes. Must be free by a user.
 *
 */
EAPI Eina_List *elm_atspi_accessible_attributes_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets index of the child in parent's children list.
 *
 */
EAPI int elm_atspi_accessible_index_in_parent_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * @brief Sets contextual information about object.
 * Description contrary to "name" property contain more verbose
 * information about object. Property may contain description of
 * functionality which given element provides in application.
 *
 * Example of good accessible description for icon-only button closing the
 * application might be: "Close the application".
 *
 * @since_tizen 2.4
 *
 * @ingroup Accessibility
 *
 * @param[in] description No description supplied.
 */
EAPI void elm_atspi_accessible_description_set(Elm_Interface_Atspi_Accessible *obj, const char *description);

/**
 *
 * @brief Gets contextual information about object.
 *
 * @since_tizen 2.4
 *
 * @return Statically allocated string with contextual information
 *
 * @ingroup Accessibility
 *
 */
EAPI const char *elm_atspi_accessible_description_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Sets object accessible parent.
 *
 * @param[in] parent No description supplied.
 */
EAPI void elm_atspi_accessible_parent_set(Elm_Interface_Atspi_Accessible *obj, Elm_Interface_Atspi_Accessible *parent);

/**
 *
 * Gets object accessible parent.
 *
 */
EAPI Elm_Interface_Atspi_Accessible *elm_atspi_accessible_parent_get(const Elm_Interface_Atspi_Accessible *obj);

/**
 *
 * Gets set describing object accessible states.
 *
 */
EAPI Elm_Atspi_State_Set elm_atspi_accessible_state_set_get(const Elm_Interface_Atspi_Accessible *obj);

#endif
